<?php
!defined('BREEZEE') && exit;
// 返回随机字符
function getRandomChars($chartype = 1, $length = 4) {
	$chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
	switch ($chartype) {
		case 1:
			$s = 26;
			$e = 35;
			break;
		case 2:
			$s = 0;
			$e = 25;
			break;
		case 3:
			$s = 0;
			$e = 35;
			break;
	}
	$char = '';
	$i = 1;
	do {
		$char .= $chars{mt_rand($s, $e)};
		$i ++;
	} while ($i <= $length);
	return $char;
}

// 生成验证码图片
function createImage($chars, $width = 60, $height = 16){
	header('Content-type: image/gif');
	$a = $chars{0};
	$b = $chars{1};
	$c = $chars{2};
	$d = $chars{3};
	$im = imagecreate($width, $height);
	$bg = imagecolorallocate($im, 233, 239, 233);
	$fc = imagecolorallocate($im, mt_rand(0,230), mt_rand(0,230), mt_rand(0,230));
	imagestring($im, mt_rand(2,5), mt_rand(0,5), mt_rand(3,3), $a, $fc);
	imagestring($im, mt_rand(2,5), mt_rand(15,25), mt_rand(3,3), $b, $fc);
	imagestring($im, mt_rand(2,5), mt_rand(30,40), mt_rand(3,3), $c, $fc);
	imagestring($im, mt_rand(2,5), mt_rand(45,50), mt_rand(3,3), $d, $fc);
	imagegif($im);
}

// 设置HTTP头信息
function setHeader($header) {
	@header($header);
}

// 禁止缓存
function noCache()
{
	setHeader("Pragma:no-cache\r\n");
	setHeader("Cache-Control:no-cache\r\n");
	setHeader("Expires:0\r\n");
}

// 生成javascript消息转向
function showMessage($message, $direction = '') {
	setHeader("Content-type: text/html; charset=utf-8\r\n");
	echo "<script type='text/javascript'>\n";
	foreach ((array) $message as $msg) echo "alert('$msg')\n";
	if ($direction) echo "window.location.href='$direction';";
	else echo "window.history.go(-1)";
	echo "</script>\n";
	exit;
}

// 生成javascript转向
function directUrl($direction) {
	setHeader("Content-type: text/html; charset=utf-8\r\n");
	echo "<script type='text/javascript'>\n";
	echo "window.location.href='$direction';";
	echo "</script>\n";
	exit;
}

// 取得SQL对象
function getSQLObject($dbhost, $dbuser, $dbpassword, $dbname) {
	$sql = new mMysql($dbhost, $dbuser, $dbpassword, $dbname);
	$sql->query("SET NAMES 'UTF8'");
	return $sql;
}

// 为变量加反斜线
function addArraySlashes($value)
{
	return is_array($value) ? array_map('addArraySlashes', $value) : addslashes($value);
}

// MD5加密密码
function encryptMd5($password) {
	$encryptkeys =  array(
									'0' => '!',
									'1' => '*',
									'3' => '%',
									'4' => '(',
									'5' => '#',
									'6' => ')',
									'7' => '+',
									'8' => '_',
									'9' => '&',
									'a' => '{',
									'c' => '}',
									'd' => 'D',
									'e' => '`',
									'g' => '"',
									'i' => '-',
									'k' => '=',
									'm' => ':',
									'n' => '<',
									'o' => ';',
									'p' => '>',
									'q' => ',',
									's' => '~',
									't' => ' ',
									'u' => 'U',
									'v' => 'V',
									'w' => ']',
									'y' => '?',
									'z' => '['
							);
	$encryptkeysFlip = array_flip($encryptkeys);
	for($i = 0; $i < strlen($password); $i ++) {
		if ($encryptkeys[$password{$i}]) {
			$password{$i} = $encryptkeys[$password{$i}];
		} elseif ($encryptkeysFlip[$password{$i}]) {
			$password{$i} = $encryptkeysFlip[$password{$i}];
		}
	}
	return md5($password);
}

// 过滤HTML
function cHTML($HTML, $br = true) {
	$HTML = htmlspecialchars(trim($HTML));
	$HTML = str_replace("\t", ' ', $HTML);
	if ($br) {
		return nl2br($HTML);
	} else {
		return str_replace("\n", '', $HTML);
	}
}

// 获取IP
function getIP() {
	if (getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP'), 'unknown')) {
		$ip = getenv('HTTP_CLIENT_IP');
	} elseif (getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR'), 'unknown')) {
		$ip = getenv('HTTP_X_FORWARDED_FOR');
	} elseif (getenv('REMOTE_ADDR') && strcasecmp(getenv('REMOTE_ADDR'), 'unknown')) {
		$ip = getenv('REMOTE_ADDR');
	} elseif (isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown')) {
		$ip = $_SERVER['REMOTE_ADDR'];
	}
	preg_match("/[\d\.]{7,15}/", $ip, $ipmatches);
	$ip = $ipmatches[0] ? $ipmatches[0] : 'unknown';
	unset($ipmatches);
	return $ip;
}

// 表单select控件生成
function getFormOption($options, $attributes = '', $valuation = '') {
		$str = '';
		if ($attributes) {
			$str = '<select';
			foreach ($attributes as $key => $value) $str .= " $key=\"$value\"";
			$str .= ">\n";
		} else {
			$str .= "<select>\n";
		}
		foreach ($options as $key => $value) {
			$str .= "<option value=\"$key\"";
			isset($valuation) && $key == $valuation && $str.= ' selected="selected"';
			$str .=">$value</option>\n";
		}
		return $str .= "</select>\n";
}
?>