<?php
!defined('BREEZEE') && exit;
/**
 * 名称 mPage
 * 作者 m35
 * http://mai35.com
**/
class mPage
{
	var $page = array('per' => 10, 'tag' => 'page', 'query' => '', 'num' => '', 'total' => '', 'cur' => '', 'pre' => '', 'next' => '', 'fn' => '');

	function mPage($num, $config = '') {
		$config && $this->init($config);
		$this->paging($num);
	}

	// 初始化配置
	function init($config) {
		foreach ($config as $key => $value) $this->page[$key] && $this->page[$key] = $value;
	}

	// 生成分页信息
	function paging($num) {
		$page =& $this->page;
		$page['num'] = (int) $num;
		$page['total'] = ceil($page['num'] / $page['per']);
		$page['total'] == 0 && $page['total'] = 1;
		if ($_GET[$page['tag']]) {
			$page['cur'] = (int) $_GET[$page['tag']];
		} else {
			$page['cur'] = 1;
		}
		$page['cur'] < 1 && $page['cur'] = 1;
		$page['cur'] > $page['total'] && $page['cur'] = $page['total'];
		$page['cur'] > 1 && $page['pre'] = $page['cur'] - 1;
		$page['cur'] < $page['total'] && $page['next'] = $page['cur'] + 1;
		$page['fn'] = basename($_SERVER['PHP_SELF'] ? $_SERVER['PHP_SELF'] : $_SERVER['SCRIPT_NAME']);
		if ($_SERVER['QUERY_STRING']) {
			$query = explode('&', $_SERVER['QUERY_STRING']);
			foreach ($query as $string) {
				if (ereg("{$page['tag']}=", $string)) continue;
				$page['query'] .= '&amp;' . $string;
			}
		}
	}

	// 返回一个“上一页”连接
	function getPrevious($word = '上一页', $title = '转到上一页', $always = false) {
		if ($this->page['pre'] || $always) {
			$str = $this->getLinkCode($this->page['pre'], $word, $title);
		} else {
			$str = '';
		}
		return $str;
	}

	// 返回一个“下一页”连接
	function getNext($word = '下一页', $title = '转到下一页', $always = false) {
		if ($this->page['next'] || $always) {
			$str = $this->getLinkCode($this->page['next'], $word, $title);
		} else {
			$str = '';
		}
		return $str;
	}

	// 生成页面导航字符串
	function getLinkCode($pnum, $word, $title) {
		$str = '<a href="' . $this->getLink($pnum) . '"';
		$title && $str .= " title=\"{$title}\"";
		$str .= ">{$word}</a>";
		return $str;
	}

	// 输出连接地址
	function getLink($pnum) {
		return "{$this->page['fn']}?{$this->page['tag']}={$pnum}{$this->page['query']}";
	}

	// 取得分页信息
	function getInfo($e = '') {
		if ($this->page[$e]) return $this->page[$e];
		else return $this->page;
	}

	// 生成页面字符串
	function getPageInfo($word = "共{n}条，共{t}页，每页{p}条，当前第{c}页") {
		return str_replace(
			array('{n}', '{t}', '{p}', '{c}'),
			array($this->page['num'], $this->page['total'], $this->page['per'], $this->page['cur']),
			$word);
	}

	// 输出分页结构
	function p() {
		extract($this->page);
		$str = '';
		$str .= "<div class=\"page\">\n";
		$str .= $this->getPrevious('<strong>&lt;</strong>', 'previous page', true);
		for ($i = 1; $i <= $total; $i ++) {
			if ($i == $cur) $str.= "<span>{$i}</span>";
			else $str .= $this->getLinkCode($i, $i, "page{$i}");
		}
		$str .= $this->getNext('&gt;', 'next page', true);
		$info = "<span class=\"page_info\">共<strong>{t}</strong>页/每页<strong>{p}</strong>条</span>";
		return $str . "</div>\n";
	}

	// 输出分页结构
	function p1() {
		extract($this->page);
		$str = '';
		$str .= "<div class=\"page\">\n";
		$str .= $this->getPrevious('&lt;', '上一页', true);
		$str .= $this->getNext('&gt;', '下一页', true);
		for ($i = 1; $i <= $total; $i ++) {
			if ($i == $cur) $str.= "<span class=\"cur_page\">{$i}</span>\n";
			else $str .= ' ' . $this->getLinkCode($i, $i, "第{$i}页");
		}
		$info = "<span class=\"info\">page:<strong>{c}/{t}</strong> total: <strong>{n}</strong></span> <a href=\"#\" title=\"跳到顶部\">top</a>";
		$str .= $this->getPageInfo($info);
		return $str . "</div>\n";
	}
}
?>