function $(id) {
	return document.getElementById(id);
}
function trim(str) {
	return (str + '').replace(/(\s+)$/g, '').replace(/^\s+/g, '');
}
function setHotkey(){
	document.onkeydown = function(e){
		e = e || window.event;
		if (e.keyCode == 27) {
			hideForm();
			return false;
		} else if (e.ctrlKey && e.keyCode == 13 && $('fieldset').style.display == 'block') {
			submitForm();
			return false;
		} else if (!e.ctrlKey && e.keyCode == 13 && $('fieldset').style.display != 'block') {
			showForm();
			return false;
		} 
	}
}
function submitForm() {
	if (!trim($('nickname').value)) {
		alert('请填写昵称');
		$('nickname').focus();
		return false;
	}
	if (!trim($('content').value)) {
		alert('请填写留言');
		$('content').focus();
		return false;
	}
	if ($('code') && trim($('code').value).length != 4) {
		alert('请填写正确的验证码');
		$('code').focus();
		return false;
	}
	$('submit').click();
}
function showForm() {
	$('fieldset').style.display = 'block';
	if (!trim($('nickname').value)) {
		$('nickname').focus();
		return;
	}
	if (!trim($('content').value)) {
		$('content').focus();
		return;
	}
	if ($('code') && trim($('code').value).length != 4) {
		$('code').focus();
		$('code').select();
	}
}
function hideForm() {
	$('fieldset').style.display = '';
}
function createCode() {
	if (!$('codeimage')) {
		var image = document.createElement('img');
		image.src = 'image.php?t=' + Math.random();
		image.alt = '验证码';
		image.title = '点击刷新验证码';
		image.id = 'codeimage';
		image.style.cursor = 'pointer';
		image.onclick = refreshCode;
		this.parentNode.appendChild(image);
	}
}
function refreshCode() {
	this.src = this.src.replace('=\w$', '=' + Math.random());
}
window.onload = function() {
	if (!$('form')) {return false;};
	$('msg').onfocus = function() {
		showForm();
		this.onclick = function () {return false;};
		return false;
	}
	$('close_button').onclick = function() {
		hideForm();
	}
	setHotkey();
	if ($('code')) $('code').onfocus = createCode;
	$('form').onsubmit = submitForm;
}