/*
 * Decompiled with CFR 0.152.
 */
package tot.dao;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataBean;
import tot.bean.DataField;
import tot.db.DBUtils;
import tot.util.GetDate;

public class AbstractDao {
    private static Log log = LogFactory.getLog(AbstractDao.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getData(String sqlStr, String fieldArr) {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<DataField> returnList = new ArrayList<DataField>();
        try {
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sqlStr);
            String[] splitStr = null;
            splitStr = fieldArr.split(",");
            while (rs.next()) {
                DataField df = new DataField();
                for (int i = 0; i < splitStr.length; ++i) {
                    df.setField(splitStr[i], rs.getString(i + 1), 0);
                }
                returnList.add(df);
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                log.info((Object)("catch exception on call method:getdata();\n sql:" + sqlStr));
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        return returnList;
    }

    public Collection getDataList_mysqlLimit(String sqlStr, String fieldArr, int pagesize, int page) {
        StringBuffer sb = new StringBuffer(512);
        sb.append(sqlStr);
        sb.append(" limit " + (page - 1) * pagesize + "," + pagesize);
        return this.getData(sb.toString(), fieldArr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataField getFirstData(String sqlStr, String fieldArr) {
        DataField df;
        ResultSet rs;
        Statement stmt;
        Connection conn;
        block5: {
            conn = null;
            stmt = null;
            rs = null;
            df = null;
            try {
                conn = DBUtils.getConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sqlStr);
                String[] splitStr = null;
                splitStr = fieldArr.split(",");
                if (!rs.next()) break block5;
                df = new DataField();
                for (int i = 0; i < splitStr.length; ++i) {
                    df.setField(splitStr[i], rs.getString(i + 1), 0);
                }
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    log.info((Object)("catch exception on call method:getdata(); \n sql:" + sqlStr));
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(rs);
                    DBUtils.closeStatement(stmt);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        return df;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDataCount(String sqlStr) {
        int returnInt;
        ResultSet rs;
        Statement stmt;
        Connection conn;
        block4: {
            conn = null;
            stmt = null;
            rs = null;
            returnInt = 0;
            try {
                conn = DBUtils.getConnection();
                Object resultSet = null;
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sqlStr);
                if (!rs.next()) break block4;
                returnInt = rs.getInt(1);
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    log.info((Object)("catch exception on call method:getdata(); \n sql:" + sqlStr));
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(rs);
                    DBUtils.closeStatement(stmt);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        return returnInt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean insertOrUpdate(String sqlStr, DataField df) {
        Connection conn = null;
        PreparedStatement ps = null;
        Hashtable hs = df.getFields();
        Enumeration enumerat = hs.keys();
        boolean returnValue = true;
        int i = 1;
        try {
            ps = conn.prepareStatement(sqlStr);
            while (enumerat.hasMoreElements()) {
                String s = (String)enumerat.nextElement();
                DataBean dfm = (DataBean)hs.get(i + "");
                if (dfm.DataType == 1) {
                    ps.setInt(i, Integer.parseInt(dfm.FieldValue));
                } else if (dfm.DataType == 2) {
                    Date today = null;
                    try {
                        today = GetDate.string2Date(dfm.FieldValue);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ps.setDate(i, today);
                } else {
                    ps.setString(i, dfm.FieldValue);
                }
                ++i;
            }
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
        }
        catch (SQLException e) {
            log.info((Object)("catch exception when call insertOrUpdate method: \n" + sqlStr));
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exe(String sqlStr) {
        Connection conn = null;
        Statement stmt = null;
        boolean returnValue = true;
        try {
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            returnValue = stmt.executeUpdate(sqlStr) == 1;
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                log.info((Object)("catch exception on call method:getdata(); \n sql:" + sqlStr));
            }
            catch (Throwable throwable) {
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        return returnValue;
    }
}

