/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.dao.AbstractDao;
import tot.db.DBUtils;

public class PostDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(PostDaoImplJDBC.class);

    public Collection getPostList(int catalogId, int pageSize, int currentPage) {
        StringBuffer sql = new StringBuffer(512);
        String fieldArr = "id,f_user,f_title,f_content,f_reply,f_emot,f_homepage,f_email,f_im,f_ip,f_date,f_pass,f_hidden,f_catalogid";
        if (DBUtils.getDatabaseType() == 11) {
            sql.append("select top ");
            sql.append(pageSize);
            sql.append(fieldArr);
            sql.append(" from t_post where id not in(select top ");
            sql.append((currentPage - 1) * pageSize);
            sql.append(" id from t_post where f_catalogid=");
            sql.append(catalogId);
            sql.append(" order by id desc)");
            sql.append(" and f_catalogid=");
            sql.append(catalogId);
            sql.append(" order by id desc");
        } else if (DBUtils.getDatabaseType() == 15) {
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_post");
            sql.append(" where f_catalogid=");
            sql.append(catalogId);
            sql.append(" order by id desc limit ");
            sql.append((currentPage - 1) * pageSize);
            sql.append(",");
            sql.append(pageSize);
        }
        return this.getData(sql.toString(), fieldArr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reply(String content, int postid, Timestamp replydate) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("update t_post set f_reply=?,f_replytime=? where id=?");
            ps.setString(1, content);
            ps.setTimestamp(2, replydate);
            ps.setInt(3, postid);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
        }
        catch (SQLException e) {
            boolean bl;
            try {
                e.printStackTrace();
                bl = false;
            }
            catch (Throwable throwable) {
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
            return bl;
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String username, String title, String contnet, String emot, String homepage, String email, String im, String ip, Timestamp postDate, String pass, int hidden, int catalogid) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        String sql = "insert into t_post(f_user,f_title,f_content,f_emot,f_homepage,f_email,f_im,f_ip,f_date,f_pass,f_hidden,f_catalogid) values(?,?,?,?,?,?,?,?,?,?,?,?)";
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, username);
            ps.setString(2, title);
            ps.setString(3, contnet);
            ps.setString(4, emot);
            ps.setString(5, homepage);
            ps.setString(6, email);
            ps.setString(7, im);
            ps.setString(8, ip);
            ps.setTimestamp(9, postDate);
            ps.setString(10, pass);
            ps.setInt(11, hidden);
            ps.setInt(12, catalogid);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
        }
        catch (SQLException e) {
            boolean bl;
            try {
                log.info((Object)("catch exception when call add method: \n" + sql));
                e.printStackTrace();
                bl = false;
            }
            catch (Throwable throwable) {
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
            return bl;
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean delePost(int postid) {
        return this.exe("delete from t_post where id=" + postid);
    }

    public int getPostNum(int catalogId) {
        int returnValue = 0;
        String sql = "select count(*) from t_post where f_catalogid=" + catalogId;
        returnValue = this.getDataCount(sql);
        return returnValue;
    }
}

