/*
 * Decompiled with CFR 0.152.
 */
package tot.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.db.DBOptions;
import tot.global.Sysconfig;

class DBConnectionManager {
    private static Log log = LogFactory.getLog(DBConnectionManager.class);
    private static final int TIME_BETWEEN_RETRIES = 500;
    private static DBConnectionManager instance = null;
    private DBConnectionPool pool = null;

    private DBConnectionManager(DBOptions option) {
        try {
            Class.forName(option.driverClassName).newInstance();
        }
        catch (Exception e) {
            log.fatal((Object)("DBConnectionManager: Unable to load driver = " + option.driverClassName));
        }
        this.pool = new DBConnectionPool(option.databaseURL, option.databaseUser, option.databasePassword, option.maxConnection);
    }

    private DBConnectionManager() {
        String driverClassName = Sysconfig.getDriverClassName();
        try {
            Class.forName(driverClassName).newInstance();
        }
        catch (Exception e) {
            log.fatal((Object)("DBConnectionManager: Unable to load driver = " + driverClassName));
        }
        String url = Sysconfig.getDatabaseURL();
        String user = Sysconfig.getDatabaseUser();
        String password = Sysconfig.getDatabasePassword();
        int maxConnection = Sysconfig.getMaxConnection();
        this.pool = new DBConnectionPool(url, user, password, maxConnection);
    }

    public static synchronized DBConnectionManager getInstance(boolean useConfig) {
        if (instance == null) {
            instance = new DBConnectionManager();
        }
        return instance;
    }

    void freeConnection(Connection con) {
        this.pool.freeConnection(con);
    }

    Connection getConnection() {
        return this.pool.getConnection();
    }

    Connection getConnection(long time) {
        return this.pool.getConnection(time);
    }

    boolean release() {
        return this.pool.release();
    }

    class DBConnectionPool {
        private int checkedOut = 0;
        private Vector freeConnections = new Vector();
        private int maxConn = 0;
        private String password = null;
        private String URL = null;
        private String user = null;

        public DBConnectionPool(String URL2, String user, String password, int maxConn) {
            this.URL = URL2;
            this.user = user;
            this.password = password;
            this.maxConn = maxConn;
        }

        synchronized void freeConnection(Connection con) {
            if (con != null) {
                if (this.checkedOut <= 0) {
                    try {
                        log.debug((Object)"DBConnectionManager: about to close the orphan connection.");
                        con.close();
                    }
                    catch (SQLException sQLException) {}
                } else {
                    this.freeConnections.addElement(con);
                    --this.checkedOut;
                    this.notifyAll();
                }
            }
        }

        synchronized Connection getConnection() {
            Connection con = null;
            while (this.freeConnections.size() > 0 && con == null) {
                con = (Connection)this.freeConnections.firstElement();
                this.freeConnections.removeElementAt(0);
                try {
                    if (!con.isClosed()) continue;
                    log.info((Object)"Removed bad connection in DBConnectionPool.");
                    con = null;
                }
                catch (SQLException e) {
                    con = null;
                }
            }
            if (con == null && (this.maxConn == 0 || this.checkedOut < this.maxConn)) {
                con = this.newConnection();
            }
            if (con != null) {
                ++this.checkedOut;
            }
            return con;
        }

        Connection getConnection(long timeout) {
            Connection con;
            long startTime = System.currentTimeMillis();
            while ((con = this.getConnection()) == null) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                if (elapsedTime >= timeout) {
                    return null;
                }
                long timeToWait = timeout - elapsedTime;
                if (timeToWait > 500L) {
                    timeToWait = 500L;
                }
                try {
                    Thread.sleep(timeToWait);
                }
                catch (InterruptedException e) {}
            }
            return con;
        }

        synchronized boolean release() {
            boolean retValue = true;
            Enumeration allConnections = this.freeConnections.elements();
            while (allConnections.hasMoreElements()) {
                Connection con = (Connection)allConnections.nextElement();
                try {
                    con.close();
                }
                catch (SQLException e) {
                    log.error((Object)"Cannot close connection in DBConnectionPool.");
                }
            }
            this.freeConnections.removeAllElements();
            if (this.checkedOut != 0) {
                retValue = false;
                log.warn((Object)"DBConnectionManager: the built-in connection pool is not balanced.");
            }
            this.checkedOut = 0;
            return retValue;
        }

        private Connection newConnection() {
            Connection con = null;
            try {
                con = this.user == null ? DriverManager.getConnection(this.URL) : DriverManager.getConnection(this.URL, this.user, this.password);
                con.setAutoCommit(true);
            }
            catch (SQLException e) {
                log.error((Object)("Cannot create a new connection in DBConnectionPool. URL = " + this.URL), (Throwable)e);
                return null;
            }
            return con;
        }
    }
}

