/*
 * Decompiled with CFR 0.152.
 */
package tot.util;

import java.util.ArrayList;
import java.util.Iterator;

class ControlledIP {
    private int actionsPerHour = 0;
    private long lastRemoveTime = 0L;
    private long lastIncrementTime = 0L;
    private ArrayList actionHistoryList = new ArrayList();

    ControlledIP(int actionsPerHour) {
        if (actionsPerHour >= 0) {
            this.actionsPerHour = actionsPerHour;
        }
    }

    void setActionsPerHour(int actionsPerHour) {
        if (actionsPerHour >= 0) {
            this.actionsPerHour = actionsPerHour;
        }
    }

    long getLastIncrementTime() {
        return this.lastIncrementTime;
    }

    void increaseCount() {
        long now;
        this.lastIncrementTime = now = System.currentTimeMillis();
        this.actionHistoryList.add(new Long(now));
    }

    void resetActionHistory() {
        this.lastRemoveTime = 0L;
        this.lastIncrementTime = 0L;
        this.actionHistoryList.clear();
    }

    boolean reachMaximum() {
        if (this.actionsPerHour == 0) {
            return false;
        }
        if (this.actionHistoryList.size() < this.actionsPerHour) {
            return false;
        }
        this.removeTimeoutActions();
        return this.actionHistoryList.size() >= this.actionsPerHour;
    }

    private synchronized void removeTimeoutActions() {
        long now = System.currentTimeMillis();
        if (now - this.lastRemoveTime > 2000L) {
            this.lastRemoveTime = now;
            Iterator iter = this.actionHistoryList.iterator();
            while (iter.hasNext()) {
                Long currentAction = (Long)iter.next();
                if (now - currentAction <= 10000L) continue;
                iter.remove();
            }
        }
    }
}

