/*
 * Decompiled with CFR 0.152.
 */
package tot.util;

class DurationFormater {
    public static final long MILISECONDS_PER_SECOND = 1000L;
    public static final long SECONDS_PER_MINUTE = 60L;
    public static final long MINUTES_PER_HOUR = 60L;
    public static final long HOURS_PER_DAY = 24L;
    public static final int MILISECOND = 0;
    public static final int SECOND = 1;
    public static final int MINUTE = 2;
    public static final int HOUR = 3;
    public static final int DAY = 4;
    public static final String[] PATTERNS = new String[]{"@ms", "@s", "@m", "@h", "@d"};
    private static final long[] AMOUNTS = new long[]{1000L, 60L, 60L, 24L};
    private static long[] times = new long[5];
    private long time;
    private String pattern;
    private boolean detail = false;

    public DurationFormater() {
    }

    public DurationFormater(long time, String pattern) {
        this.time = time;
        this.pattern = pattern;
        this.update();
    }

    public DurationFormater(long time) {
        this.time = time;
        this.update();
    }

    private void update() {
        long remain = this.time;
        for (int i = 0; i < AMOUNTS.length; ++i) {
            DurationFormater.times[i] = remain % AMOUNTS[i];
            remain /= AMOUNTS[i];
        }
        DurationFormater.times[4] = (int)remain;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long duration) {
        this.time = duration;
        this.update();
    }

    public long getMiliseconds() {
        return times[0];
    }

    public long getSeconds() {
        return times[1];
    }

    public long getMinutes() {
        return times[2];
    }

    public long getHours() {
        return times[3];
    }

    public long getDays() {
        return times[4];
    }

    public void setDetail(boolean detail) {
        this.detail = detail;
    }

    public String getString() {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(this.pattern);
        for (int i = 0; i < PATTERNS.length; ++i) {
            int start = -1;
            int end = -1;
            while ((start = buffer.toString().indexOf(PATTERNS[i])) > -1) {
                end = start + PATTERNS[i].length();
                buffer.replace(start, end, String.valueOf(times[i]));
            }
        }
        return buffer.toString();
    }

    public String toString() {
        if (this.pattern != null) {
            return this.getString();
        }
        StringBuffer desc = new StringBuffer(256);
        if (times[4] > 0L) {
            desc.append(DurationFormater.checkPlural(times[4], "day"));
        }
        if (times[3] > 0L) {
            desc.append(DurationFormater.checkPlural(times[3], "hour"));
        }
        if (times[2] > 0L || times[4] == 0L && times[2] == 0L) {
            desc.append(DurationFormater.checkPlural(times[2], "minute"));
        }
        if (this.detail) {
            desc.append(DurationFormater.checkPlural(times[1], "second"));
            desc.append(DurationFormater.checkPlural(times[0], "milisecond"));
        }
        return desc.toString();
    }

    private static String checkPlural(long amount, String unit) {
        StringBuffer desc = new StringBuffer(20);
        desc.append(amount).append(" ").append(unit);
        if (amount > 1L) {
            desc.append("s");
        }
        return desc.append(" ").toString();
    }
}

