/*
 * Decompiled with CFR 0.152.
 */
package tot.util;

import java.io.UnsupportedEncodingException;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringUtils {
    private static Log log = LogFactory.getLog(StringUtils.class);
    public static final String EN = "ISO-8859-1";
    public static final String CN = "GBK";

    public static String ISO2GB(String isoStr) throws UnsupportedEncodingException {
        return new String(isoStr.getBytes(EN), CN);
    }

    public static String GB2ISO(String gbStr) throws UnsupportedEncodingException {
        return new String(gbStr.getBytes(CN), EN);
    }

    public static String getIP(HttpServletRequest request) {
        String ip = request.getRemoteAddr();
        return ip != null ? ip : "";
    }

    public static String replaceChar(String source, char oldChar, char newChar) {
        if (source == null) {
            return "";
        }
        return source.replace(oldChar, newChar);
    }

    public static String replaceString(String source, String oldString, String newString) {
        if (source == null || oldString == null || newString == null) {
            return "";
        }
        return StringUtils.replace(source, oldString, newString);
    }

    public static String[] split(String source, String regex) {
        if (source == null || source.equals("")) {
            return new String[0];
        }
        return source.split(regex);
    }

    private static String replace(String source, String oldString, String newString) {
        int pos;
        StringBuffer output = new StringBuffer();
        int lengthOfSource = source.length();
        int lengthOfOld = oldString.length();
        int posStart = 0;
        while ((pos = source.indexOf(oldString, posStart)) >= 0) {
            output.append(source.substring(posStart, pos));
            output.append(newString);
            posStart = pos + lengthOfOld;
        }
        if (posStart < lengthOfSource) {
            output.append(source.substring(posStart));
        }
        return output.toString();
    }

    public static String toQuoteMark(String str) {
        str = StringUtils.replaceString(str, "'", "&#39;");
        str = StringUtils.replaceString(str, "\"", "&#34;");
        str = StringUtils.replace(str, "\\", "&#92;");
        str = StringUtils.replaceString(str, "\r\n", "\n");
        str = StringUtils.replaceString(str, "\\n", "\n");
        return str;
    }

    public static String toHtml(String str) {
        str = StringUtils.replaceString(str, "<", "&#60;");
        str = StringUtils.replaceString(str, ">", "&#62;");
        return str;
    }

    public static String toBR(String str) {
        str = StringUtils.replaceString(str, "\\n", "\n");
        str = StringUtils.replaceString(str, "\n", "<br>\n");
        str = StringUtils.replaceString(str, "  ", "&nbsp;&nbsp;");
        return str;
    }

    public static String toSQL(String str) {
        str = StringUtils.replaceString(str, "\r\n", "\n");
        return str;
    }

    public static String htmlFilter(String str) {
        StringBuffer stringbuffer = new StringBuffer();
        block9: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\'': {
                    stringbuffer.append("&#039;");
                    continue block9;
                }
                case '\"': {
                    stringbuffer.append("&quot;");
                    continue block9;
                }
                case '<': {
                    stringbuffer.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringbuffer.append("&gt;");
                    continue block9;
                }
                case '&': {
                    stringbuffer.append("&amp;");
                    continue block9;
                }
                case ' ': {
                    stringbuffer.append("&nbsp;");
                    continue block9;
                }
                case '\n': {
                    stringbuffer.append("<br>");
                    continue block9;
                }
                default: {
                    stringbuffer.append(c);
                }
            }
        }
        return stringbuffer.toString();
    }

    public static String base64Encode(String str) {
        if (str != null && str.length() > 0) {
            str = new String(new Base64().encode(str.getBytes()));
        }
        return str;
    }

    public static String base64Decode(String str) {
        if (str != null && str.length() > 0) {
            byte[] buf = new Base64().decode(str.getBytes());
            str = new String(buf);
        }
        return str;
    }

    public static String base64Encode(byte[] str) {
        String encodeStr = "";
        if (str != null && str.length > 0) {
            encodeStr = new String(new Base64().encode(str));
        }
        return encodeStr;
    }

    public static byte[] base64DecodeForByte(String str) {
        byte[] buf = null;
        if (str != null && str.length() > 0) {
            buf = new Base64().decode(str.getBytes());
        }
        return buf;
    }

    public static String getRandomNumber(int bits, int to) {
        StringBuffer randBuffer = new StringBuffer();
        Random RANDOM = new Random();
        for (int i = 1; i <= bits; ++i) {
            randBuffer.append(RANDOM.nextInt(to));
        }
        return randBuffer.toString();
    }

    public static String urlEncode(String str) throws EncoderException {
        URLCodec URLCODEC = new URLCodec("UTF-8");
        return URLCODEC.encode(str);
    }

    public static String urlDecode(String str) throws DecoderException {
        return str;
    }

    public static String getSQL(String sql, boolean hasOffset, int from, int to) {
        return StringUtils.getMysqlSQL(sql, hasOffset);
    }

    public static String getMysqlSQL(String sql, boolean hasOffset) {
        StringBuffer sb = new StringBuffer(sql.length() + 20);
        sb.append(sql).append(hasOffset ? " limit ?, ?" : " limit ?");
        return sb.toString();
    }

    public static String getDb2SQL(String sql, boolean hasOffset) {
        StringBuffer sb = new StringBuffer(sql.length() + 100);
        return sb.toString();
    }

    public static String getOracleSQL(String sql, boolean hasOffset) {
        StringBuffer sb = new StringBuffer(sql.length() + 100);
        return sb.toString();
    }

    public static String getMssqlSQL(String sql, boolean hasOffset, int from, int to) {
        StringBuffer sb = new StringBuffer(sql.length() + 100);
        return sb.toString();
    }

    private static String getRowNumber(String sql) {
        StringBuffer rownumber = new StringBuffer(50);
        return rownumber.toString();
    }

    private static int getAfterSelectInsertPoint(String sql) {
        int selectIndex = sql.indexOf("select");
        return selectIndex + 6;
    }

    public static String getTopic(String str, int max) {
        String tempStr = null;
        tempStr = str;
        if (tempStr.length() > max) {
            tempStr = tempStr.substring(0, max) + "...";
            return tempStr;
        }
        return tempStr;
    }

    public static String removeHtml(String str) {
        String tempStr = null;
        tempStr = str;
        Pattern pattern = Pattern.compile("<.+?>");
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            tempStr = matcher.replaceAll("");
        }
        return tempStr;
    }

    public static String returnToBr(String s) {
        if (s == null || s.equals("")) {
            return s;
        }
        StringBuffer stringbuffer = new StringBuffer();
        for (int i = 0; i <= s.length() - 1; ++i) {
            stringbuffer = s.charAt(i) == '\r' ? stringbuffer.append("<br>") : (s.charAt(i) == ' ' ? stringbuffer.append("&nbsp;") : stringbuffer.append(s.substring(i, i + 1)));
        }
        String s1 = stringbuffer.toString();
        return s1;
    }

    public static String returnToHTML(String s) {
        if (s == null || s.equals("")) {
            return s;
        }
        StringBuffer stringbuffer = new StringBuffer();
        for (int i = 0; i <= s.length() - 1; ++i) {
            stringbuffer = s.charAt(i) == '<' ? stringbuffer.append("&lt;") : (s.charAt(i) == '>' ? stringbuffer.append("&gt;") : stringbuffer.append(s.substring(i, i + 1)));
        }
        String s1 = stringbuffer.toString();
        return s1;
    }
}

