/*
 * Decompiled with CFR 0.152.
 */
package tot.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.util.MD5;

public class AdminDaoImplJDBC
extends AbstractDao {
    private static Log log = LogFactory.getLog(AdminDaoImplJDBC.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean adminAdd(String admin, String passwd, int catalogid) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        String sql = "insert into t_admin(admin,passwd,catalogid) values(?,?,?)";
        try {
            MD5 md5 = new MD5();
            String password = md5.getMD5of32(passwd);
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, admin);
            ps.setString(2, password);
            ps.setInt(3, catalogid);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
        }
        catch (SQLException e) {
            boolean bl;
            try {
                e.printStackTrace();
                bl = false;
            }
            catch (Throwable throwable) {
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
            return bl;
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean adminMod(String admin, String passwd, int catalogid, int adminid) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        String sql = "update t_admin set admin=?,passwd=?,catalogid=? where id=?";
        try {
            MD5 md5 = new MD5();
            String password = md5.getMD5of32(passwd);
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, admin);
            ps.setString(2, password);
            ps.setInt(3, catalogid);
            ps.setInt(4, adminid);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
        }
        catch (SQLException e) {
            boolean bl;
            try {
                e.printStackTrace();
                bl = false;
            }
            catch (Throwable throwable) {
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
            return bl;
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public boolean deleAdmin(int adminid) {
        return this.exe("delete from t_admin where id=" + adminid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean adminLogin(String admin, String passwd, int catalogid) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean returnValue = false;
        try {
            MD5 md5 = new MD5();
            String password = md5.getMD5of32(passwd);
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("select id from t_admin where admin=? and passwd=? and catalogid=?");
            ps.setString(1, admin);
            ps.setString(2, password);
            ps.setInt(3, catalogid);
            rs = ps.executeQuery();
            if (rs.next()) {
                returnValue = true;
            }
        }
        catch (SQLException e) {
            boolean bl;
            try {
                e.printStackTrace();
                bl = false;
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
            return bl;
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    public Collection getAdminList(int pageSize, int currentPage) {
        StringBuffer sql = new StringBuffer(512);
        String fieldArr = "id,admin,catalogid";
        if (DBUtils.getDatabaseType() == 11) {
            sql.append("select top ");
            sql.append(pageSize);
            sql.append(fieldArr);
            sql.append(" from t_admin where id not in(select top ");
            sql.append((currentPage - 1) * pageSize);
            sql.append(" id from t_catalog");
            sql.append(" order by id desc)");
            sql.append(" order by id desc");
        } else if (DBUtils.getDatabaseType() == 15) {
            sql.append("select ");
            sql.append(fieldArr);
            sql.append(" from t_admin");
            sql.append(" order by id desc limit ");
            sql.append((currentPage - 1) * pageSize);
            sql.append(",");
            sql.append(pageSize);
        }
        return this.getData(sql.toString(), fieldArr);
    }

    public DataField getAdmin(int id) {
        String sql = "select admin,catalogid from t_admin where id=" + id;
        String fieldArr = "admin,catalogid";
        return this.getFirstData(sql, fieldArr);
    }

    public int getAdminNum() {
        int returnValue = 0;
        String sql = "select count(*) from t_admin";
        returnValue = this.getDataCount(sql);
        return returnValue;
    }
}

