/*
 * Decompiled with CFR 0.152.
 */
package tot.global;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.util.FileUtil;
import tot.xml.DOM4JConfiguration;

public class Sysconfig {
    private static Log log = LogFactory.getLog(Sysconfig.class);
    static final String OPTION_FILE_NAME = "totgb.xml";
    private static boolean useDataSource = false;
    private static String dataSourceName = "";
    private static int databaseType = 0;
    private static String driverClassName = "org.gjt.mm.mysql.Driver";
    private static String databaseURL = "jdbc:mysql://127.0.0.1/bbs?useUnicode=true&characterEncoding=utf-8";
    private static String databaseUser = "root";
    private static String databasePassword = "";
    private static int maxConnection = 20;
    private static int maxTimeToWait = 2000;
    private static int minutesBetweenRefresh = 30;
    private static String mailServer = "mail.yourdomain";
    private static int mailServerPort = 25;
    private static String defaultMailFrom = "youruser@yourdomain";
    private static String mailUserName = "";
    private static String mailPassword = "";
    private static String contextPath = "";
    private static String serverPath = "http://localhost:8080";
    private static int serverHourOffset = 0;
    private static String blockedUserAgents = "";
    private static String blockedIPs = "";

    public static boolean isUseDataSource() {
        return useDataSource;
    }

    public static String getDataSourceName() {
        return dataSourceName;
    }

    public static int getDatabaseType() {
        return databaseType;
    }

    public static String getDriverClassName() {
        return driverClassName;
    }

    public static String getDatabaseURL() {
        return databaseURL;
    }

    public static String getDatabaseUser() {
        return databaseUser;
    }

    public static String getDatabasePassword() {
        return databasePassword;
    }

    public static int getMaxConnection() {
        return maxConnection;
    }

    public static int getMaxTimeToWait() {
        return maxTimeToWait;
    }

    public static int getMinutesBetweenRefresh() {
        return minutesBetweenRefresh;
    }

    public static String getMailServer() {
        return mailServer;
    }

    public static int getMailServerPort() {
        return mailServerPort;
    }

    public static String getDefaultMailFrom() {
        return defaultMailFrom;
    }

    public static String getMailUserName() {
        return mailUserName;
    }

    public static String getMailPassword() {
        return mailPassword;
    }

    public static String getContextPath() {
        return contextPath;
    }

    public static String getServerPath() {
        return serverPath;
    }

    public static int getServerHourOffset() {
        return serverHourOffset;
    }

    public static String getBlockedUserAgents() {
        return blockedUserAgents;
    }

    public static String getBlockedIPs() {
        return blockedIPs;
    }

    public static void load() {
        Sysconfig.reload();
    }

    public static void reload() {
        String classPath = FileUtil.getServletClassesPath();
        String configFilename = classPath + OPTION_FILE_NAME;
        try {
            DOM4JConfiguration conf = new DOM4JConfiguration(new File(configFilename));
            useDataSource = conf.getBoolean("dboptions.use_datasource", false);
            databaseType = conf.getInt("dboptions.database_type", 0);
            if (useDataSource) {
                dataSourceName = conf.getString("dboptions.datasource_name");
            } else {
                driverClassName = conf.getString("dboptions.driver_class_name", driverClassName);
                databaseURL = conf.getString("dboptions.database_url", databaseURL);
                databaseUser = conf.getString("dboptions.database_user", databaseUser);
                databasePassword = conf.getString("dboptions.database_password", databasePassword);
                maxConnection = conf.getInt("dboptions.max_connection", maxConnection);
                maxTimeToWait = conf.getInt("dboptions.max_time_to_wait", maxTimeToWait);
                if ((minutesBetweenRefresh = conf.getInt("dboptions.minutes_between_refresh", minutesBetweenRefresh)) < 1) {
                    minutesBetweenRefresh = 1;
                }
            }
            mailServer = conf.getString("mailoptions.mail_server", mailServer);
            defaultMailFrom = conf.getString("mailoptions.default_mail_from", defaultMailFrom);
            mailUserName = conf.getString("mailoptions.username", mailUserName);
            mailPassword = conf.getString("mailoptions.password", mailPassword);
            mailServerPort = conf.getInt("mailoptions.port", mailServerPort);
            contextPath = conf.getString("paramoptions.context_path", contextPath);
            serverPath = conf.getString("paramoptions.server_path", serverPath);
            if (serverPath.endsWith("/")) {
                serverPath = serverPath.substring(0, serverPath.length() - 1);
            }
            if ((serverHourOffset = conf.getInt("dateoptions.server_hour_offset", serverHourOffset)) < -13 || serverHourOffset > 13) {
                serverHourOffset = 0;
            }
            blockedUserAgents = conf.getString("useragentoptions.blocked_user_agent", blockedUserAgents);
            blockedIPs = conf.getString("ipoptions.blocked_ip", blockedIPs);
        }
        catch (Exception e) {
            String message = "global.Sysconfig: Can't read the configuration file: '" + configFilename + "'. Make sure the file is in your CLASSPATH";
            log.error((Object)message, (Throwable)e);
        }
    }

    static {
        Sysconfig.load();
    }
}

