/*
 * Decompiled with CFR 0.152.
 */
package tot.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import tot.global.Sysconfig;
import tot.util.DurationFormater;

public final class DateUtil {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static final long YEAR = 31536000000L;
    public static final long GMT_VIETNAM_TIME_OFFSET = 25200000L;
    public static final String RFC_822_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss Z";
    public static final String ISO_8601_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String UTC_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static DateFormat ddMMyyyyFormat = new SimpleDateFormat("dd/MM/yyyy");
    private static DateFormat yyyyMMddFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static DateFormat rfc822Format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
    private static DateFormat iso8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
    private static DateFormat dateFormat = DateFormat.getDateInstance(2);
    private static DateFormat datetimeFormat = DateFormat.getDateTimeInstance(2, 2);
    private static DateFormat headerTimeFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);

    private DateUtil() {
    }

    public static synchronized String getDateDDMMYYYY(Date date) {
        return ddMMyyyyFormat.format(date);
    }

    public static synchronized String getDateYYYYMMDD(Date date) {
        return yyyyMMddFormat.format(date);
    }

    public static synchronized String getDateRFC822(Date date) {
        return rfc822Format.format(date);
    }

    public static synchronized String getDateISO8601(Date date) {
        return iso8601Format.format(date);
    }

    public static synchronized String getHTTPHeaderTime(Date date) {
        return headerTimeFormat.format(date);
    }

    public static synchronized String formatDate(Date date) {
        return dateFormat.format(date);
    }

    public static synchronized String formatDateTime(Date date) {
        return datetimeFormat.format(date);
    }

    public static Timestamp getCurrentGMTTimestamp() {
        return new Timestamp(System.currentTimeMillis() - 3600000L * (long)Sysconfig.getServerHourOffset());
    }

    public static void updateCurrentGMTTimestamp(Timestamp timeToUpdate) {
        timeToUpdate.setTime(System.currentTimeMillis() - 3600000L * (long)Sysconfig.getServerHourOffset());
    }

    public static Date getVietnamDateFromGMTDate(Date date) {
        return new Date(date.getTime() + 25200000L);
    }

    public static Date convertGMTDate(Date gmtDate, int hourOffset) {
        return new Date(gmtDate.getTime() + (long)hourOffset * 3600000L);
    }

    public static Timestamp convertGMTTimestamp(Timestamp gmtTimestamp, int hourOffset) {
        return new Timestamp(gmtTimestamp.getTime() + (long)hourOffset * 3600000L);
    }

    public static Timestamp getCurrentGMTTimestampExpiredYear(int offsetYear) {
        Calendar now = Calendar.getInstance();
        now.add(1, offsetYear);
        return new Timestamp(now.getTime().getTime());
    }

    public static Timestamp getCurrentGMTTimestampExpiredMonth(int offsetMonth) {
        Calendar now = Calendar.getInstance();
        now.add(2, offsetMonth);
        return new Timestamp(now.getTime().getTime());
    }

    public static Timestamp getCurrentGMTTimestampExpiredDay(int offsetDay) {
        Calendar now = Calendar.getInstance();
        now.add(5, offsetDay);
        return new Timestamp(now.getTime().getTime());
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.US);
        return formatter.format(date);
    }

    public static String formatDuration(long duration, String pattern) {
        DurationFormater time = new DurationFormater(duration, pattern);
        return time.toString();
    }

    public static String formatDuration(long duration) {
        DurationFormater time = new DurationFormater(duration, null);
        return time.toString();
    }

    public static void main(String[] agrs) {
        long duration = 11236800000L;
        System.out.println(duration);
        System.out.println("Duration of " + duration + " duration = " + DateUtil.formatDuration(duration));
    }

    static {
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        headerTimeFormat.setTimeZone(gmt);
    }
}

