/*
 * Decompiled with CFR 0.152.
 */
package tot.xml;

import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import tot.xml.Configuration;

public class ConfigurationUtils {
    protected static String fileSeparator = System.getProperty("file.separator");

    private ConfigurationUtils() {
    }

    public static void dump(Configuration configuration, PrintStream out) {
        Iterator i = configuration.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = configuration.getProperty(key);
            out.print(key);
            out.print("=");
            out.print(value);
            if (!i.hasNext()) continue;
            out.println();
        }
    }

    public static void dump(Configuration configuration, PrintWriter out) {
        Iterator i = configuration.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = configuration.getProperty(key);
            out.print(key);
            out.print("=");
            out.print(value);
            if (!i.hasNext()) continue;
            out.println();
        }
    }

    public static String toString(Configuration configuration) {
        StringWriter writer = new StringWriter();
        ConfigurationUtils.dump(configuration, new PrintWriter(writer));
        return writer.toString();
    }

    public static URL getURL(String basePath, String file) throws MalformedURLException {
        File f = new File(file);
        if (f.isAbsolute()) {
            return f.toURL();
        }
        try {
            if (basePath == null) {
                return new URL(file);
            }
            URL base = new URL(basePath);
            return new URL(base, file);
        }
        catch (MalformedURLException uex) {
            return ConfigurationUtils.constructFile(basePath, file).toURL();
        }
    }

    static File constructFile(String basePath, String fileName) {
        File file = null;
        if (StringUtils.isEmpty((String)basePath)) {
            file = new File(fileName);
        } else {
            StringBuffer fName = new StringBuffer();
            fName.append(basePath);
            if (!basePath.endsWith(fileSeparator)) {
                fName.append(fileSeparator);
            }
            if (fileName.startsWith("." + fileSeparator)) {
                fName.append(fileName.substring(2));
            } else {
                fName.append(fileName);
            }
            file = new File(fName.toString());
        }
        return file;
    }
}

