/*
 * AdminDaoImplJDBC.java
 *
 * Created on 200681, 2:51
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.util.MD5;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author Administrator
 */
public class AdminDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(AdminDaoImplJDBC.class);
    /** Creates a new instance of AdminDaoImplJDBC */
    public AdminDaoImplJDBC() {
    }
    public boolean adminAdd(String admin,String passwd,int catalogid){
        Connection conn = null;
        PreparedStatement ps = null;        
        boolean returnValue=true;
        String sql="insert into t_admin(admin,passwd,catalogid) values(?,?,?)";
        try{
            MD5 md5=new MD5();
            String password=md5.getMD5of32(passwd);
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1, admin);
            ps.setString(2, password);
            ps.setInt(3, catalogid);            
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){            
            e.printStackTrace();
            return false;
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean adminMod(String admin,String passwd,int catalogid,int adminid){
        Connection conn = null;
        PreparedStatement ps = null;        
        boolean returnValue=true;
        String sql="update t_admin set admin=?,passwd=?,catalogid=? where id=?";
        try{
            MD5 md5=new MD5();
            String password=md5.getMD5of32(passwd);
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1, admin);
            ps.setString(2, password);
            ps.setInt(3, catalogid);    
            ps.setInt(4, adminid);
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){            
            e.printStackTrace();
            return false;
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean deleAdmin(int adminid){
        return exe("delete from t_admin where id="+adminid);
    }
    public boolean adminLogin(String admin,String passwd,int catalogid){
        Connection conn = null;
        PreparedStatement ps=null;
        ResultSet rs = null;
        boolean returnValue=false;
        try{
            MD5 md5=new MD5();
            String password=md5.getMD5of32(passwd);
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement("select id from t_admin where admin=? and passwd=? and catalogid=?");
            ps.setString(1,admin);
            ps.setString(2,password);
            ps.setInt(3,catalogid);
            rs=ps.executeQuery();
            if(rs.next()){
                returnValue=true;
            }
        } catch(SQLException e){            
            e.printStackTrace();
            return false;
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public Collection getAdminList(int pageSize,int currentPage){
        StringBuffer sql=new StringBuffer(512);
        String fieldArr="id,admin,catalogid";
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            sql.append("select top ");
            sql.append(pageSize);
            sql.append(fieldArr);
            sql.append(" from t_admin where id not in(select top ");
            sql.append((currentPage-1)*pageSize);
            sql.append(" id from t_catalog");
            sql.append(" order by id desc)");          
            sql.append(" order by id desc");
        }
        else if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            sql.append("select ");            
            sql.append(fieldArr);
            sql.append(" from t_admin");           
            sql.append(" order by id desc limit ");
            sql.append((currentPage-1)*pageSize);
            sql.append(",");
            sql.append(pageSize);
        }
        return this.getData(sql.toString(),fieldArr);
    }
    public DataField getAdmin(int id){
        String sql="select admin,catalogid from t_admin where id="+id;
        String fieldArr="admin,catalogid";
        return getFirstData(sql, fieldArr);
    }
    public int getAdminNum(){
        int returnValue=0;
        String sql="select count(*) from t_admin";
        returnValue=getDataCount(sql);
        return returnValue;
    }
}
