/*
 * CatalogDaoImplJDBC.java
 *
 * Created on 200681, 5:09
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package tot.dao.jdbc;
import tot.dao.AbstractDao;
import tot.db.DBUtils;
import tot.bean.*;
import tot.util.MD5;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author catalogistrator
 */
public class CatalogDaoImplJDBC extends AbstractDao{
    private static Log log = LogFactory.getLog(CatalogDaoImplJDBC.class);
    /** Creates a new instance of CatalogDaoImplJDBC */
    public CatalogDaoImplJDBC() {
    }
    public boolean catalogAdd(String catalogname,String catalogdes){
        Connection conn = null;
        PreparedStatement ps = null;        
        boolean returnValue=true;
        String sql="insert into t_catalog(catalogname,catalogdes) values(?,?)";
        try{           
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1, catalogname);
            ps.setString(2, catalogdes);                      
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){            
            e.printStackTrace();
            return false;
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public boolean catalogMod(String catalogname,String catalogdes,int catalogid){
        Connection conn = null;
        PreparedStatement ps = null;        
        boolean returnValue=true;
        String sql="update t_catalog set catalogname=?,catalogdes=? where id=?";
        try{            
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sql);
            ps.setString(1, catalogname);
            ps.setString(2, catalogdes);
            ps.setInt(3, catalogid);            
            if(ps.executeUpdate()!=1) returnValue=false;
        } catch(SQLException e){            
            e.printStackTrace();
            return false;
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    public Collection getCatalogList(int pageSize,int currentPage){
        StringBuffer sql=new StringBuffer(512);
        String fieldArr="id,catalogname,catalogdes";
        if (DBUtils.getDatabaseType() == DBUtils.DATABASE_SQLSERVER) {
            sql.append("select top ");
            sql.append(pageSize);
            sql.append(fieldArr);
            sql.append(" from t_catalog where id not in(select top ");
            sql.append((currentPage-1)*pageSize);
            sql.append(" id from t_catalog");
            sql.append(" order by id desc)");          
            sql.append(" order by id desc");
        }
        else if(DBUtils.getDatabaseType() == DBUtils.DATABASE_MYSQL){
            sql.append("select ");            
            sql.append(fieldArr);
            sql.append(" from t_catalog");           
            sql.append(" order by id desc limit ");
            sql.append((currentPage-1)*pageSize);
            sql.append(",");
            sql.append(pageSize);
        }
        return this.getData(sql.toString(),fieldArr);
    }
    public String getSelectCatalog(int catalogid){
        StringBuffer sb=new StringBuffer(512);
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs=null;
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement("select id,catalogname from t_catalog");
            rs=ps.executeQuery();
            while(rs.next()){
                int idt=rs.getInt(1);
                sb.append("<option value=\"");
                sb.append(idt);                
                sb.append("\"");
                if(idt==catalogid) sb.append(" selected=\"selected\"");
                sb.append(">");
                sb.append(rs.getString(2));
                sb.append("</option>");
            }
        }
        catch(SQLException e){
            log.info("catch exception when call getSelectCatalog method: \n");
            e.printStackTrace();            
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return sb.toString();
    }
    public DataField getCatalog(int id){
        String sql="select catalogname,catalogdes from t_catalog where id="+id;
        String fieldArr="catalogname,catalogdes";
        return getFirstData(sql, fieldArr);
    }
    public int getCatalogNum(){
        int returnValue=0;
        String sql="select count(*) from t_catalog";
        returnValue=getDataCount(sql);
        return returnValue;
    }
    public boolean delecatalog(int catalogid){
        return exe("delete from t_catalog where id="+catalogid);
    }
}
