/*
 * Sysconfig.java
 *
 * Created on 2006725, 11:25
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package tot.global;
import java.io.File;
import tot.xml.DOM4JConfiguration;
import tot.util.FileUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Sysconfig {

    private static Log log = LogFactory.getLog(Sysconfig.class);

    final static String OPTION_FILE_NAME = "totgb.xml";

    /* <Database Options> */
    private static boolean useDataSource = false;
    public static boolean isUseDataSource() {
        return useDataSource;
    }

    private static String dataSourceName = "";
    public static String getDataSourceName() {
        return dataSourceName;
    }

    // MUST NOT refer to DBUtils, or we will get an infinite recurse ???
    private static int databaseType = 0;//DATABASE_UNKNOWN
    public static int getDatabaseType() {
        return databaseType;
    }

    private static String driverClassName = "org.gjt.mm.mysql.Driver";
    public static String getDriverClassName() {
        return driverClassName;
    }

    private static String databaseURL = "jdbc:mysql://127.0.0.1/bbs?useUnicode=true&characterEncoding=utf-8";
    public static String getDatabaseURL() {
        return databaseURL;
    }

    private static String databaseUser = "root";
    public static String getDatabaseUser() {
        return databaseUser;
    }

    private static String databasePassword = "";
    public static String getDatabasePassword() {
        return databasePassword;
    }

    private static int maxConnection = 20;
    public static int getMaxConnection() {
        return maxConnection;
    }

    /* by default, the unit of time is milisecond */
    private static int maxTimeToWait = 2000;// 2 seconds
    public static int getMaxTimeToWait() {
        return maxTimeToWait;
    }

    private static int minutesBetweenRefresh = 30;// 30 minutes
    public static int getMinutesBetweenRefresh() {
        return minutesBetweenRefresh;
    }
    /* </Database Options> */

    /* <Mail Options> */
    private static String mailServer = "mail.yourdomain";
    public static String getMailServer() {
        return mailServer;
    }

    private static int mailServerPort = 25;
    public static int getMailServerPort() {
        return mailServerPort;
    }

    private static String defaultMailFrom = "youruser@yourdomain";
    public static String getDefaultMailFrom() {
        return defaultMailFrom;
    }

    private static String mailUserName = "";// allow empty username
    public static String getMailUserName() {
        return mailUserName;
    }

    private static String mailPassword = "";
    public static String getMailPassword() {
        return mailPassword;
    }
    /* </Mail Options> */

    /* <Param Options> */
    private static String contextPath = "";// allow ROOT context
    public static String getContextPath() {
        return contextPath;
    }

    private static String serverPath = "http://localhost:8080";
    public static String getServerPath() {
        return serverPath;
    }
    /* <Param Options> */

    /* <Date Options> */
    /* the unit of the server offset is hour*/
    private static int serverHourOffset = 0; /* GMT timezone */
    public static int getServerHourOffset() {
        return serverHourOffset;
    }
    /* </Date Options> */

    /* <User Agent Options>*/
    private static String blockedUserAgents = "";
    public static String getBlockedUserAgents() {
        return blockedUserAgents;
    }
    /* </User Agent Options>*/

    /* <IP Options>*/
    private static String blockedIPs = "";
    public static String getBlockedIPs() {
        return blockedIPs;
    }
    /* </IP Options>*/  

    static {
        load();
    }

    public static void load() {
        reload();
    }   
    public static void reload() {
        String classPath = FileUtil.getServletClassesPath();        
        String configFilename = classPath + OPTION_FILE_NAME;        
        try {
            DOM4JConfiguration conf = new DOM4JConfiguration(new File(configFilename));

            /* <Database Options> */
            useDataSource = conf.getBoolean("dboptions.use_datasource", false);
            databaseType = conf.getInt("dboptions.database_type", 0);           
            if (useDataSource) {
                dataSourceName = conf.getString("dboptions.datasource_name");
            } else {
                driverClassName = conf.getString("dboptions.driver_class_name", driverClassName);
                databaseURL = conf.getString("dboptions.database_url", databaseURL);
                databaseUser = conf.getString("dboptions.database_user", databaseUser);
                databasePassword = conf.getString("dboptions.database_password",databasePassword);

                maxConnection = conf.getInt("dboptions.max_connection", maxConnection);
                maxTimeToWait = conf.getInt("dboptions.max_time_to_wait", maxTimeToWait);

                minutesBetweenRefresh = conf.getInt("dboptions.minutes_between_refresh", minutesBetweenRefresh);
                if (minutesBetweenRefresh < 1) {
                    minutesBetweenRefresh = 1; //min is 1 minute
                }
            }
            /* <Database Options> */

            /* <Mail Options> */
            mailServer = conf.getString("mailoptions.mail_server", mailServer);
            defaultMailFrom = conf.getString("mailoptions.default_mail_from", defaultMailFrom);
            mailUserName = conf.getString("mailoptions.username", mailUserName);
            mailPassword = conf.getString("mailoptions.password", mailPassword);
            mailServerPort = conf.getInt("mailoptions.port", mailServerPort);
            /* </Mail Options> */

            /* <Parameter Options> */
            contextPath = conf.getString("paramoptions.context_path", contextPath);
            serverPath = conf.getString("paramoptions.server_path", serverPath);
            if (serverPath.endsWith("/")) {
                serverPath = serverPath.substring(0, serverPath.length() - 1);
            }
            /* </Parameter Options> */

            /* <Date Time Options> */
            serverHourOffset = conf.getInt("dateoptions.server_hour_offset", serverHourOffset);
            if ((serverHourOffset < -13) || (serverHourOffset > 13)) {
                serverHourOffset = 0;
            }
            /* </Date Time Options> */

            /* <User Agent Options>*/
            blockedUserAgents = conf.getString("useragentoptions.blocked_user_agent", blockedUserAgents);
            /* </User Agent Options>*/

            /* <IP Options>*/
            blockedIPs = conf.getString("ipoptions.blocked_ip", blockedIPs);
            /* </IP Options>*/
            
        } catch (Exception e) {
            String message = "global.Sysconfig: Can't read the configuration file: '" + configFilename + "'. Make sure the file is in your CLASSPATH";
            log.error(message, e);
        }
    }
}