// Decompiled by DJ v2.9.9.61 Copyright 2000 Atanas Neshkov  Date: 2004-12-9 9:53:05
// Home Page : http://members.fortunecity.com/neshkov/dj.html  - Check often for new version!
// Decompiler options: packimports(3) 
// Source File Name:   ChineseFilter.java

package org.apache.lucene.analysis.cn;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.lucene.analysis.*;

public final class ChineseFilter extends TokenFilter
{

    public ChineseFilter(TokenStream tokenstream)
    {
        super.input = tokenstream;
        stopTable = new Hashtable(STOP_WORDS.length);
        for(int i = 0; i < STOP_WORDS.length; i++)
            stopTable.put(STOP_WORDS[i], STOP_WORDS[i]);

    }

    public final Token next()
        throws IOException
    {
        for(Token token = super.input.next(); token != null; token = super.input.next())
        {
            String s = token.termText();
            if(stopTable.get(s) == null)
                switch(Character.getType(s.charAt(0)))
                {
                case 1: // '\001'
                case 2: // '\002'
                    if(s.length() > 1)
                        return token;
                    break;

                case 5: // '\005'
                    return token;
                }
        }

        return null;
    }

    public static final String STOP_WORDS[] = {
        "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", 
        "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", 
        "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", 
        "with"
    };
    private Hashtable stopTable;

}