// Decompiled by DJ v2.9.9.61 Copyright 2000 Atanas Neshkov  Date: 2004-12-9 9:53:41
// Home Page : http://members.fortunecity.com/neshkov/dj.html  - Check often for new version!
// Decompiler options: packimports(3) 
// Source File Name:   ChineseTokenizer.java

package org.apache.lucene.analysis.cn;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;

public final class ChineseTokenizer extends Tokenizer
{

    public ChineseTokenizer(Reader reader)
    {
        offset = 0;
        bufferIndex = 0;
        dataLen = 0;
        super.input = reader;
    }

    private final void push(char c)
    {
        if(length == 0)
            start = offset - 1;
        buffer[length++] = Character.toLowerCase(c);
    }

    private final Token flush()
    {
        if(length > 0)
            return new Token(new String(buffer, 0, length), start, start + length);
        else
            return null;
    }

    public final Token next()
        throws IOException
    {
        length = 0;
        start = offset;
label0:
        do
            do
            {
                offset++;
                if(bufferIndex >= dataLen)
                {
                    dataLen = super.input.read(ioBuffer);
                    bufferIndex = 0;
                }
                if(dataLen == -1)
                    return flush();
                char c = ioBuffer[bufferIndex++];
                switch(Character.getType(c))
                {
                case 3: // '\003'
                case 4: // '\004'
                case 6: // '\006'
                case 7: // '\007'
                case 8: // '\b'
                default:
                    continue label0;

                case 1: // '\001'
                case 2: // '\002'
                case 9: // '\t'
                    push(c);
                    if(length == 255)
                        return flush();
                    break;

                case 5: // '\005'
                    if(length > 0)
                    {
                        bufferIndex--;
                        return flush();
                    } else
                    {
                        push(c);
                        return flush();
                    }
                }
            } while(true);
        while(length <= 0);
        return flush();
    }

    private int offset;
    private int bufferIndex;
    private int dataLen;
    private static final int MAX_WORD_LEN = 255;
    private static final int IO_BUFFER_SIZE = 1024;
    private final char buffer[] = new char[255];
    private final char ioBuffer[] = new char[1024];
    private int length;
    private int start;
}