function DateSelector(selYear, selMonth, selDay)
{
    this.selYear = selYear;
    this.selMonth = selMonth;
    this.selDay = selDay;
    this.selYear.Group = this;
    this.selMonth.Group = this;
    // ݡ·˵Ӵonchange¼ĺ
    if(window.document.all != null) // IE
    {
        this.selYear.attachEvent("onchange", DateSelector.Onchange);
        this.selMonth.attachEvent("onchange", DateSelector.Onchange);
    }
    else // Firefox
    {
        this.selYear.addEventListener("change", DateSelector.Onchange, false);
        this.selMonth.addEventListener("change", DateSelector.Onchange, false);
    }

    if(arguments.length == 4) // Ϊ4һΪDate
        this.InitSelector(arguments[3].getFullYear(), arguments[3].getMonth() + 1, arguments[3].getDate());
    else if(arguments.length == 6) // Ϊ6Ϊʼֵ
        this.InitSelector(arguments[3], arguments[4], arguments[5]);
    else // Ĭʹõǰ
    {
        var dt = new Date();
        this.InitSelector(dt.getFullYear(), dt.getMonth() + 1, dt.getDate());
    }
}

// һݵ
DateSelector.prototype.MinYear = 1900;

// һݵ
DateSelector.prototype.MaxYear = (new Date()).getFullYear();

// ʼ
DateSelector.prototype.InitYearSelect = function()
{
    // ѭOPIONԪصselect
    for(var i = this.MaxYear; i >= this.MinYear; i--)
    {
        // ½һOPTION
        var op = window.document.createElement("OPTION");
        
        // OPTIONֵ
        op.value = i;
        
        // OPTION
        op.innerHTML = i;
        
        // ӵselect
        this.selYear.appendChild(op);
    }
}

// ʼ·
DateSelector.prototype.InitMonthSelect = function()
{
    // ѭOPIONԪص·select
    for(var i = 1; i < 13; i++)
    {
        // ½һOPTION
        var op = window.document.createElement("OPTION");
        
        // OPTIONֵ
        op.value = i;
        
        // OPTION
        op.innerHTML = i;
        
        // ӵ·select
        this.selMonth.appendChild(op);
    }
}

// ·ݻȡµ
DateSelector.DaysInMonth = function(year, month)
{
    var date = new Date(year, month, 0);
    return date.getDate();
}

// ʼ
DateSelector.prototype.InitDaySelect = function()
{
    // ʹparseIntȡǰݺ·
    var year = parseInt(this.selYear.value);
    var month = parseInt(this.selMonth.value);
    
    // ȡµ
    var daysInMonth = DateSelector.DaysInMonth(year, month);
    
    // ԭеѡ
    this.selDay.options.length = 0;
    // ѭOPIONԪصselect
    for(var i = 1; i <= daysInMonth ; i++)
    {
        // ½һOPTION
        var op = window.document.createElement("OPTION");
        
        // OPTIONֵ
        op.value = i;
        
        // OPTION
        op.innerHTML = i;
        
        // ӵselect
        this.selDay.appendChild(op);
    }
}

// ݺ·onchange¼ķȡ¼Դ󣨼selYearselMonth
// Group󣨼DateSelectorʵ캯ṩInitDaySelect³ʼ
// eΪevent
DateSelector.Onchange = function(e)
{
    var selector = window.document.all != null ? e.srcElement : e.target;
    selector.Group.InitDaySelect();
}

// ݲʼ˵ѡ
DateSelector.prototype.InitSelector = function(year, month, day)
{
    // ⲿǿԵҲҪselYearselMonthѡյ
    // ΪInitDaySelectѾ˵Ͳظ
    this.selYear.options.length = 0;
    this.selMonth.options.length = 0;
    
    // ʼꡢ
    this.InitYearSelect();
    this.InitMonthSelect();
    
    // ꡢ³ʼֵ
    this.selYear.selectedIndex = this.MaxYear - year;
    this.selMonth.selectedIndex = month - 1;
    
    // ʼ
    this.InitDaySelect();
    
    // ʼֵ
    this.selDay.selectedIndex = day - 1;
}