<?php
class GroupModel extends DBModel {
	public function Init(){
	}
	public function add($POST){
		if ($this->validate($POST)){
			$row = $this->_DB->Insert(VODCMS_USERGROUP, $POST);
			systemlog::set('ûΪ'.$row['title'].'ûϢ!');
			$this->Cache();
			return $row;
		}else{
			return false;
		}
	}
	public function modify($POST){
		if ($this->validate($POST)){
			$row = $this->_DB->update(VODCMS_USERGROUP, $POST, array('id'=>$POST['id']));
			$this->Cache();
			return $row;
		}else{
			return false;
		}
	}
	public function validate($data, $rule=null){
		if (is_null($rule)){
			$rule['title'] = array('/(.+?)/is', 'д320ַ!', true, 3 , 20);
			$rule['description'] = array('/(.+?)/is', 'д3100ַ!', true, 3 , 100);
			$rule['flag'] = array('/(\d+)/is', 'дֵȨֵ!ֵԽ߱ʾȨԽ', true);
			$rule['maxlook'] = array('/(\d+)/is', 'д㲥!Ϊ', true);
			$rule['maxdown'] = array('/(\d+)/is', 'д!Ϊ', true);
			$rule['repeat'] = array('/(\d+)/is', 'дظ۵!Ϊ', true);
		}
		if (Easy_Validate_Default::validate($data, $rule)==true){
			return true;
		}else{
			$this->error = Easy_Validate_Default::$error;
			return false;
		}
	}
	/*
	ݴضά¼
	*/
	public function getAll($where=null){
		$select = $this->_DB->select();
		$sql = $select->from(VODCMS_USERGROUP)->where($where)->order('id DESC')->toString();
		return $this->_DB->fetAll($sql);
	}
	/*
	ȡһм¼
	*/
	public function getRow($id=0){
		if ($id){
			$select = $this->_DB->select();
			$sql = $select->from(VODCMS_USERGROUP)->where('id='.$id)->order('id DESC')->toString();
			return $this->_DB->fetRow($sql);
		}
	}
	/*
	IDɾ¼
	*/
	public function Delete($id=0){
		$select = $this->_DB->select();
		$sql = $select->from(VODCMS_USERGROUP)->where('id='.$id)->order('id DESC')->toString();
		$row = $this->_DB->fetRow($sql);
		systemlog::set('ɾΪ'.$row['title'].'ûϢ!');
		unset($row);
		return $this->_DB->delete(VODCMS_USERGROUP, 'id='.$id);
	}
	public function CreateOption($id, $prefix=''){
		$array = $this->getAll();
		$body = '';
		foreach ($array as $row){
			if ($id == $row['id']){
				$body.= '<option value="'.$row['id'].'" selected="selected">'.$row['title'].'</option>';
			}else{
				$body.= '<option value="'.$row['id'].'">'.$row['title'].'</option>';
			}
		}
		return $body;
	}
	/*
	ûбд뻺
	*/
	public function cache(){
		$cache = new Easy_Cache();
		$select = $this->_DB->select();
		$sql = $select->from(VODCMS_USERGROUP)->where($where)->order('id DESC')->toString();
		foreach($this->_DB->fetAll($sql) as $row){
			$data[$row['id']] = $row;
		}
		$data = serialize($data);
		$cache->set('usergroup', $data);
		unset($data);
	}
	public function getGroupName($groupid){
		if (!$this->usergroup){
			if (Easy_Cache::isCache('usergroup')===false){
				$this->cache();
			}
			$this->usergroup = unserialize(Easy_Cache::get('usergroup'));
		}
		$flag = $this->usergroup[$groupid]['flag'];
		$str = null;
		if ($groupid){
			foreach($this->usergroup as $row){
				if ($row['flag'] >= $flag){
					$str.= $str ?  '&nbsp;' .$row['title'] : $row['title'];
				}
			}
		}else{
			$str = _('');
		}
		unset($usergroup);
		return $str;
	}
	public function groupName($id){
		if (!$this->usergroup){
			if (Easy_Cache::isCache('usergroup')===false){
				$this->cache();
			}
			$this->usergroup = unserialize(Easy_Cache::get('usergroup'));
		}
		if ($this->usergroup){
			return $this->usergroup[$id]['title'];
		}else{
			return 'ȡʧ!';
		}
	}
 }