<?php
/*
ûģ
*/
class UsersModel extends DBModel {
	public function Init(){
		$this->config = $GLOBALS['config'];
	}
	/*
	@param $POST array
	return int;
	*/
	public function Add($POST){
		if ($this->valiUser($POST)){
			$POST['username'] = strtolower($POST['username']);
			$POST['lifetime'] = strtotime($POST['lifetime']);
			$POST['regdate'] = time();
			unset($POST['passwd']);
			$row = $this->getRow($POST['username']);
			if ($row['uid']){
				$this->error = _('ûѾռ!');
				return false;
			}
			$row = $this->getRow(array('username' => $POST['username']));
			if ($row['uid']){
				$this->error = _('ûѾ!');
				return false;
			}
			if ($this->config['ucenter'] == 1){	//ucenterϲ
				$ucenter = new ucenter();
				if ($ucenter->add($POST['username'], $POST['password'], $POST['email'])===false){
					$this->error = $ucenter->ErrorInfo;
					return false;
				}
			}
			$POST['password'] = md5(strtolower($POST['password']));
			systemlog::set(_('˵¼Ϊ'.$POST['username'].'û'));
			$this->_DB->insert(VODCMS_MEMBERS, $POST);			
			return $this->_DB->lastInsertId();
		}else{
			return false;
		}
	}
	public function valiUser($data, $rule=null){
		if (is_null($rule)) {
			$rule['username'] = array('/(.+?)/is', _('5-30ַϵû!'), true, 5, 30);
			$rule['password'] = array('/(.+?)/is', _('5-30ַϵ!'), true, 5, 30);
			if ($data['password'] != $data['passwd']){
				$this->error = _('ȷ¼벻һ!');
				return false;
			}
			$rule['email'] = array('email', _('ʼַʽȷ!'), true);
			$rule['point'] = array('int', _('ʻΪ!'), true,1, 9);
		}
		if (Easy_Validate_Default::validate($data, $rule)===false){
			$this->error = Easy_Validate_Default::$error;
			return false;
		}else{
			return true;
		}
	}
	public function getAll($where=null){
		$select = $this->_DB->select();
		$sql = $select->from(VODCMS_MEMBERS.' AS a', 'a.*')->join(VODCMS_USERGROUP.' AS b' , 'a.usergroup=b.id', 'b.title as usergroup')->where($where)->order('a.uid DESC')->toString();
		$total = $this->_DB->getCount($sql);
		$this->_Page->set($total,50);
		$this->printpage = $this->_Page->PrintPage();
		$sql = $sql.$this->_Page->limit();
		//cho $sql;
		return $this->_DB->FetAll($sql);
	}
	/*
	ȡһû¼
	*/
	public function getRow($where){
		if (is_numeric($where)){
			$where = 'uid='.(int)$where;
		}elseif(is_array($where)===false){
			$where = array('username' => $where);
		}
		$select = $this->_DB->select();
		$sql = $select->from(VODCMS_MEMBERS)->where($where)->limit(1)->toString();
		//echo $sql;
		return $this->_DB->fetRow($sql);
	}
	/*
	*/
	public function groupOption($usergroup=0){
		$select = $this->_DB->select();
		$sql = $select->from(VODCMS_USERGROUP)->order('flag asc')->toString();
		foreach ($this->_DB->fetAll($sql) as $row){
			if (intval($row['id']) == intval($usergroup)){
				$data.= '<option value="'.$row['id'].'" selected="selected" >'.$row['title'].'</option>';
			}else{
				$data.= '<option value="'.$row['id'].'"  >'.$row['title'].'</option>';
			}
		}
		return $data;
	}
	/*
	@param array $POST ûϵ
	return int
	*/
	public function modify($POST){
		$POST['lifetime'] = strtotime($POST['lifetime']);
		if ($POST['password']){
			if (strlen($POST['password'])<6){
				$this->error = _('д5λС30λ!');
				return false;
			}
			$POST['password'] = md5($POST['password']);
		}else{
			unset($POST['password']);
		}
		if ($this->config['ucenter'] == 1){	//ucenterʱ
			$ucenter = new Ucenter();
			if ($ucenter->modify($POST['username'], $POST['oldpass'], $POST['password'], $POST['email'])===false){
				$this->error = $ucenter->ErrorInfo;
				return false;
			}
		}//ucenterû
		if ($POST['lockip']){
			if (!ip2long($POST['lockip']) ||ip2long($POST['lockip']) == -1 ){
				$this->error = _('IPַȷ!');
				return false;
			}
		}
		return $this->_DB->update(VODCMS_MEMBERS, $POST, array('uid'=>$POST['uid']));
	}
	/*
	ıû״̬
	*/
	public function locked($uid){
		$sql = 'UPDATE '.VODCMS_MEMBERS.' SET locked = NOT(locked) WHERE uid='. (INT)$uid;
		return $this->_DB->Exec($sql);
	}
	/*
	û
	*/
	public function search($POST){
		$where = ' 1=1';
		if ($POST['usergroup'] != 'all'){
			 $where .= ' AND a.usergroup = '. intval($POST['usergroup']);
		}
		if ($POST['usertype'] != 'all') {
			$where .= ' AND a.usertype = '. intval($POST['usertype']);
		}
		if ($POST['point'] != 'all'){
			if ($POST['point'] == 0){
				$where .= ' AND a.point = 0';
			}else{
				$where .= ' AND a.point >'.(int)$POST['point'];
			}
		}
		if ($POST['lifetime'] != 'all' && $POST['lifetime']){
			$where .= ' AND TO_DAYS(FROM_UNINXTIME(a.lifetime)) - TO_DATS(NOW()) <='.(int)$POST['lifetime'];	
		}
		if ($POST['locked'] != 'all'){
			$where .= ' AND a.locked='.intval($POST['locked']);
		}
		if ($POST['startime'] && $POST['endtime']){
			$where .= ' AND Ta.regdate<'.strtotime($POST['startime']).' AND a.regdate<='.strtotime($POST['endtime']);	
		}
		if ($POST['keyword']){
			if (!$POST['checkbox']){
				$where .= ' AND a.'.$POST['type'].' LIKE \'%'.$POST['keyword'].'%\'';
			}else{
				$where .= ' AND a.'.$POST['type'].' = \''.$POST['keyword'].'\'';
			}
		}
		//echo $where;
		return $this->getAll($where);
	}
	public function delete($uid){
		if ($this->config['ucenter'] == 1){
			$user = $this->getRow(array('uid'=>$uid));	//ȡûϢ
			$ucenter = new Ucenter();
			$ucenter->delete($user['username']);
		}
		systemlog::set('ɾ˱Ϊ'.$user['username'].'û');
		return $this->_DB->delete(VODCMS_MEMBERS, array('uid'=> $uid));
	}
	/*
	@param $POST array
	void
	*/
	public function Post($POST){
		switch ($POST['post']){
			case 'locked':
				$this->_DB->update(VODCMS_MEMBERS, array('locked'=> $POST['locked']), 
				"username in ('".implode("','", $POST['username'])."')");
			break;
			case 'delete':
				$this->_DB->delete(VODCMS_MEMBERS, "username in ('".implode("','", $POST['username'])."')");
			break;
			case  'usergroup':
				if ($POST['usergroup'] == 'all'){
					$this->error = _('ѡû');
					return false;
				}
				$this->_DB->update(VODCMS_MEMBERS, array('usergroup'=> (int)$POST['usergroup']), 
				"username in ('".implode("','", $POST['username'])."')");
			break;
			case 'point':
				
				$this->_DB->update(VODCMS_MEMBERS, "point=point+".(int)$POST['point'], 
				"username in ('".implode("','", $POST['username'])."')");
			break;
			case 'lifetime':
				$this->_DB->update(VODCMS_MEMBERS, "lifetime=lifetime+".((int)$POST['lifetime']*86400), 
				"username in ('".implode("','", $POST['username'])."')");
			break;
		}
		return $this->_DB->affected_rows();
	}
	public function userOnline(){
		$select = $this->_DB->select();
		$sql = $select->from(VODCMS_SESSION)->order('lastime DESC')->toString();
		$total = $this->_DB->getcount($sql);
		$this->_Page->set($total);
		$this->printpage = $this->_Page->PrintPage();
		$sql = $sql.$this->_Page->limit();
		//cho $sql;
		return $this->_DB->FetAll($sql);
	}
	public function getActive($where=null){
		$select = $this->_DB->select();
		$select->from(VODCMS_ACTIVES.' AS a','a.*');
		$select->join(VODCMS_URL.' as b', 'a.urlid=b.urlid', 'b.movid');
		$select->join(VODCMS_MOVIE.' as c', 'b.movid=c.movid', 'concat(c.title,b.title) as movie');
		$sql = $select->order('a.id DESC')->toString();
		$total = $this->_DB->getcount($sql);
		$this->_Page->set($total);
		$this->printpage = $this->_Page->PrintPage();
		$sql = $sql.$this->_Page->limit();
		return $this->_DB->FetAll($sql);
	}
	public function delActive($id){
		return $this->_DB->delete(VODCMS_ACTIVES, array('id'=>(int)$id));
	}
	public function getPlaylog($POST=null){
		$where = '1';
		if ($POST['username']){
			$where .= ' AND a.username like \''.$POST['username'].'\'';
		}
		if (strtotime($POST['stime'])){
			$where .= ' AND a.addtime < \''.strtotime($POST['stime']).'\'';
		}
		if (strtotime($POST['etime'])){
			$where .= ' AND a.addtime > \''.strtotime($POST['etime']).'\'';
		}
		$select = $this->_DB->select();
		$select->from(VODCMS_PLAYLOG.' AS a','a.*');
		$select->join(VODCMS_URL.' as b', 'a.urlid=b.urlid', 'b.movid');
		$select->join(VODCMS_MOVIE.' as c', 'b.movid=c.movid', 'concat(c.title,b.title) as movie');
		$select->where($where);
		$sql = $select->order('a.id DESC')->toString();
		$total = $this->_DB->getcount($sql);
		$this->_Page->set($total);
		$this->printpage = $this->_Page->PrintPage();
		$sql = $sql.$this->_Page->limit();
		//echo $sql;
		return $this->_DB->FetAll($sql);
	}
	/*
	ɾ㲥־
	*/
	public function delPlaylog($id){
		if (is_array($id)){
			$id = implode(',', array_map('intval',$id) );
		}
		return $this->_DB->delete(VODCMS_PLAYLOG, 'id in ('.$id.')');
	}
	/*ɾû*/
	public function delOnline($id){
		if (is_array($id)){
			$where = implode('\',\'', $id );
		}else{
			$where = $id;
		}
		return $this->_DB->delete(VODCMS_SESSION, 'username in (\''.$where.'\')');
	}
	/*
	֤ûǷѾռ
	*/
	public function exists($where){
		$select = $this->_DB->select();
		$sql = $select->from(VODCMS_MEMBERS)->where($where)->limit(1)->toString();
		$row = $this->_DB->fetRow($sql);
		if ($row['uid']){
			return false;
		}else{
			return true;
		}
	}
	/*
	ûǷ½ɹ!
	ûʱǸ
	*/
	function login($where, $uc=1){
		if ($this->config['ucenter'] == 1 && $uc==1){
			$ucenter = new Ucenter();			
			list($uid, $username, $password, $email) = $ucenter->login($where['username'], $where['password']);
			if ($uid > 0){
				echo $ucenter->synclogin($uid);
			}
			$row = $this->getRow($where['username']);
			if ($row['uid'] <1 && $uid>0){
				$this->_DB->insert(VODCMS_MEMBERS, array('uid'=> $uid, 'username'=> $username, 
					'password'=>$password, 'email'=>$email, 'regdate' => time(), 'usergroup'=> 1));
			}
		}
		$select = $this->_DB->select();
		$select->from(VODCMS_MEMBERS.' as a', 'a.*');
		$select->join(VODCMS_USERGROUP.' as b' , 'a.usergroup=b.id', 'b.title as groupname');
		$select->where($where);
		$sql = $select->limit(1)->toString();
		$user = $this->_DB->fetRow($sql);
		return $user;
	}
	/*
	û¼ʱԼһε¼ʱ
	@param $uid int ûı
	return int
	*/
	public function setLoginTime($uid){
		return $this->_DB->update(VODCMS_MEMBERS, '`lastime` = `logintime`, `logintime` = '.time(), array('uid'=>intval($uid)));
	}
}?>