<?php
class VodcmsModel extends DBModel {
	public $database = 'Config/database';
	public $filename = null;
	public $letter;
	public $path;
	public $dir;
	public $pagesize = 2;
	public $ext = '.sql';
	public $charset = 'GBK';
	public $_name;
	public function Init(){
		$this->_IO = new Easy_Filesystem();
		$this->ext = '.sql';
		$this->dir = ROOT.$this->database;
		$this->_name = VODCMS_FILE;
		if (!defined('SUCCEED_VODCMS')){
			exit();
		}
	}
	/*
	ݿ⵼
	*/
	public function view($dir=null){
		if (is_null($dir)){
			$dir = ROOT.$this->database;
			$this->path = '';
		}elseif (basename(base64_decode($dir)) == 'Config'){
			$dir = ROOT.$this->database;
			$this->path = '';
		}else {
			$dir = base64_decode($dir);
			$this->path = $dir;
		}
		$data = $this->_IO->scandir($dir);
		$this->_Page->set(count($data), 10);
		$this->printpage = $this->_Page->printpage();
		$this->_Page->limit();
		//print_r($array);
		return @array_slice($data, $this->_Page->pagesize, $this->_Page->maxpage, true);
	}
	public function export(){
		@$this->dir = ROOT.$this->database;
		ini_set('memory_limit', '128M');
		$this->letter = 65;
		$this->ext = $this->_Response->getPost('ext');
		if ($this->_Response->getPost('charset')){
			$this->charset = strtoupper($this->_Response->getPost('charset'));
		}
		$uniqid = date("Ymdhis");
		mkdir($this->dir.'/'.$uniqid, 0755);
		$this->filename = $this->dir.'/'.$uniqid.'/'.chr($this->letter).$this->ext;
		$this->pagesize = $this->_Response->getPost('pagesize');	//ҳС
		foreach($this->_DB->showTable() as $table){
			@set_time_limit(0);
			$this->exportData($table);
		}
	}
	/*
	SQLԼṹ
	*/
	public function exportData($table){
		if (is_null($this->filename)){
			$uniqid = date("Ymdhis");
			@mkdir($this->dir.'/'.$uniqid, 0755);
			$this->filename = $this->dir.'/'.$uniqid.'/'.$table.$this->ext;
		}
		$data = $this->_DB->fetRow('SHOW CREATE TABLE '.$table);
		$maxsize = $this->pagesize *1024*1000;
		$sqlData = "\nDROP TABLE IF EXISTS `{$table}`;\n".preg_replace('/CHARSET\=(\w+)/is', 'CHARSET='.$this->charset, end($data)).";";
		$this->_IO->wfile($this->filename, $sqlData, 'a');
		unset($sqlData);
		$i=0;
		$total = $this->_DB->getCount('select * from '.$table);
		$maxpage = 300;
		$pagesize = ceil($total / $maxpage);
		$page = 1;
		
		while($page <= $pagesize){
			$offset = ($page-1) * $maxpage;
			$sql = 'select * from '.$table.' LIMIT '.$offset.','.$maxpage;
			foreach ($this->_DB->fetAll($sql) as $row){
				@set_time_limit(999);
				clearstatcache();
				$i++;
				if ($i % 20 == 0){
					$sqlData.= "('".implode("','", array_map('addslashes', array_values($row)))."');";
					if ((int)filesize($this->filename) > $maxsize){
						$this->letter = $this->letter+1;
						$this->filename = preg_replace('/\/([A-Z])\./is', '/'.chr($this->letter).'.', $this->filename);
						//echo $this->filename;
					}
					$this->_IO->wfile($this->filename, $insert.$sqlData, 'a');
					unset($sqlData, $insert);
				}else{
					$insert = "\nINSERT INTO ".$table."(`".implode("`,`", array_keys($row))."`) VALUES";
					$sqlData.= "\n('".implode("','", array_map('addslashes', array_values($row)))."'),";
				}
			}
			$page ++;
		}
		$sqlData = preg_replace('/,$/is', ';', $sqlData);
		
		$this->_IO->wfile($this->filename, $insert.$sqlData, 'a');
		unset($sqlData, $insert);
	}
	/*
	ɾļ
	*/
	public function delete($filename){
		if (is_dir($filename)){
			$this->_IO->delete($filename);
		}else{
			$this->_IO->delete($filename, array('sql','gz','gzip'));
		}
		return $this->_IO->delrow;
		//chdir($root);
		//$this->_IO->delete($fllename)
	}
	/*
	ݿļ
	*/
	public function import($filename){
		if (is_dir($filename)){
			$files = array_values($this->_IO->scandir($filename));
		}else{
			$files = array($filename);
		}
		$num = (int)$_GET['num'];
		$row = $files[$num];
		if (in_array(substr(strrchr($row, '.'), 1), array('gzip','gz'))){
			$zd = gzopen($row, "r");
			$contents = gzread($zd, 10000);
			gzclose($zd);
		}else {
			$contents = @file_get_contents($row);
		}
		$data = explode(";\n", $contents);
		foreach ($data as $sql){
			//echo $sql.'<br>';
			$this->_DB->exec($sql);
		}
		$num = $num+1;
		if (count($files)>$num){
			$this->sqlfile = $row;
			return $num;
		}else{
			return false;	//
		}
	}
	/*
	ȡ״̬Ϣ
	*/
	public function getStat(){
		return $this->_DB->fetAll('SHOW TABLE STATUS');
	}
	/*
	Ż
	*/
	public function optimize($tablename){
		foreach ($tablename as $table){
			$this->_DB->exec('OPTIMIZE TABLE '. $table);
		}
	}
	public function repair($tablename){
		foreach ($tablename as $table){
			$this->_DB->exec('REPAIR TABLE '. $table);
		}
	}
	/*
	ȡϢ
	*/
	public function getPic(){
		$select = $this->_DB->select();
		$sql = $select->from($this->_name)->order('id DESC')->toString();
		$total = $this->_DB->getCount($sql);
		$this->_Page->set($total);
		return $this->_DB->fetAll($sql.$this->_Page->limit());
	}
	/**/
	public function exec($sql){
		if ($sql){
			return $this->_DB->exec($sql);
		}
	}
	/*
	SQL
	*/
	public function clean(){
		$IO = new Easy_Filesystem();
		$action = $this->_Response->getPost('checkbox');
		if (is_array($action) == false){
			$action = array(1,2,3);
		}
		if (in_array(1, $action)){
			$IO->delete(ROOT.'Cache', array('php'), false);
		}
		if (in_array(2, $action)){
			$IO->delete(ROOT.'Cache/tmp', array('html'), false);
		}
		if (in_array(3, $action)){
			$files = scandir(ROOT.'Cache/session');
			foreach($files as $file){
				if ($file != '.' && $file !='..' && $file!='.svn'){
					if (time()-@filemtime(ROOT.'Cache/session/'.$file)>3600 || @filesize(ROOT.'Cache/session/'.$file)==0){
						@unlink(ROOT.'Cache/session/'.$file);
					}
				}
			}
		}
		if (in_array(4, $action)){
			$movie = new MovieModel();
			$movie->setMidTable();
			$movie->initmovie();
			$movie->initCategory();
			$category = new CategoryModel();
			$category->initLable();
		}
		if (in_array(5, $action)){
			$category = new CategoryModel();
			$category->initLable();
			$movie = new MovieModel();
			$movie->initsCategory();
		}
	}
}?>