<?php
interface Easy_Db_Interface
{
	public function __construct();
	public function insert($table, $data);		//数据插入
	public function delete($table, $where=null);		//删除数据
	public function update($table, $data, $where=null);		//更新数据
	public function fetAll($sql, $type=null);				//取得数据作为数据
	public function fetRow($sql, $type=null);			//取得一行数据作为数组
	public function fetOne($sql);		//取得第一个字段信息
	public function query($sql, $type=null);		//执行一个SQL语句
	public function beginTransaction();	//开始事务处理
	public function commit();				//提交事务
	public function rollBack();			//事务失败回滚事务
	public function quote($string);		//转移字符
	public function error($error);		//抛出字符信息
	public function debug($bool=false);				//开启调试
	public function select();
	public function __call($method, $args);
	public function Exec($sql, $type=null);
	public function showtable($dbname=null);
}