<?php

/*
	[UCenter] (C)2001-2008 Comsenz Inc.
	This is NOT a freeware, use is subject to license terms

	$Id: friend.php 616 2008-09-21 13:05:10Z zhaoxiongfei $
*/

!defined('IN_UC') && exit('Access Denied');

class friendcontrol extends base {

	function __construct() {
		$this->friendcontrol();
	}

	function friendcontrol() {
		parent::__construct();
		$this->init_input();
		$this->load('friend');
	}

	function ondelete() {
		$uid = intval($this->input('uid'));
		$friendids = $this->input('friendids');
		$id = $_ENV['friend']->delete($uid, $friendids);
		return $id;
	}

	function onadd() {
		$uid = intval($this->input('uid'));
		$friendid = $this->input('friendid');
		$comment = $this->input('comment');
		$this->load('pm');
		$blackls = $_ENV['pm']->get_blackls($friendid);
		$blackls = explode(',', $blackls);
		if(!empty($blackls)) {
			if(in_array('{ALL}', $blackls)) {
				return 0;
			}
			$this->load('user');
			$user = $_ENV['user']->get_user_by_uid($uid);
			$username = $user['username'];
			if(in_array($username, $blackls)) {
				return 0;
			} 	
		}
		$id = $_ENV['friend']->add($uid, $friendid, $comment);
		return $id;
	}

	function ontotalnum() {
		$uid = intval($this->input('uid'));
		$direction = intval($this->input('direction'));
		$totalnum = $_ENV['friend']->get_totalnum_by_uid($uid, $direction);
		return $totalnum;
	}

	function onls() {
		$uid = intval($this->input('uid'));
		$page = intval($this->input('page'));
		$pagesize = intval($this->input('pagesize'));
		$totalnum = intval($this->input('totalnum'));
		$direction = intval($this->input('direction'));
		$pagesize = $pagesize ? $pagesize : UC_PPP;
		$totalnum = $totalnum ? $totalnum : $_ENV['friend']->get_totalnum_by_uid($uid);
		$data = $_ENV['friend']->get_list($uid, $page, $pagesize, $totalnum, $direction);
		return $data;
	}
}

?>