<?php

/**
 *--------------------------------------
 * upgrade function
 *--------------------------------------
 * @project		: upgrade
 * @author		: cblee
 * @created		: 2017-06-07
 * @copyright	: (c)2017 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

function check_lock() {
	if(file_exists(LOCK_FILE)) {
		header('Content-type: text/html; charset=utf-8');
		echo L('LOCKED_TIP');
		exit();
	}
}
function check_version() {
	$define = file_get_contents(DEFINE_FILE);
	preg_match_all('/define\(\'SOFT_VERSION\', \'(.*)\'\);/i', $define, $version);
	if($version[1][0] != SOFT_VERSION_FROM) {
		header('Content-type: text/html; charset=utf-8');
		echo L('VERSION_NOT_MATCHED_TIP', null, array(
			'version_now' => $version[1][0],
			'version_from' => SOFT_VERSION_FROM,
			'version_to' => SOFT_VERSION_TO)
		);
		exit();
	}
}

function check_system(&$systemItems, &$checkNextStep) {
	if(isset($systemItems['OS'])) {
		$systemItems['OS']['c'] = PHP_OS;
	}
	if(isset($systemItems['PHP_VERSION'])) {
		$systemItems['PHP_VERSION']['c'] = PHP_VERSION;
	}
	if(isset($systemItems['MYSQL_VERSION'])) {
		$temp = M()->query('select VERSION()');
		$temp = explode('-', $temp[0]['VERSION()']);
		$systemItems['MYSQL_VERSION']['c'] = $temp[0];
		unset($temp);
	}
	if(isset($systemItems['MYSQL_CONNECTION'])) {
		if(M()->db->connected) {
			$systemItems['MYSQL_CONNECTION']['c'] = 'CONNECTED';
		}
		else {
			$systemItems['MYSQL_CONNECTION']['c'] = 'UNCONNECTED';
		}
	}
	if(isset($systemItems['UPLOAD_MAX_FILESIZE'])) {
		$systemItems['UPLOAD_MAX_FILESIZE']['c'] = @ini_get('file_uploads') ? ini_get('upload_max_filesize') : 'UNKNOWN';
	}
	if(isset($systemItems['GD_VERSION'])) {
		$temp = function_exists('gd_info') ? gd_info() : array('GD Version' => 'NONSUPPORT');
		$systemItems['GD_VERSION']['c'] = empty($temp['GD Version']) ? 'INEXISTENCE' : rtrim(ltrim($temp['GD Version'], 'bundled ('),'compatible)');
		unset($temp);
	}
	if(isset($systemItems['DISK_SPACE'])) {
		if(function_exists('diskFreeSpace')) {
			$systemItems['DISK_SPACE']['c'] = floor(diskFreeSpace(SOFT_PATH) / (1024*1024)).'M';
		}
		else {
			$systemItems['DISK_SPACE']['c'] = 'UNKNOWN';
		}
	}

	foreach($systemItems as $k => $v) {
		if(0 == (int)$systemItems[$k]['c']) {
			if('NOT_LIMIT' == $v['r'] || $systemItems[$k]['c'] == $v['r']) {
				$systemItems[$k]['s'] = 1;
			}
			else {
				$systemItems[$k]['s'] = 0;
				if('UNKNOWN' != $systemItems[$k]['c']) {
					$checkNextStep = 0;
				}
			}
		}
		else {
			if('NOT_LIMIT' == $v['r'] || ($systemItems[$k]['c'] - $v['r']) >= 0) {
				$systemItems[$k]['s'] = 1;
			}
			else {
				$systemItems[$k]['s'] = 0;
				if('UNKNOWN' != $systemItems[$k]['c']) {
					$checkNextStep = 0;
				}
			}
		}
	}

}

function check_dirfile(&$dirfileItems, &$checkNextStep) {
	foreach($dirfileItems as $k => $v) {
		$path = SOFT_PATH.D_S.$v['path'];
		if('dir' == $v['type']) {
			if(!dir_writable($path)) {
				$dirfileItems[$k]['c'] = 'ERAD_ONLY';
				$dirfileItems[$k]['s'] = 0;
				$checkNextStep = 0;
			}
			else {
				$dirfileItems[$k]['c'] = 'WRITABLE';
				$dirfileItems[$k]['s'] = 1;
			}
		}
		else {
			if(file_exists($path)) {
				if(is_writable($path)) {
					$dirfileItems[$k]['c'] = 'WRITABLE';
					$dirfileItems[$k]['s'] = 1;
				}
				else {
					$dirfileItems[$k]['c'] = 'ERAD_ONLY';
					$dirfileItems[$k]['s'] = 0;
					$checkNextStep = 0;
				}
			}
			else {
				if(dir_writable(dirname($path))) {
					$dirfileItems[$k]['s'] = 1;
					$dirfileItems[$k]['c'] = 'WRITABLE';
				}
				else {
					$dirfileItems[$k]['s'] = 0;
					$checkNextStep = 0;
					$dirfileItems[$k]['c'] = 'INEXISTENCE';
				}
			}
		}
	}
}

function check_phpConfig(&$phpConfigItems, &$checkNextStep) {
	foreach($phpConfigItems as $k => $v) {
		$phpConfigItems[$k]['c'] = '1' === get_cfg_var($k) ? 'on' :
			('' === get_cfg_var($k) ? 'off' : get_cfg_var($k));
		if(strtolower($phpConfigItems[$k]['c']) == strtolower($v['r']) or ('safe_mode' == $k and PHP_VERSION >= 5.3)) {
			$phpConfigItems[$k]['s'] = 1;
		}
		else {
			$phpConfigItems[$k]['s'] = 0;
			$checkNextStep = 0;
		}
	}
}

function check_extension(&$extensionItems, &$checkNextStep) {
	foreach($extensionItems as $k => $v) {
		if(strpos($v['name'], '|')) {
			$extensionItems[$k]['s'] = 0;

			$ext = explode('|', $v['name']);
			foreach($ext as $e) {
				if(extension_loaded($e)) {
					$extensionItems[$k]['s'] = 1;
				}
			}

			if(0 == $extensionItems[$k]['s']) {
				$checkNextStep = 0;
			}
		}
		else {
			if(extension_loaded($v['name'])) {
				$extensionItems[$k]['s'] = 1;
			}
			else {
				$extensionItems[$k]['s'] = 0;
				$checkNextStep = 0;
			}
		}
	}
}

function check_function(&$functionItems, &$checkNextStep) {
	foreach($functionItems as $k => $v) {
		if(function_exists($v['name'])) {
			$functionItems[$k]['s'] = 1;
		}
		else {
			$functionItems[$k]['s'] = 0;
			$checkNextStep = 0;
		}
	}
}

function check_post($p) {
	$errorMessage = '';
	foreach($p as $k => $v) {
		if(0 == strlen($v)) {
			$errorMessage .= "\r\n".L($k).' '.L('NO_EMPTY').'<br />';
		}
	}
	return $errorMessage;
}


function check_db($dbHost, $dbPort, $dbUser, $dbPassword, $dbDatabase, $dbPrefix, $dbConnection) {
	if(!extension_loaded($dbConnection)) {
		return $dbConnection.L('EXTENSION_NOT_SUPPORT');
	}

	$errorMessage = '';

	if('mysqli' == $dbConnection) {
		$link = @mysqli_connect($dbHost, $dbUser, $dbPassword, '', $dbPort);
		if(!$link) {
			$errorMessage = mysqli_connect_error();
		}
		elseif(!@mysqli_select_db($link, $dbDatabase)) {
			@mysqli_query($link, "CREATE DATABASE `{$dbDatabase}` DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci") or $errorMessage = L('DB_DATABASE_INEXISTENCE');
		}
		else {
			$query = mysqli_query($link, "SHOW TABLES FROM `{$dbDatabase}`");
			while($row = mysqli_fetch_row($link, $query)) {
				if(preg_match("/^{$dbPrefix}/", $row[0])) {
					$errorMessage = L('DB_PREFIX_EXIST');
				}
			}
		}
	}
	else {
		if(!@mysql_connect((empty($dbPort) ? $dbHost : $dbHost.':'.$dbPort), $dbUser, $dbPassword)) {
			$errno = mysql_errno();
			if(1045 == $errno) {
				$errorMessage = L('DB_ERROR_NO_1045');
			}
			elseif(2003 == $errno) {
				$errorMessage = L('DB_ERROR_NO_2003');
			}
			else {
				$errorMessage = L('DB_CONNECT_FAILED');
			}
		}
		elseif(!@mysql_select_db($dbDatabase)) {
			@mysql_query("CREATE DATABASE `{$dbDatabase}` DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci") or $errorMessage = L('DB_DATABASE_INEXISTENCE');
		}
		else {
			$query = mysql_query("SHOW TABLES FROM `{$dbDatabase}`");
			while($row = mysql_fetch_row($query)) {
				if(preg_match("/^{$dbPrefix}/", $row[0])) {
					$errorMessage = L('DB_PREFIX_EXIST');
				}
			}
		}
	}

	return $errorMessage;
}

function run_sql($sqlFile) {
	vendor('Sql#class');

	$sql = file_get_contents($sqlFile);
	$sql = str_replace('`prefix_', '`' . C('DB.PREFIX'), $sql);
	$sql = Sql::remove_comments(Sql::remove_remarks($sql));
	$query = trim_array(Sql::split_sql($sql), '', true);

	$c = 1;
	$t = count($query);
	$_err = '';
	foreach($query as $q) {
		if(empty($q)) {
			continue;
		}
		$table = '';
		preg_match('/`\w*`/', $q, $table);
		if(!empty($q)) {
			if(false === M()->execute($q)) {
				$_err .= $q . ";\r\n";
			}
		}
		$m = L('RUN_SQL');
		if(!empty($_err)) {
			$m = L('UPGRADE_FAILED');
		}
		if('SET SQL_MODE' == substr(strtoupper($q), 0, 12)) {
			$m = L('SET_SQL_MODE');
		}
		elseif('SET TIME_ZONE' == substr(strtoupper($q), 0, 13)) {
			$m = L('SET_TIME_ZONE');
		}
		elseif('DROP TABLE' == substr(strtoupper($q), 0, 10)) {
			$m = L('DROP_TABLE').$table[0];
		}
		elseif('CREATE TABLE' == substr(strtoupper($q), 0, 12)) {
			$m = L('CREATE_TABLE').$table[0];
		}
		elseif('INSERT INTO' == substr(strtoupper($q), 0, 11)) {
			$m = L('INSERT_DATA_INTO').$table[0];
		}
		$b = round($c/$t*75, 0);
		show_progress($m, $b);
		$c++;
	}
	if(!empty($_err)) {
		$temp = function_exists('gd_info') ? gd_info() : array('GD Version' => 'NONSUPPORT');
		$_t = "//upgrade information\r\n";
		$_t .= "//----------------------------------------\r\n";
		$_t .= "//soft: ".SOFT_NAME." ".SOFT_CODENAME." ".SOFT_CHARSET." version".SOFT_VERSION."\r\n";
		$_t .= "//OS: ".PHP_OS."\r\n";
		$_t .= "//PHP_VERSION: ".PHP_VERSION."\r\n";
		$_t .= "//UPLOAD_MAX_FILESIZE: ".ini_get('upload_max_filesize')."\r\n";
		$_t .= "//GD_VERSION: ".$temp['GD Version']."\r\n";
		$_t .= "//DISK_SPACE: ".floor(diskFreeSpace(SOFT_PATH) / (1024*1024)).'M'."\r\n";
		$_t .= "//----------------------------------------\r\n\r\n";
		$_err = $_t.$_err;
		file_put_contents(APP_PATH.D_S.'upgrade_err.txt', $_err);
		show_progress(L('UPGRADE_FAILED'), 75);
		exit;
	}
}

function show_progress($message, $barLength) {
	echo "<script type=\"text/javascript\">show_progress('{$message}', '{$barLength}%');</script>\r\n";
	@ob_flush();
	@flush();
}

function save_defineFile($defineFile, $define) {
	$s = "<?php\r\n".PFA_ACCESS_CHECK;
	foreach($define as $k => $v) {
		$s .= "define('".$k."', '".$v."');\r\n";
	}
	$s .= '?>';
	@file_put_contents($defineFile, $s);
}

function save_configFile($filename, $array = '') {
	$content = "<?php\r\nreturn '';\r\n?>";
	if(is_array($array)) {
		$content = "<?php\r\n".PFA_ACCESS_CHECK."return ".var_export($array, true).";\r\n?>";
	}
	@file_put_contents($filename, $content);
}

function lock() {
	date_default_timezone_set(C('APP.TIMEZONE'));
	$s = "<?php\r\n";
	$s .= "//upgrade information\r\n";
	$s .= "//----------------------------------------\r\n";
	$s .= "//soft: ".SOFT_NAME." ".SOFT_CODENAME." ".SOFT_CHARSET." version".SOFT_VERSION."\r\n";
	$s .= "//host: ".__HOST__."\r\n";
	$s .= "//time: ".date('Y-m-d H:i:s T', NOW_TIME)."\r\n";
	$s .= "header('location:".dirname(__APP__)."');\r\n";
	$s .= "?>";
	@file_put_contents(LOCK_FILE, $s);
}

?>