<?php

/**
 *--------------------------------------
 * upgrade
 *--------------------------------------
 * @project		: upgrade
 * @author		: cblee
 * @created		: 2017-06-08
 * @copyright	: (c)2017 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class IndexCtrlr extends Ctrlr {
	public function __construct() {
		parent::__construct();
		$_C = require_cache(CONFIG_FILE);
		C('DB', $_C['DB']);
	}

	public function index() {
		check_lock();

		define('SITE_URL', trim(__HOST__.dirname(APP_ROOT), '/\\').'/');
		define('SITE_MANAGE_URL', SITE_URL . 'admin.php');

		$step = isset($_POST['step']) ? $_POST['step'] : 0;
		if(4 != $step) {
			check_version();
		}
		switch ($step) {
			case '1':
				$this->_step1();
				break;
			case '2':
				$this->_step2();
				break;
			case '3':
				$this->_step3();
				break;
			case '4':
				$this->_step4();
				break;
			default:
				$this->_step0();
				break;
		}
	}

	/* choose language */
	private function _step0() {
		$_LS = get_langset();
		$selectHight = count($_LS) > 5 ? count($_LS) : 5;
		$this->assign('selectHight', $selectHight);
		$this->assign('_LS', $_LS);
		$this->display('index');
	}

	/* show introduce */
	private function _step1() {
		$_README = file_get_contents(LANG_PATH.D_S.LANG_NAME.D_S.'README.html');
		$this->assign('_README', $_README);
		$this->display('step1');
	}

	/* check environment */
	private function _step2() {
		$checkNextStep = true;

		/* check system */
		$systemItems = C('CHECK_ITEMS.SYSTEM');
		if(!empty($systemItems)) {
			check_system($systemItems, $checkNextStep);
			foreach($systemItems as $k => $v) {
				$systemItems[L($k)]['r'] = L($v['r']);
				$systemItems[L($k)]['b'] = L($v['b']);
				$systemItems[L($k)]['c'] = L($v['c']);
				if(1 == $v['s']) {
					$systemItems[L($k)]['c_c'] = 'class="y"';
				}
				else {
					$systemItems[L($k)]['c_c'] = 'class="n"';
				}
				unset($systemItems[$k]);
			}
		}

		/* check dir and file */
		$dirFileItems = C('CHECK_ITEMS.DIR_FILE');
		if(!empty($dirFileItems)) {
			check_dirfile($dirFileItems, $checkNextStep);
			foreach($dirFileItems as $k => $v) {
				$dirFileItems[L($k)]['type'] = L($v['type']);
				$dirFileItems[L($k)]['c'] = L($v['c']);
				$dirFileItems[L($k)]['path'] = $v['path'];
				if(1 == $v['s']) {
					$dirFileItems[L($k)]['c_c'] = 'class="y"';
				}
				else {
					$dirFileItems[L($k)]['c_c'] = 'class="n"';
				}
				unset($dirFileItems[$k]);
			}
		}

		/* check php config */
		$phpConfigItems = C('CHECK_ITEMS.PHP_CONFIG');
		if(!empty($phpConfigItems)) {
			check_phpConfig($phpConfigItems, $checkNextStep);
			foreach($phpConfigItems as $k => $v) {
				if(1 == $v['s']) {
					$phpConfigItems[$k]['c_c'] = 'class="y"';
				}
				else {
					$phpConfigItems[$k]['c_c'] = 'class="n"';
				}
			}
		}

		/* check extension */
		$extensionItems = C('CHECK_ITEMS.EXTENSION');
		if(!empty($extensionItems)) {
			check_extension($extensionItems, $checkNextStep);
			foreach($extensionItems as $k => $v) {
				if(1 == $v['s']) {
					$extensionItems[$k]['c_c'] = 'class="y"';
					$extensionItems[$k]['s'] = L('SUPPORT');
				}
				else {
					$extensionItems[$k]['c_c'] = 'class="n"';
					$extensionItems[$k]['s'] = L('NONSUPPORT');
				}
			}
		}

		/* check function */
		$functionItems = C('CHECK_ITEMS.FUNCTION');
		if(!empty($functionItems)) {
			check_function($functionItems, $checkNextStep);
			foreach($functionItems as $k => $v) {
				if(1 == $v['s']) {
					$functionItems[$k]['c_c'] = 'class="y"';
					$functionItems[$k]['s'] = L('SUPPORT');
				}
				else {
					$functionItems[$k]['c_c'] = 'class="n"';
					$functionItems[$k]['s'] = L('NONSUPPORT');
				}
			}
		}

		$this->assign('checkNextStep', $checkNextStep);
		$this->assign('systemItems', $systemItems);
		$this->assign('dirFileItems', $dirFileItems);
		$this->assign('phpConfigItems', $phpConfigItems);
		$this->assign('extensionItems', $extensionItems);
		$this->assign('functionItems', $functionItems);
		$this->display('step2');
	}

	/* write data */
	private function _step3() {
		$this->display('step3');

		/* run sql */
		$sql = trim(file_get_contents(UPGRADE_CFG_PATH.D_S.'data.sql'));
		if(!empty($sql)) {
			$sql = str_replace(
				array(
					'{-time-}',
					'{-ip-}',
					'{-site_url-}'
				),
				array(
					NOW_TIME,
					CLIENT_IP,
					SITE_URL
				),
				$sql);
			@file_put_contents(DATA_PATH.D_S.'_data.sql', $sql);
			run_sql(DATA_PATH.D_S.'_data.sql');
		}

		/* replace data */
		include(UPGRADE_CFG_PATH.D_S.'replace_data.php');

		/* delete file */
		$_file = include(UPGRADE_CFG_PATH.D_S.'delete_files.php');
		if(!empty($_file)) {
			$_fileCount = count($_file);
			foreach($_file as $key => $_file) {
				@unlink($_file);
				$b = round(($key + 1) / $_fileCount * 100, 0);
				show_progress(L('DELETE_FILE'), $b);
			}
		}

		$_C = include(CONFIG_FILE);
		/* upgrade config file */
		$_c = include(UPGRADE_CFG_PATH.D_S.'cfg.php');
		if(!empty($_c)) {
			$_C = array_merge($_C, $_c);
			save_configFile(CONFIG_FILE, $_C);
		}
		show_progress(L('UPGRADE_CONFIG_FILE'), 75);

		/* upgrade route */
		$_r = include(UPGRADE_CFG_PATH.D_S.'route'.D_S.'route.php');
		if(!empty($_r)) {
			$_R = include(SOFT_APP_PATH.D_S.'cfg'.D_S.'route.php');
			$_R = array_merge($_R, $_r);
			save_configFile(SOFT_APP_PATH.D_S.'cfg'.D_S.'route.php', $_R);
		}


		$_r = include(UPGRADE_CFG_PATH.D_S.'route'.D_S.'route_base.php');
		if(!empty($_r)) {
			$_R = include(SOFT_APP_PATH.D_S.'cfg'.D_S.'route_base.php');
			$_R = array_merge($_R, $_r);
			save_configFile(SOFT_APP_PATH.D_S.'cfg'.D_S.'route_base.php', $_R);
			if(!$_C['URL']['LANG_SUFFIX']) {
				save_configFile(SOFT_APP_PATH.D_S.'cfg'.D_S.'route.php', $_R);
			}
		}
		$_r = include(UPGRADE_CFG_PATH.D_S.'route'.D_S.'route_lang.php');
		if(!empty($_r)) {
			$_R = include(SOFT_APP_PATH.D_S.'cfg'.D_S.'route_lang.php');
			$_R = array_merge($_R, $_r);
			save_configFile(SOFT_APP_PATH.D_S.'cfg'.D_S.'route_lang.php', $_R);
			if($_C['URL']['LANG_SUFFIX']) {
				save_configFile(SOFT_APP_PATH.D_S.'cfg'.D_S.'route.php', $_R);
			}
		}
		show_progress(L('UPGRADE_ROUTE_FILE'), 80);

		/* upgrade language */
		$dir = UPGRADE_CFG_PATH.D_S.'lang';
		if(false != ($handle = @opendir($dir))) {
			while(($file = readdir($handle)) !== false) {
				if('.' == $file || '..' == $file || is_dir("$dir/$file")) {
					continue;
				}
				if(is_file("$dir/$file")) {
					$lang = substr($file, 0, -4);
					$_l = include($dir.D_S.$file);
					if(!empty($_l)) {
						$_L = include(SOFT_APP_PATH.D_S.'lang'.D_S.$lang.D_S.'lang.php');
						$_L = array_merge($_L, $_l);
						save_configFile(SOFT_APP_PATH.D_S.'lang'.D_S.$lang.D_S.'lang.php', $_L);
					}
				}
			}
		}
		show_progress(L('UPGRADE_LANGUAGE'), 85);
		/* upgrade language */
		$dir = UPGRADE_CFG_PATH.D_S.'lang'.D_S.'Admin';
		if(false != ($handle = @opendir($dir))) {
			while(($file = readdir($handle)) !== false) {
				if('.' == $file || '..' == $file || is_dir("$dir/$file")) {
					continue;
				}
				if(is_file("$dir/$file")) {
					$lang = substr($file, 0, -4);
					$_l = include($dir.D_S.$file);
					if(!empty($_l)) {
						$_L = include(SOFT_APP_PATH.D_S.'lang'.D_S.$lang.D_S.'Admin'.D_S.'lang.php');
						$_L = array_merge($_L, $_l);
						save_configFile(SOFT_APP_PATH.D_S.'lang'.D_S.$lang.D_S.'Admin'.D_S. 'lang.php', $_L);
					}
				}
			}
		}
		show_progress(L('UPGRADE_MANAGE_LANGUAGE'), 90);

		/* upgrade version */
		$define = file_get_contents(DEFINE_FILE);
		$define = preg_replace('/define\(\'SOFT_VERSION\', \'(.*)\'\);/i', 'define(\'SOFT_VERSION\', \''.SOFT_VERSION_TO.'\');', $define);
		@file_put_contents(DEFINE_FILE, $define);
		show_progress(L('UPGRADE_VERSION'), 95);

		/* delete runtime files */
		@unlink(DATA_PATH.D_S.'_data.sql');
		$runtimeFile = SOFT_APP_PATH.D_S.'rt'.D_S.'_runtime.php';
		@unlink($runtimeFile);
		show_progress(L('UPGRADE_SUCCESS'), 100);
	}

	/* lock upgrade */
	private function _step4() {
		lock();
		$this->display('step4');
	}

}
?>