<?php

/**
 *--------------------------------------
 * loga:a_list
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-08
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class TagLogaAList {
	public function get_tagStr($a) {
		$aid = 'aid';
		$not = 'not';
		$cid = 'cid';
		$flag = 'flag';
		$days = 'days';
		$keywords = 'keywords';
		$orderby = 'orderby';
		$offset = 0;
		$row = 10;
		$titleLenStr = '';
		$titleStyleStr = '';
		$key = 'k';
		$as = 'item';

		$where = "	\$where = array();\r\n";
		$where .= "	\$where['__ARTICLE__.a_status'] = array('EQ', 1);\r\n";

		/* direct read article id */
		if(isset($a['aid']) and !empty($a['aid'])) {
			if(strpos($a['aid'], ',')) {
				$where .= "	\$where['__ARTICLE__.article_id'][] = array('IN', '{$a['aid']}');\r\n";
				$aid = str_replace(',', 'loga', $a['aid']);
			}
			else {
				if(strpos($a['aid'], '$')) {
					$where .= "	if(!empty(".substr($a['aid'], 2, -2).")) {\r\n";
					$where .= "		\$where['__ARTICLE__.article_id'][] = array('IN', '{$a['aid']}');\r\n";
					$where .= "	}\r\n";
				}
				else {
					$where .= "	\$where['__ARTICLE__.article_id'][] = array('IN', '{$a['aid']}');\r\n";
				}
				$aid = $a['aid'];
			}
		}

		/* exclude id */
		if(isset($a['not']) and !empty($a['not'])) {
			if(strpos($a['not'], ',')) {
				$where .= "	\$where['__ARTICLE__.article_id'][] = array('NOT IN', '{$a['not']}');\r\n";
				$not = str_replace(',', 'uwanot', $a['not']);
			}
			else {
				if(strpos($a['not'], '$')) {
					$where .= "	if(!empty(".substr($a['not'], 2, -2).")) {\r\n";
					$where .= "		\$where['__ARTICLE__.article_id'][] = array('NOT IN', '{$a['not']}');\r\n";
					$where .= "	}\r\n";
				}
				else {
					$where .= "	\$where['__ARTICLE__.article_id'][] = array('NOT IN', '{$a['not']}');\r\n";
				}
				$not = $a['not'];
			}
		}

		/* category id */
		if(!isset($a['cid']) or empty($a['cid'])) {
			$cid = "'.(isset(\$AC_ID) ? \$AC_ID : 0).'";
		}
		elseif('all' == $a['cid']) {
			$cid = 0;
		}
		else {
			if(strpos($a['cid'], '$')) {
				$cid = "'.(!empty(".substr($a['cid'], 2, -2).") ? '{$a['cid']}' : 0).'";
			}
			else {
				$cid = $a['cid'];
			}
		}

		if(strpos($cid, ',')) {
			$where .= "	\$where['__ARTICLE__.article_category_id'] = array('IN', '{$cid}');\r\n";
			$cid = str_replace(',', 'loga', $cid);
		}
		elseif('all' != $cid) {
			$where .= "\$_ACL = M('ArticleCategory')->get_categoryList();\r\n";
			$where .= "\$act = new ATree(\$_ACL, array('article_category_id', 'ac_parent_id', 'ac_sub_category'));\r\n";
			$where .= "	\$where['__ARTICLE__.article_category_id'] = array('IN', implode(',', \$act->get_leafid('{$cid}')));\r\n";
		}

		/* article flag */
		if(isset($a['flag']) and !empty($a['flag'])) {
			if(strpos($a['flag'], '$')) {
				$where .= "	if(!empty(".substr($a['flag'], 2, -2).")) {\r\n";
				$where .= "		\$where['__ARTICLE__.af_alias'] = array('INSET', '{$a['flag']}');\r\n";
				$where .= "	}\r\n";
			}
			else {
				$where .= "	\$where['__ARTICLE__.af_alias'] = array('INSET', '{$a['flag']}');\r\n";
			}
			$flag = str_replace(array('|', '&'), array('_or_', '_and_'), $a['flag']);
		}
		/* time limit */
		if(isset($a['days']) and !empty($a['days'])) {
			if(strpos($a['days'], '$')) {
				$where .= "	if(0 < ".substr($a['days'], 2, -2).") {\r\n";
				$where .= "		\$where['__ARTICLE__.a_edit_time'] = array('GT', NOW_TIME - 86400*('{$a['days']}'));\r\n";
				$where .= "	}\r\n";
			}
			else {
				$where .= "	\$where['__ARTICLE__.a_edit_time'] = array('GT', NOW_TIME - 86400*('{$a['days']}'));\r\n";
			}
			$days = $a['days'];
		}
		/* keyword: support multi keywords like 'keyword1,keyword2' */
		$pycForKeywords = '';
		if(isset($a['keywords']) and !empty($a['keywords'])) {
			if(!strpos($a['keywords'], '$')) {
				vendor('Pinyin#class'); $pyc = get_instance('Pinyin');
				$keywords = str_replace(array('_', ' '), array('-', ''), strtolower($pyc->get_pinyin($a['keywords'], 'utf-8')));
			}
			else {
				$pycForKeywords = "vendor('Pinyin#class'); \$pyc = get_instance('Pinyin');\r\n";
				$keywords = "'.str_replace(array('_', ' '), array('-', ''), strtolower(\$pyc->get_pinyin('{$a['keywords']}', 'utf-8'))).'";
			}

			$where .= "	\$_al_keywords = explode(',', '{$a['keywords']}', 5);\r\n";
			$where .= "	\$_al_like = array();\r\n";
			$where .= "	foreach(\$_al_keywords as \$_alkk => \$_alkv) {\r\n";
			$where .= "		\$_alkv = trim(\$_alkv);\r\n";
			$where .= "		if(empty(\$_alkv)) {\r\n";
			$where .= "			continue;\r\n";
			$where .= "		}\r\n";
			$where .= "		\$_al_like[] = array('LIKE', '%'.\$_alkv.'%');\r\n";
			$where .= "	}\r\n";
			$where .= "	if(!empty(\$_al_like)) {\r\n";
			$where .= "		\$_al_like[] = 'OR';\r\n";
			$where .= "		\$where['__ARTICLE__.a_keywords'] = \$_al_like;\r\n";
			$where .= "	}\r\n";
		}

		/* order by */
		if(isset($a['orderby']) and !empty($a['orderby'])) {
			if(strpos($a['orderby'], '$')) {
				$order = "'.(!empty(".substr($a['orderby'], 2, -2).") ? '`{$a['orderby']}`' : '`a_edit_time`').'";
			}
			else {
				$order = "`{$a['orderby']}`";
			}
			if(isset($a['order']) and !empty($a['order'])) {
				$order .= " {$a['order']}";
				$orderby = $a['orderby'].'_'.$a['order'];
			}
			else {
				$orderby = $a['orderby'].'_order';
			}
		}
		if(empty($order)) {
			if(isset($a['aid']) and !empty($a['aid'])) {
				$order = "field(__ARTICLE__.article_id,{$a['aid']})";
			}
			else {
				$order = '`a_rank` DESC, `a_edit_time` DESC';
			}
		}

		/* limit strat row */
		if(isset($a['offset']) and !empty($a['offset'])) {
			if(strpos($a['offset'], '$')) {
				$offset = "'.(!empty(".substr($a['offset'], 2, -2).") ? '{$a['offset']}' : '{$offset}').'";
			}
			else {
				$offset = $a['offset'];
			}
		}

		/* row */
		if(isset($a['row']) and !empty($a['row'])) {
			if(strpos($a['row'], '$')) {
				$row = "'.(!empty(".substr($a['row'], 2, -2).") ? '{$a['row']}' : '{$row}').'";
			}
			else {
				$row = $a['row'];
			}
		}

		/* key */
		if(isset($a['key']) and !empty($a['key'])) {
			if(strpos($a['key'], '$')) {
				$key = "'.(!empty(".substr($a['key'], 2, -2).") ? '{$a['key']}' : '{$key}').'";
			}
			else {
				$key = $a['key'];
			}
		}

		/* as */
		if(isset($a['as']) and !empty($a['as'])) {
			if(strpos($a['as'], '$')) {
				$as = "'.(!empty(".substr($a['as'], 2, -2).") ? '{$a['as']}' : '{$as}').'";
			}
			else {
				$as = $a['as'];
			}
		}

		/* title length */
		if(isset($a['titlelen']) and !empty($a['titlelen'])) {
			if(strpos($a['titlelen'], '$')) {
				$titleLenStr .= "if(!empty(".substr($a['titlelen'], 2, -2).")) {\r\n";
				$titleLenStr .= "	\${$as}['a_title'] = AString::mono_substr(\${$as}['a_title'], '{$a['titlelen']}');\r\n";
				$titleLenStr .= "}\r\n";
			}
			else {
				$titleLenStr = "\${$as}['a_title'] = AString::mono_substr(\${$as}['a_title'], '{$a['titlelen']}');\r\n";
			}
		}

		$str = "<?php\r\n";
		$str .= $pycForKeywords;
		$str .= "\$var_al = LANG_NAME.'_a_list_{$aid}_{$not}_{$cid}_{$flag}_{$days}_{$keywords}_{$orderby}_{$offset}_{$row}';\r\n";
		$str .= "\$\$var_al = S('_list/_'.ltrim(\$var_al, '_'), '', null, array('temp' => TEMP_PATH.D_S.'home'));\r\n";
		$str .= "if(empty(\$\$var_al)) {\r\n";
		$str .= $where;
		$str .= "	\$\$var_al = M('Article')->get_articleList(\$where, '{$order}', '{$offset},{$row}');\r\n";
		/* expire */
		if(isset($a['expire']) and !empty($a['expire'])) {
			if(strpos($a['expire'], '$')) {
				$expire = "'.(!empty(".substr($a['expire'], 2, -2).") ? '{$a['expire']}' : '{$expire}').'";
			}
			else {
				$expire = $a['expire'];
			}
			$str .= "	S('_list/_'.ltrim(\$var_al, '_'), \$\$var_al, '{$expire}', array('temp' => TEMP_PATH.D_S.'home'));\r\n";
		}
		else {
			$str .= "	S('_list/_'.ltrim(\$var_al, '_'), \$\$var_al, null, array('temp' => TEMP_PATH.D_S.'home'));\r\n";
		}
		$str .= "}\r\n";
		$str .= "if(\$\$var_al) : foreach(\$\$var_al as \${$key} => \${$as}): \r\n";
		$str .= $titleLenStr;
		$str .= $titleStyleStr;
		$str .= "?>\r\n";
		return $str;
	}

	public function get_tagEndStr() {
		$str = "<?php endforeach; endif; ?>\r\n";
		return $str;
	}
}

?>