<?php

/**
 *--------------------------------------
 * ad space
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-06
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class AdSpaceCtrlr extends ManageCtrlr {
	public function list_space() {
		$_ASL = M('AdSpace')->get_spaceList(false, false);
		$this->assign('_ASL', $_ASL);
		$this->display('ad_space/list_space');
	}

	public function add_space() {
		$this->display('ad_space/add_space');
	}
	public function add_space_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		$result = M('AdSpace')->add_space($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('ADD_AD_SPACE').': '.$result['error'], 0);
			$this->error($result['error'], Url::U('ad_space/list_space'));
		}

		M('Log')->add_log(L('ADD_AD_SPACE').': ['.$result['data'].']');
		$this->success(L('ADD_SUCCESS'), Url::U('ad_space/list_space'));
	}

	public function edit_space() {
		$asAlias = ARequest::get('as_alias');
		$_ASI = M('AdSpace')->get_spaceInfo($asAlias, false);
		if(empty($_ASI)) {
			$this->error(L('ITEM_INEXISTENCE'), Url::U('ad_space/list_space'));
		}
		$this->assign('_ASI', $_ASI);

		$this->display('ad_space/edit_space');
	}
	public function edit_space_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		$result = M('AdSpace')->edit_space($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('EDIT_AD_SPACE').': ['.$data['as_alias'].']'.$result['error'], 0);
			$this->error($result['error'], Url::U('ad_space/list_space'));
		}
		M('Log')->add_log(L('EDIT_AD_SPACE').': ['.$data['as_alias'].']');
		$this->success(L('EDIT_SUCCESS'), Url::U('ad_space/list_space'));
	}

	public function delete_space_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$asAlias = ARequest::get('as_alias');
		$asAlias = is_array($asAlias) ? $asAlias : explode(',', $asAlias);
		$_L_ID = implode(', ', $asAlias);

		foreach($asAlias as $asAlias) {
			$result = M('AdSpace')->delete_space($asAlias);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('DELETE_AD_SPACE').': ['.$asAlias.']'.$result['error'], 0);
				$this->error($result['error'], Url::U('ad_space/list_space'));
			}
		}

		M('Log')->add_log(L('DELETE_AD_SPACE').': ['.$_L_ID.']');
		$this->success(L('DELETE_SUCCESS'), Url::U('ad_space/list_space'));
	}

	public function toggle_space_status_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = array();
		$data['as_alias'] = ARequest::get('as_alias');
		$data['as_status'] = ARequest::get('as_status');
		if(false === M('AdSpace')->update($data)) {
			M('Log')->add_log(L('TOGGLE_AD_SPACE_STATUS').': ['.$data['as_alias'].']', 0);
			$this->error(L('TOGGLE_FAILED'), Url::U('ad_space/list_space'));
		}

		clear_dir(DATA_PATH.D_S.'_asl');
		clear_dir(DATA_PATH.D_S.'_asi');
		M('Log')->add_log(L('TOGGLE_AD_SPACE_STATUS').': ['.$data['as_alias'].']');
		$this->success(L('TOGGLE_SUCCESS'), Url::U('ad_space/list_space'));
	}

}

?>