<?php

/**
 *--------------------------------------
 * file explore
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2017-03-30
 * @copyright	: (c)2017 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class FileExploreCtrlr extends ManageCtrlr {
	protected $_o;

	public function __construct() {
		parent::__construct();

		$this->_o = M('Option')->get_option('upload');
	}

	public function list_file() {
		$dir = ARequest::get('dir');
		if(!FileExploreModl::check_dirStr($dir)) {
			$this->error(L('DIR_INEXISTENCE'), Url::U('file_explore/list_file'));
		}

		$currentDir = D_S.ltrim(str_replace(array('*', '@'), array(D_S, '.'), $dir), D_S);
		if(D_S == $currentDir) {
			$currentDir = '';
		}

		$_FL = M('FileExplore')->get_fileList($currentDir);
		$this->assign('_FL', $_FL);

		$this->assign('_O', $this->_o);

		$this->display('file_explore/list_file');
	}

	public function delete_dir_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$dir = ARequest::get('dir');
		if(!FileExploreModl::check_dirStr($dir)) {
			$this->error(L('DIR_INEXISTENCE'), Url::U('file_explore/list_file'));
		}

		$dirname = str_replace(' ', '', AFilter::text(ARequest::get('dirname')));
		if(!FileExploreModl::check_filename($dirname)) {
			$this->error(L('DIR_INEXISTENCE'), Url::U('file_explore/list_file'));
		}

		$result = M('FileExplore')->delete_dir($dir, $dirname);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('DELETE_DIR').': ['.$dir.$dirname.']', 0);
			$this->error(L('DELETE_DIR_FAILED').': '.$result['error'], Url::U('file_explore/list_file?dir='.$dir));
		}

		M('Log')->add_log(L('DELETE_DIR').': ['.$dir.$dirname.']');
		$this->success(L('DELETE_SUCCESS'), Url::U('file_explore/list_file?dir='.$dir));
	}

	public function delete_file_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$dir = ARequest::get('dir');
		if(!FileExploreModl::check_dirStr($dir)) {
			$this->error(L('DIR_INEXISTENCE'), Url::U('file_explore/list_file'));
		}

		$file = ARequest::get('file');
		if(!FileExploreModl::check_filename($file)) {
			$this->error(L('DIR_INEXISTENCE'), Url::U('file_explore/list_file'));
		}

		$result = M('FileExplore')->delete_file($dir, $file);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('DELETE_FILE').': ['.$dir.$file.']', 0);
			$this->error(L('DELETE_FILE_FAILED').': '.$result['error'], Url::U('file_explore/list_file?dir='.$dir));
		}

		M('Log')->add_log(L('DELETE_FILE').': ['.$dir.$file.']');
		$this->success(L('DELETE_SUCCESS'), Url::U('file_explore/list_file?dir='.$dir));
	}

	public function add_dir_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$dir = ARequest::get('dir');
		if(!FileExploreModl::check_dirStr($dir)) {
			$this->error(L('DIR_INEXISTENCE'), Url::U('file_explore/list_file'));
		}

		$dirname = str_replace(' ', '', AFilter::text(ARequest::get('dirname')));
		if(!FileExploreModl::check_filename($file)) {
			$this->error(L('DIR_INEXISTENCE'), Url::U('file_explore/list_file'));
		}

		$result = M('FileExplore')->add_dir($dir, $dirname);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('ADD_DIR').': ['.$dir.$dirname.']', 0);
			$this->error(L('ADD_DIR_FAILED').': '.$result['error'], Url::U('file_explore/list_file?dir='.$dir));
		}

		M('Log')->add_log(L('ADD_DIR').': ['.$dir.$dirname.']');
		$this->success(L('ADD_DIR_SUCCESS'), Url::U('file_explore/list_file?dir='.$dir));
	}

	public function upload_file_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$dir = ARequest::get('dir');
		if(!FileExploreModl::check_dirStr($dir)) {
			$this->error(L('DIR_INEXISTENCE'), Url::U('file_explore/list_file'));
		}

		$field = 'uploadFile';

		$currentDir = D_S.ltrim(str_replace(array('*', '@'), array(D_S, '.'), $dir), D_S);
		if(D_S == $currentDir) {
			$currentDir = '';
		}
		$uploadDir = ROOT_PATH.D_S.$this->_o['dir'].$currentDir;

		$u_params = array();
		$u_params['fileNaming'] = 0;
		$u_params['uploadDir'] = $uploadDir;
		$u_params['typeset'] = array_merge(explode(',', $this->_o['imgtype']), explode(',', $this->_o['filetype']));

		$_u = get_instance('AUpload', $u_params);
		$upload = $_u->do_upload($field);

		$err = $_u->uploadError['msg'][0];
		if(!empty($err)) {
			M('Log')->add_log(L('UPLOAD_FILE').': ['.$dir.$upload['name'].']', 0);
			$this->error(L('UPLOAD_FAILED').': '.$err, Url::U('file_explore/list_file?dir='.$dir));
		}
		M('Log')->add_log(L('UPLOAD_FILE').': ['.$dir.$upload['name'].']');
		$this->success(L('UPLOAD_SUCCESS'), Url::U('file_explore/list_file?dir='.$dir));
	}
}

?>