<?php

/**
 *--------------------------------------
 * flink category
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-08-20
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class FlinkCategoryCtrlr extends ManageCtrlr {
	public function list_category() {
		$_FCL = M('FlinkCategory')->get_categoryList(false);
		$this->assign('_FCL', $_FCL);
		$this->display('flink_category/list_category');
	}

	public function add_category() {
		$this->display('flink_category/add_category');
	}
	public function add_category_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();
		$result = M('FlinkCategory')->add_category($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('ADD_FLINK_CATEGORY').': '.$result['error'], 0);
			$this->error($result['error'], Url::U('flink_category/list_category'));
		}

		M('Log')->add_log(L('ADD_FLINK_CATEGORY').': ['.$result['data'].']');
		$this->success(L('ADD_SUCCESS'), Url::U('flink_category/list_category'));
	}

	public function edit_category() {
		$fcAlias = ARequest::get('fc_alias');
		$_FCI = M('FlinkCategory')->get_categoryInfo($fcAlias, false);
		if(empty($_FCI)) {
			$this->error(L('ITEM_INEXISTENCE'), Url::U('flink_category/list_category'));
		}
		$this->assign('_FCI', $_FCI);

		$this->display('flink_category/edit_category');
	}
	public function edit_category_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		$result = M('FlinkCategory')->edit_category($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('EDIT_FLINK_CATEGORY').': ['.$data['fc_alias'].']'.$result['error'], 0);
			$this->error($result['error'], Url::U('flink_category/list_category'));
		}
		M('Log')->add_log(L('EDIT_FLINK_CATEGORY').': ['.$data['fc_alias'].']');
		$this->success(L('EDIT_SUCCESS'), Url::U('flink_category/list_category'));
	}

	public function update_category_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$fcAlias = ARequest::get('fc_alias');
		$fcName = ARequest::get('fc_name');
		$fcDisplayOrder = ARequest::get('fc_display_order');
		$_L_ID = is_array($fcAlias) ? implode(', ', $fcAlias) : $fcAlias;

		if(!is_array($fcAlias) or empty($fcAlias)) {
			M('Log')->add_log(L('EDIT_FLINK_CATEGORY').': ['.$fcAlias.']'.L('ITEM_INEXISTENCE'), 0);
			$this->error(L('ITEM_INEXISTENCE'), Url::U('flink_category/list_category'));
		}

		$data = array();
		$error = false;
		foreach($fcAlias as $k => $alias) {
			$data['fc_alias'] = $alias;
			$data['fc_name'] = $fcName[$k];
			$data['fc_display_order'] = $fcDisplayOrder[$k];
			$result = M('FlinkCategory')->edit_category($data);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('EDIT_FLINK_CATEGORY').': ['.$fcAlias.']', 0);
				$this->error(L('EDIT_FAILED'), Url::U('flink_category/list_category'));
			}
		}

		M('Log')->add_log(L('EDIT_FLINK_CATEGORY').': ['.$_L_ID.']');
		$this->success(L('EDIT_SUCCESS'), Url::U('flink_category/list_category'));
	}

	public function delete_category_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$fcAlias = ARequest::get('fc_alias');
		$fcAlias = is_array($fcAlias) ? $fcAlias : explode(',', $fcAlias);
		$_L_ID = implode(', ', $fcAlias);

		foreach($fcAlias as $fcAlias) {
			$result = M('FlinkCategory')->delete_category($fcAlias);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('DELETE_FLINK_CATEGORY').': ['.$fcAlias.']'.$result['error'], 0);
				$this->error($result['error'], Url::U('flink_category/list_category'));
			}
		}

		M('Log')->add_log(L('DELETE_FLINK_CATEGORY').': ['.$_L_ID.']');
		$this->success(L('DELETE_SUCCESS'), Url::U('flink_category/list_category'));
	}
}

?>