<?php

/**
 *--------------------------------------
 * option
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-06-27
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class OptionCtrlr extends ManageCtrlr {
	public function edit_option_site() {
		$_O = M('Option')->get_option(array('site'));
		$this->assign('_O', $_O);

		$this->display('option/edit_option_site');
	}
	public function edit_option_site_do () {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();
		if(!M('Option')->save_option($data)) {
			M('Log')->add_log(L('EDIT_OPTION_SITE'), 0);
			$this->error(L('EDIT_FAILED'), Url::U('option/edit_option_site'));
		}
		M('Log')->add_log(L('EDIT_OPTION_SITE'));
		$this->success(L('EDIT_SUCCESS'), Url::U('option/edit_option_site'));
	}

	public function edit_option_core() {
		$_TZL = array(
			'-12' => 'GMT -12:00',
			'-11' => 'GMT -11:00',
			'-10' => 'GMT -10:00',
			'-9' => 'GMT -09:00',
			'-8' => 'GMT -08:00',
			'-7' => 'GMT -07:00',
			'-6' => 'GMT -06:00',
			'-5' => 'GMT -05:00',
			'-4' => 'GMT -04:00',
			'-3.5' => 'GMT -03:30',
			'-3' => 'GMT -03:00',
			'-2' => 'GMT -02:00',
			'-1' => 'GMT -01:00',
			'0' => 'GMT',
			'1' => 'GMT +01:00',
			'2' => 'GMT +02:00',
			'3' => 'GMT +03:00',
			'3.5' => 'GMT +03:30',
			'4' => 'GMT +04:00',
			'4.5' => 'GMT +04:30',
			'5' => 'GMT +05:00',
			'5.5' => 'GMT +05:30',
			'5.75' => 'GMT +05:45',
			'6' => 'GMT +06:00',
			'6.5' => 'GMT +06:30',
			'7' => 'GMT +07:00',
			'8' => 'GMT +08:00',
			'9' => 'GMT +09:00',
			'9.5' => 'GMT +09:30',
			'10' => 'GMT +10:00',
			'11' => 'GMT +11:00',
			'12' => 'GMT +12:00',
			'13' => 'GMT +13:00',
		);
		$this->assign('_TZL', $_TZL);

		$_O = M('Option')->get_option(array('core'));
		$this->assign('_O', $_O);

		$this->display('option/edit_option_core');
	}
	public function edit_option_core_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		$_C = array();
		/* time */
		$_C['APP']['TIMEZONE'] = 'Etc/GMT'.($data['core']['timezone'] > 0 ? '-' : '+').abs($data['core']['timezone']);
		$_C['APP']['TIME_FORMAT'] = $data['core']['time_format'];
		/* template */
		$_C['TE']['STRIP_SPACE'] = $data['core']['strip_space'] ? 1 : 0;
		$_C['TE']['GZIP'] = $data['core']['gzip_switch'] ? true : false;
		/* cache */
		$_C['CACHE']['EXPIRE'] = intval($data['core']['cache_expire']);
		/* cookie, session */
		$_C['COOKIE']['PREFIX'] = $data['core']['cookie_prefix'];
		$_C['COOKIE']['KEY'] = $data['core']['security_code'];
		$_C['COOKIE']['EXPIRE'] = intval($data['core']['cookie_expire']);
		$_C['COOKIE']['CLIENT_CHECK'] = $data['core']['cookie_client_check'] ? true : false;
		$_C['SESSION']['PREFIX'] = $data['core']['cookie_prefix'];
		$_C['SESSION']['CLIENT_CHECK'] = $data['core']['session_client_check'] ? true : false;
		$_C['SESSION']['MASTER_DOMAIN'] = $data['core']['session_master_domain'];
		/* debug switch */
		$_C['DEBUG']['SWITCH'] = $data['core']['debug_switch'] ? true : false;
		$_C['DEBUG']['STAT'] = $data['core']['debug_info'] ? true : false;
		$_C['DEBUG']['PAGE_TRACE'] = $data['core']['debug_info'] ? true : false;
		/* url host prefix */
		$_C['URL']['HOST_PREFIX'] = $data['core']['host_prefix_switch'] ? true : false;
		/* rewrite */
		if(1 == $data['core']['rewrite_switch']) {
			$_C['URL']['TYPE'] = 3;
		}
		else {
			$_C['URL']['TYPE'] = 1;
		}

		$result = M('Option')->save_configFile($_C);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('EDIT_OPTION_CORE').': '.L('SAVE_CFG_FILE_FAILED'), 0);
			$this->error(L('SAVE_CFG_FILE_FAILED'), Url::U('option/edit_option_core'));
		}

		if(!M('Option')->save_option($data)) {
			M('Log')->add_log(L('EDIT_OPTION_CORE'), 0);
			$this->error(L('EDIT_FAILED'), Url::U('option/edit_option_core'));
		}
		M('Log')->add_log(L('EDIT_OPTION_CORE'));
		$this->success(L('EDIT_SUCCESS'), Url::U('option/edit_option_core'));
	}

	public function edit_option_platform() {
		$_O = M('Option')->get_option(array('platform'));
		$this->assign('_O', $_O);

		$_TL = list_dir(TPL_PATH, array('admin'));
		$this->assign('_TL', $_TL);
		$_SL = list_dir(SKIN_PATH, array('admin'));
		$this->assign('_SL', $_SL);

		$this->display('option/edit_option_platform');
	}
	public function edit_option_platform_do () {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		$cfgFile = CFG_PATH.D_S.'comm.php';
		$_C = include($cfgFile);
		/* theme */
		$_C['TE']['TPL_DETECT_USER_AGENT'] = $data['platform']['detect'] ? true : false;
		$_C['TE']['TPL_USER_AGENT_BRANCH'] = !empty($data['platform']['agent']) ? array(0 => 'desktop') + $data['platform']['agent'] : array(0 => 'desktop');
		$_t_host = array();
		foreach($_C['TE']['TPL_USER_AGENT_BRANCH'] as $agent) {
			if(empty($data['platform']['host'][$agent])) {
				$_t_host = array();
				break;
			}
			$_t_host[$agent] = $data['platform']['host'][$agent];
		}
		$_C['TE']['TPL_USER_AGENT_HOST'] = $_t_host;

		$_C['TE']['TPL_THEME'] = $data['platform']['template'];
		$_C['TE']['TPL_PROTECTION'] = $data['platform']['tpl_protection'] ? true : false;
		$_C['TE']['SKIN_STYLE'] = $data['platform']['skin'];

		$result = M('Option')->save_configFile($_C, array('TE.TPL_USER_AGENT_BRANCH' => $_C['TE']['TPL_USER_AGENT_BRANCH']));
		if(!empty($result['error'])) {
			M('Log')->add_log(L('EDIT_OPTION_PLATFORM').': '.L('SAVE_CFG_FILE_FAILED'), 0);
			$this->error(L('SAVE_CFG_FILE_FAILED'), Url::U('option/edit_option_platform'));
		}

		if(!M('Option')->save_option($data)) {
			M('Log')->add_log(L('EDIT_OPTION_PLATFORM'), 0);
			$this->error(L('EDIT_FAILED'), Url::U('option/edit_option_platform'));
		}
		M('Log')->add_log(L('EDIT_OPTION_PLATFORM'));
		$this->success(L('EDIT_SUCCESS'), Url::U('option/edit_option_platform'));
	}

	public function edit_option_language() {
		$this->assign('_LS', get_langset(false));

		$_O = M('Option')->get_option(array('language'));
		$this->assign('_O', $_O);

		$this->display('option/edit_option_language');
	}
	public function edit_option_language_do () {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		$_C = array();
		/* language */
		$_C['LANG']['NAME'] = $data['language']['default'];
		$_C['LANG']['DETECT'] = $data['language']['change'] ? true : false;
		$_C['URL']['LANG_SUFFIX'] = $data['language']['url_suffix'] ? true : false;

		/* change route */
		if($_C['URL']['LANG_SUFFIX']) {
			copy(CFG_PATH.D_S.'route_lang.php', CFG_PATH.D_S.'route.php');
		}
		else {
			copy(CFG_PATH.D_S.'route_base.php', CFG_PATH.D_S.'route.php');
		}

		$result = M('Option')->save_configFile($_C);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('EDIT_OPTION_LANGUAGE').': '.L('SAVE_CFG_FILE_FAILED'), 0);
			$this->error(L('SAVE_CFG_FILE_FAILED'), Url::U('option/edit_option_language'));
		}

		/* save langset */
		$langset = array();
		foreach($data['langset'] as $alias => $name) {
			$langset[$alias] = array(
				'name' => $name,
				'enable' => (in_array($alias, $data['language']['enable']) ? true : false),
			);
		}
		$content = "<?php\r\n".PFA_ACCESS_CHECK."return ".var_export($langset, true).";\r\n?>";
		if(!@file_put_contents(CFG_PATH.D_S.'langset.php', $content)) {
			M('AdminLog')->add_log(ASession::get('m_email'), L('EDIT_OPTION_LANGUAGE').': '.L('SAVE_LANGSET_FILE_FAILED'), 0);
			$this->error(L('SAVE_LANGSET_FILE_FAILED'), Url::U('option/edit_option_language'));
		}
		unset($data['langset']);

		if(!M('Option')->save_option($data)) {
			M('Log')->add_log(L('EDIT_OPTION_LANGUAGE'), 0);
			$this->error(L('EDIT_FAILED'), Url::U('option/edit_option_language'));
		}
		M('Log')->add_log(L('EDIT_OPTION_LANGUAGE'));
		$this->success(L('EDIT_SUCCESS'), Url::U('option/edit_option_language'));
	}

	public function edit_option_index() {
		$_O = M('Option')->get_option(array('index'));
		$this->assign('_O', $_O);

		// template list
		$_C = require (CFG_PATH.D_S.'comm.php');
		$_TPLS = list_file(C('TE.TPL_PATH').D_S.$_C['TE']['TPL_THEME'].D_S.'home');
		$this->assign('_TPLS', $_TPLS);

		$this->display('option/edit_option_index');
	}
	public function edit_option_index_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		if(!M('Option')->save_option($data)) {
			M('Log')->add_log(L('EDIT_OPTION_INDEX'), 0);
			$this->error(L('EDIT_FAILED'), Url::U('option/edit_option_index'));
		}
		M('Log')->add_log(L('EDIT_OPTION_INDEX'));
		$this->success(L('EDIT_SUCCESS'), Url::U('option/edit_option_index'));
	}

	public function edit_option_upload() {
		$_O = M('Option')->get_option(array('upload'));
		$this->assign('_O', $_O);

		$this->display('option/edit_option_upload');
	}
	public function edit_option_upload_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		if(!M('Option')->save_option($data)) {
			M('Log')->add_log(L('EDIT_OPTION_UPLOAD'), 0);
			$this->error(L('EDIT_FAILED'), Url::U('option/edit_option_upload'));
		}
		M('Log')->add_log(L('EDIT_OPTION_UPLOAD'));
		$this->success(L('EDIT_SUCCESS'), Url::U('option/edit_option_upload'));
	}

	public function edit_option_image() {
		$_O = M('Option')->get_option(array('image'));
		$this->assign('_O', $_O);

		$this->display('option/edit_option_image');
	}
	public function edit_option_image_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		if(!M('Option')->save_option($data)) {
			M('Log')->add_log(L('EDIT_OPTION_IMAGE'), 0);
			$this->error(L('EDIT_FAILED'), Url::U('option/edit_option_image'));
		}
		M('Log')->add_log(L('EDIT_OPTION_IMAGE'));
		$this->success(L('EDIT_SUCCESS'), Url::U('option/edit_option_image'));
	}

	public function edit_option_interaction() {
		$_O = M('Option')->get_option(array('interaction'));
		$this->assign('_O', $_O);

		$this->display('option/edit_option_interaction');
	}
	public function edit_option_interaction_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		if(!M('Option')->save_option($data)) {
			M('Log')->add_log(L('EDIT_OPTION_INTERACTION'), 0);
			$this->error(L('EDIT_FAILED'), Url::U('option/edit_option_interaction'));
		}
		M('Log')->add_log(L('EDIT_OPTION_INTERACTION'));
		$this->success(L('EDIT_SUCCESS'), Url::U('option/edit_option_interaction'));
	}

	public function edit_option_administrator() {
		$_O = M('Option')->get_option(array('administrator'));
		$this->assign('_O', $_O);

		$this->display('option/edit_option_administrator');
	}
	public function edit_option_administrator_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		$_O = M('Option')->get_option(array('administrator'));
		$password = md5($_O['administrator']['email'].md5($data['administrator']['password']));
		if($password != $_O['administrator']['password']) {
			M('Log')->add_log(L('EDIT_OPTION_ADMINISTRATOR'), 0);
			$this->error(L('PASSWORD_ERROR'), Url::U('option/edit_option_administrator'));
		}

		$data['administrator']['email'] = strtolower($data['administrator']['email']);
		if(!empty($data['new_password'])) {
			if($data['new_password'] != $data['new_password_repeat']) {
				M('Log')->add_log(L('EDIT_OPTION_ADMINISTRATOR'), 0);
				$this->error(L('NEW_PASSWORD_NOT_MATCH'), Url::U('option/edit_option_administrator'));
			}
			$data['administrator']['password'] = md5($data['administrator']['email'].md5($data['new_password']));
			unset($data['new_password']);
			unset($data['new_password_repeat']);
		}
		else {
			$data['administrator']['password'] = md5($data['administrator']['email'].md5($data['administrator']['password']));
		}

		if(!M('Option')->save_option($data)) {
			M('Log')->add_log(L('EDIT_OPTION_ADMINISTRATOR'), 0);
			$this->error(L('EDIT_FAILED'), Url::U('option/edit_option_administrator'));
		}
		M('Log')->add_log(L('EDIT_OPTION_ADMINISTRATOR'));
		$this->success(L('EDIT_SUCCESS'), Url::U('option/edit_option_administrator'));
	}

	/* custom option */
	public function edit_custom_option() {
		$_CO = M('Option')->get_customOptionList();
		$this->assign('_CO', $_CO);

		$this->display('option/edit_custom_option');
	}
	public function edit_custom_option_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		if(!M('Option')->save_option($data)) {
			M('Log')->add_log(L('EDIT_CUSTOM_OPTION'), 0);
			$this->error(L('EDIT_FAILED'), Url::U('option/edit_custom_option'));
		}
		M('Log')->add_log(L('EDIT_CUSTOM_OPTION'));
		$this->success(L('EDIT_SUCCESS'), Url::U('option/edit_custom_option'));
	}

	public function add_custom_option_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();

		$result = M('Option')->add_customOption($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('ADD_CUSTOM_OPTION').': '.$result['error'], 0);
			$this->error(L('ADD_FAILED'), Url::U('option/edit_custom_option'));
		}

		M('Log')->add_log(L('ADD_CUSTOM_OPTION').': OPTION_TITLE['.$data['o_title'][LANG_NAME].']');
		$this->success(L('ADD_SUCCESS'), Url::U('option/edit_custom_option'));
	}

	public function delete_custom_option_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$oKey = ARequest::get('o_key');
		$result = M('Option')->delete_customOption($oKey);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('DELETE_CUSTOM_OPTION').': KEY['.$oKey.']'.$result['error'], 0);
			$this->error(L('DELETE_FAILED'), Url::U('option/edit_custom_option'));
		}

		M('Log')->add_log(L('DELETE_CUSTOM_OPTION').': KEY['.$oKey.']');
		$this->success(L('DELETE_SUCCESS'), Url::U('option/edit_custom_option'));
	}

	public function sort_custom_option_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get('sort');
		$result = M('Option')->sort_customOption($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('SORT_CUSTOM_OPTION').': '.$result['error'], 0);
			$this->error($result['error'], Url::U('option/edit_custom_option'));
		}

		M('Log')->add_log(L('SORT_CUSTOM_OPTION'));
		$this->success(L('SORT_SUCCESS'), Url::U('option/edit_custom_option'));
	}


}

?>