<?php

/**
 *--------------------------------------
 * subscribe
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-08-26
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class SubscribeCtrlr extends ManageCtrlr {
	public function edit_option() {
		$this->assign('_O', EO('subscribe'));

		$this->display('subscribe/edit_option');
	}
	public function edit_option_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();
		unset($data['timeKey']);
		unset($data['token']);

		if(!edit_extensionOption('subscribe', $data)) {
			M('Log')->add_log(L('EDIT_SUBSCRIBE_OPTION').': '.L('SAVE_CFG_FILE_FAILED'), 0);
			$this->error(L('SAVE_CFG_FILE_FAILED'), Url::U('subscribe/edit_option'));
		}
		M('Log')->add_log(L('EDIT_SUBSCRIBE_OPTION'));
		$this->success(L('EDIT_SUCCESS'), Url::U('subscribe/edit_option'));
	}

	public function list_subscribe() {
		$where = array();
		/* filter status */
		$sStatus = ARequest::get('s_status') ? ARequest::get('s_status') : '';
		if('c' == $sStatus) {
			$where['__SUBSCRIBE__.s_status'] = array('EQ', 0);
		}
		elseif('n' == $sStatus) {
			$where['__SUBSCRIBE__.s_status'] = array('EQ', 1);
		}

		/* get paging and list */
		$_PG = '';
		$_SL = '';
		$rowsNum = M('Subscribe')->where($where)->count();
		if(0 < $rowsNum) {
			$orderBy = ARequest::get('order_by') ? ARequest::get('order_by') : 'subscribe_id';
			$orderTurn = ARequest::get('order_turn') ? ARequest::get('order_turn') : 'desc';
			$pageSize = (ARequest::get('page_size') > 0 ? ARequest::get('page_size') : 20);
			$p = new APage($rowsNum, $pageSize, Url::U('subscribe/list_subscribe?s_status='.$sStatus.'&order_by='.$orderBy.'&order_turn='.$orderTurn.'&page_size='.$pageSize.'&'.C('VAR.PAGE').'=_page_'));
			$_PG = $p->get_paging();

			$_SL = M('Subscribe')->get_subscribeList($where, "`{$orderBy}` {$orderTurn}", $p->get_limit(), false);
		}
		$this->assign('_PG', $_PG);
		$this->assign('_SL', $_SL);

		$this->display('subscribe/list_subscribe');
	}

	public function delete_subscribe_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$subscribeId = ARequest::get('subscribe_id');
		$subscribeId = is_array($subscribeId) ? $subscribeId : explode(',', $subscribeId);
		$_L_ID = implode(', ', $subscribeId);

		foreach($subscribeId as $subscribeId) {
			$result = M('Subscribe')->delete_subscribe($subscribeId);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('DELETE_SUBSCRIBE').': ID['.$subscribeId.']'.$result['error'], 0);
				$this->error($result['error'], Url::U('subscribe/list_subscribe'));
			}
		}

		M('Log')->add_log(L('DELETE_SUBSCRIBE').': ID['.$_L_ID.']');
		$this->success(L('DELETE_SUCCESS'), Url::U('subscribe/list_subscribe'));
	}

	public function download_subscribe() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$where = array();
		/* filter status */
		$sStatus = ARequest::get('s_status') ? ARequest::get('s_status') : '';
		if('n' == $sStatus) {
			$where['__SUBSCRIBE__.s_status'] = array('EQ', 0);
		}
		elseif('p' == $sStatus) {
			$where['__SUBSCRIBE__.s_status'] = array('EQ', 1);
		}

		/* get paging and list */
		$_PG = '';
		$_SL = '';
		$rowsNum = M('Subscribe')->where($where)->count();
		if(0 < $rowsNum) {
			$orderBy = ARequest::get('order_by') ? ARequest::get('order_by') : 'subscribe_id';
			$orderTurn = ARequest::get('order_turn') ? ARequest::get('order_turn') : 'desc';
			$pageSize = (ARequest::get('page_size') > 0 ? ARequest::get('page_size') : 20);
			$p = new APage($rowsNum, $pageSize, Url::U('subscribe/download_subscribe?s_status='.$sStatus.'&order_by='.$orderBy.'&order_turn='.$orderTurn.'&page_size='.$pageSize.'&'.C('VAR.PAGE').'=_page_'));
			$_PG = $p->get_paging();

			$_SL = M('Subscribe')->get_subscribeList($where, "`{$orderBy}` {$orderTurn}", $p->get_limit(), false);
		}
		$this->assign('_PG', $_PG);
		$this->assign('_SL', $_SL);

		if(!empty($_SL)) {
			M('Log')->add_log(L('DOWNLOAD_SUBSCRIBE'));
			header('Cache-Control: no-cache, must-revalidate');
			header("Content-type:application/vnd.ms-excel");
			header("Content-Disposition:filename=log_".$lang.'_'.date('YmdHi', NOW_TIME).".xls");

			$this->assign('_SL', $_SL);
			$data = $this->fetch('subscribe/download_subscribe');
			echo ($data);
			exit;
		}
		else {
			M('Log')->add_log(L('DOWNLOAD_SUBSCRIBE').': '.L('EMPTY'), 0);
			$this->error(L('EMPTY'), Url::U('subscribe/list_subscribe'));
		}
	}
}

?>