<?php

/**
 *--------------------------------------
 * common
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-10
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class CommonCtrlr extends IndexCtrlr {
	public function _captcha_img() {
		C('DEBUG.STAT', false);
		C('DEBUG.PAGE_TRACE', false);

		$name = in_array(ARequest::get('name'), array('vcode', 'test')) ? ARequest::get('name', 'get') : 'vcode';

		$fonts = array(
			'spacing' => 2,
			'size' => 16,
			'font' => RES_PATH.D_S.'font/font.ttf');
		$ac = new ACaptcha(90, 30, 5, $fonts);
		ASession::set($name, strtolower($ac->text));
		$ac->create_image();
	}

	public function _toggle_ua() {
		C('DEBUG.STAT', false);
		C('DEBUG.PAGE_TRACE', false);

		$ua = strtolower(ARequest::get(C('VAR.USER_AGENT')));

		/* ua invalid */
		$tuab = C('TE.TPL_USER_AGENT_BRANCH');
		if(empty($ua) or !preg_match('/^[A-Za-z_0-9]+$/', $ua) or !in_array($ua, $tuab)) {
			if(IS_AJAX) {
				$this->ajax_return(array('data' => 0));
			}
			redirect(AServer::get_preUrl());
		}

		ACookie::set('user_agent', $ua);

		/* get url */
		$gcap = gcap(ARequest::get('gcap'), false);
		if(empty($gcap)) {
			$gcap = 'home@index/index';
		}
		else {
			$gcap = parse_gcapName($gcap);
		}
		$gcap = set_urlParams($gcap, array(C('VAR.USER_AGENT') => $ua));
		$url = 'desktop' == $ua ? get_url($gcap) : get_url($gcap, true);
		$url = empty($url) ? Url::U('home@index/index') : $url;

		$tuah = C('TE.TPL_USER_AGENT_HOST');
		if(!empty($tuah) and array_key_exists($ua, $tuah)) {
			$url = $tuah[$ua].(C('URL.HOST_PREFIX') ? substr($url, strlen(__HOST__)) : $url);
		}
		$url = set_urlParams($url, array(C('VAR.USER_AGENT') => ''));

		if(IS_AJAX) {
			$this->ajax_return(array('data' => 1));
		}
		redirect($url);
	}

	public function _toggle_lang() {
		C('DEBUG.STAT', false);
		C('DEBUG.PAGE_TRACE', false);

		$lang = strtolower(ARequest::get(C('VAR.LANG')));

		/* lang invalid */
		$langset = get_langset();
		if(empty($lang) or !array_key_exists($lang, $langset)) {
			if(IS_AJAX) {
				$this->ajax_return(array('data' => 0));
			}
			redirect(AServer::get_preUrl());
		}

		ACookie::set('lang', $lang);

		/* get url */
		$langGcap = array(
			'home@article/show_category',
			'home@article/show_article',
			'home@single_page/show_single_page'
		);
		$gcap = gcap(ARequest::get('gcap'), false);
		if(empty($gcap)) {
			$gcap = 'home@index/index';
		}
		else {
			$gcap = parse_gcapName($gcap);
			foreach($langGcap as $_lg) {
				if(false !== strpos($gcap, $_lg)) {
					$gcap = 'home@index/index';
					break;
				}
			}
		}
		$gcap = set_urlParams($gcap, array(C('VAR.LANG') => $lang));
		$url = 'desktop' == USER_AGENT ? get_url($gcap) : get_url($gcap, true);
		$url = empty($url) ? Url::U('home@index/index') : $url;

		/* deal lang param in url */
		if(C('URL.LANG_SUFFIX')) {
			$url = set_urlParams($url, array(C('VAR.LANG') => $lang));
		}
		else {
			$url = set_urlParams($url, array(C('VAR.LANG') => ''));
		}

		if(IS_AJAX) {
			$this->ajax_return(array('data' => 1));
		}
		redirect($url);
	}

}

?>