<?php

/**
 *--------------------------------------
 * ad
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-06
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class AdModl extends Modl {
	public function get_adList($asAlias = '', $timeLimit = false) {
		$where = array();
		if(!empty($asAlias)) {
			$where['__AD__.as_alias'] = array('EQ', $asAlias);
		}
		$where['__AD__.lang'] = array('EQ', LANG_NAME);
		$_AL = $this->order('`as`.as_alias ASC, a_display_order ASC')->join('__AD_SPACE__ AS `as` ON `as`.as_alias = __AD__.as_alias')->where($where)->select();
		if(!empty($_AL)) {
			foreach($_AL as $k => $ad) {
				if($timeLimit and (NOW_TIME < $ad['a_start_time'] or NOW_TIME > $ad['a_end_time']) and 1 == $ad['a_time_limit']) {
					unset($_AL[$k]);
					continue;
				}
				$_AL[$k]['as_name'] = unserialize($ad['as_name']);
				$_AL[$k]['as_default'] = unserialize($ad['as_default']);
				if(MAGIC_QUOTES_GPC) {
					$_AL[$k]['as_name'] = stripslashes_array($_AL[$k]['as_name']);
					$_AL[$k]['as_default'] = stripslashes_array($_AL[$k]['as_default']);
				}
				$_AL[$k]['as_name'] = get_itemL($_AL[$k]['as_name']);
				$_AL[$k]['as_default'] = get_itemL($_AL[$k]['as_default']);
			}
		}
		return $_AL;
	}

	public function get_adInfo($adId) {
		$where = array();
		$where['ad_id'] = array('EQ', $adId);
		$where['lang'] = array('EQ', LANG_NAME);

		$_AI = $this->join('__AD_SPACE__ AS `as` ON `as`.as_alias = __AD__.as_alias')->where($where)->find();
		if(!empty($_AI)) {
			$_AI['as_name'] = unserialize($_AI['as_name']);
			$_AI['as_default'] = unserialize($_AI['as_default']);
			if(MAGIC_QUOTES_GPC) {
				$_AI['as_name'] = stripslashes_array($_AI['as_name']);
				$_AI['as_default'] = stripslashes_array($_AI['as_default']);
			}
			$_AI['as_name'] = get_itemL($_AI['as_name']);
			$_AI['as_default'] = get_itemL($_AI['as_default']);
		}
		return $_AI;
	}

	public function add_ad($data) {
		$result = array('data' => '', 'error' => '');

		$data['a_start_time'] = strtotime($data['a_start_time']);
		$data['a_end_time'] = strtotime($data['a_end_time']);

		$data['lang'] = LANG_NAME;
		unset($data['ad_id']);
		$_t_id = $this->insert($data);
		if(false === $_t_id) {
			$result['error'] = L('ADD_FAILED');
			return $result;
		}
		$result['data'] = $_t_id;

		return $result;
	}

	public function edit_ad($data) {
		$result = array('data' => '', 'error' => '');

		if(isset($data['a_start_time'])) {
			$data['a_start_time'] = strtotime($data['a_start_time']);
		}
		if(isset($data['a_end_time'])) {
			$data['a_end_time'] = strtotime($data['a_end_time']);
		}

		if(false === $this->update($data)) {
			$result['error'] = L('EDIT_FAILED');
			return $result;
		}

		return $result;
	}

	public function delete_ad($adId) {
		$result = array('data' => '', 'error' => '');

		$_AI = $this->where(array('ad_id' => array('EQ', $adId)))->find();
		if(empty($_AI)) {
			$result['error'] = L('ITEM_INEXISTENCE');
			return $result;
		}

		if(false === $this->delete($adId)) {
			$result['error'] = L('DELETE_FAILED');
			return $result;
		}

		return $result;
	}
}

?>