<?php

/**
 *--------------------------------------
 * flink category
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-08-20
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class FlinkCategoryModl extends Modl {
	public function get_categoryList($lang = true) {
		$_FCL = F('_fcl/'.LANG_NAME.'_'.($lang ? 1 : 0));
		if(empty($_FCL)) {
			$_FCL = $this->order('`fc_display_order` ASC')->select();
			if(!empty($_FCL)) {
				foreach($_FCL as $k => $fc) {
					$_FCL[$k]['fc_name'] = unserialize($fc['fc_name']);
					if(MAGIC_QUOTES_GPC) {
						$_FCL[$k]['fc_name'] = stripslashes_array($_FCL[$k]['fc_name']);
					}
					if($lang) {
						$_FCL[$k]['fc_name'] = get_itemL($_FCL[$k]['fc_name']);
					}
				}
			}
			F('_fcl/'.LANG_NAME.'_'.($lang ? 1 : 0), $_FCL);
		}
		return $_FCL;
	}

	public function get_categoryInfo($fcAlias, $lang = true) {
		$_FCI = F('_fci/'.$fcAlias.LANG_NAME.'_'.($lang ? 1 : 0));
		if(empty($_FCI)) {
			$_FCI = $this->where(array('fc_alias' => array('EQ', $fcAlias)))->find();
			if(!empty($_FCI)) {
				$_FCI['fc_name'] = unserialize($_FCI['fc_name']);
				if(MAGIC_QUOTES_GPC) {
					$_FCI['fc_name'] = stripslashes_array($_FCI['fc_name']);
				}
				if($lang) {
					$_FCI['fc_name'] = get_itemL($_FCI['fc_name']);
				}
			}
			F('_fci/'.$fcAlias.LANG_NAME.'_'.($lang ? 1 : 0), $_FCI);
		}

		return $_FCI;
	}

	public function add_category($data) {
		$result = array('data' => '', 'error' => '');

		$data['fc_alias'] = strtolower($data['fc_alias']);
		$data['fc_name'] = serialize($data['fc_name']);
		if(MAGIC_QUOTES_GPC) {
			$data['fc_name'] = addslashes($data['fc_name']);
		}

		$_t_id = $this->insert($data);
		if(false === $_t_id) {
			$result['error'] = L('ADD_FAILED');
			return $result;
		}
		$result['data'] = $data['fc_alias'];

		clear_dir(DATA_PATH.D_S.'_fcl');

		return $result;
	}

	public function edit_category($data) {
		$result = array('data' => '', 'error' => '');

		$data['fc_alias'] = strtolower($data['fc_alias']);
		if(isset($data['fc_name'])) {
			$data['fc_name'] = serialize($data['fc_name']);
			if(MAGIC_QUOTES_GPC) {
				$data['fc_name'] = addslashes($data['fc_name']);
			}
		}

		if(false === $this->update($data)) {
			$result['error'] = L('EDIT_FAILED');
			return $result;
		}

		clear_dir(DATA_PATH.D_S.'_fcl');
		clear_dir(DATA_PATH.D_S.'_fci');

		return $result;
	}

	public function delete_category($fcAlias) {
		$result = array('data' => '', 'error' => '');

		if(false === $this->delete($fcAlias)) {
			$result['error'] = L('DELETE_FAILED');
			return $result;
		}

		/* delete flink */
		$flinkId = M('Flink')->field('flink_id')->where(array('fc_alias' => array('EQ', $fcAlias)))->select();
		if(!empty($flinkId)) {
			foreach($flinkId as $flinkId) {
				M('Flink')->delete_flink($flinkId['flink_id']);
			}
		}

		clear_dir(DATA_PATH.D_S.'_fcl');
		clear_dir(DATA_PATH.D_S.'_fci');

		return $result;
	}
}

?>