<?php

/**
 *--------------------------------------
 * guestbook
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-07
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class GuestbookModl extends Modl {
	public function get_guestbookList($where = array(), $order = '', $limit = 10, $filter = true) {
		$_GL = $this->where($where)->order($order)->limit($limit)->select();
		if(!empty($_GL) and $filter) {
			foreach($_GL as $k => $v) {
				if(2 == $v['g_status']) {
					$_GL[$k]['g_author'] = M('Report')->filter_content($v['g_author']);
					$_GL[$k]['g_content'] = M('Report')->filter_content($v['g_content']);
				}
			}
		}
		return $_GL;
	}

	public function get_guestbookInfo($guestbookId, $parseBR = false) {
		$_GI = $this->where(array('guestbook_id' => array('EQ', $guestbookId)))->find();
		if($parseBR and !empty($_GI)) {
			$_GI['g_content'] = str_replace("<br />", "\r\n", $_GI['g_content']);
			$_GI['g_reply'] = str_replace("<br />", "\r\n", $_GI['g_reply']);
		}
		return $_GI;
	}

	public function pass_guestbook($guestbookId) {
		$result = array('data' => '', 'error' => '');

		if(false === $this->where(array('guestbook_id' => array('EQ', $guestbookId)))->set_field('g_status', 1)) {
			$result['error'] = L('PASS_FAILED');
			return $result;
		}

		return $result;
	}

	public function add_guestbook($data) {
		$result = array('data' => '', 'error' => '');

		unset($data['guestbook_id']);
		$_t_id = $this->insert($data);
		if(false === $_t_id) {
			$result['error'] = L('ADD_FAILED');
			return $result;
		}
		$result['data'] = $_t_id;

		return $result;
	}

	public function edit_guestbook($data) {
		$result = array('data' => '', 'error' => '');

		if(false === $this->update($data)) {
			$result['error'] = L('UPDATE_FAILED');
			return $result;
		}

		return $result;
	}

	public function delete_guestbook($guestbookId) {
		$result = array('data' => '', 'error' => '');

		if(false === $this->delete($guestbookId)) {
			$result['error'] = L('DELETE_FAILED');
			return $result;
		}

		return $result;
	}

	public function delete_sameIp($guestbookId) {
		$result = array('data' => '', 'error' => '');

		$_GI = $this->get_guestbookInfo($guestbookId);
		if(empty($_GI)) {
			return $result;
		}

		if(false === $this->where(array('g_add_ip' => array('EQ', $_GI['g_add_ip'])))->delete()) {
			$result['error'] = L('DELETE_FAILED');
			return $result;
		}

		return $result;
	}

	public function get_guestbookNo() {
		return date('ymd-His-', NOW_TIME).mt_rand(100, 999);
	}

}

?>