<?php

/**
 *--------------------------------------
 * menu space
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-05
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class MenuSpaceModl extends Modl {
	public function get_spaceList($lang = true) {
		$_MSL = F('_msl/'.LANG_NAME.'_'.($lang ? 1 : 0));
		if(empty($_MSL)) {
			$_MSL = $this->order('`ms_alias` ASC')->select();
			foreach($_MSL as $k => $ms) {
				$_MSL[$k]['ms_name'] = unserialize($ms['ms_name']);
				$_MSL[$k]['ms_description'] = unserialize($ms['ms_description']);
				if(MAGIC_QUOTES_GPC) {
					$_MSL[$k]['ms_name'] = stripslashes_array($_MSL[$k]['ms_name']);
					$_MSL[$k]['ms_description'] = stripslashes_array($_MSL[$k]['ms_description']);
				}
				if($lang) {
					$_MSL[$k]['ms_name'] = get_itemL($_MSL[$k]['ms_name']);
					$_MSL[$k]['ms_description'] = get_itemL($_MSL[$k]['ms_description']);
				}
			}
			F('_msl/'.LANG_NAME.'_'.($lang ? 1 : 0), $_MSL);
		}
		return $_MSL;
	}

	public function get_spaceInfo($msAlias, $lang = true) {
		$_MSI = F('_msi/'.$msAlias.LANG_NAME.'_'.($lang ? 1 : 0));
		if(empty($_MSI)) {
			$_MSI = $this->where(array('ms_alias' => array('EQ', $msAlias)))->find();
			if(!empty($_MSI)) {
				$_MSI['ms_name'] = unserialize($_MSI['ms_name']);
				$_MSI['ms_description'] = unserialize($_MSI['ms_description']);
				if(MAGIC_QUOTES_GPC) {
					$_MSI['ms_name'] = stripslashes_array($_MSI['ms_name']);
					$_MSI['ms_description'] = stripslashes_array($_MSI['ms_description']);
				}
				if($lang) {
					$_MSI['ms_name'] = get_itemL($_MSI['ms_name']);
					$_MSI['ms_description'] = get_itemL($_MSI['ms_description']);
				}
			}
			F('_msi/'.$msAlias.LANG_NAME.'_'.($lang ? 1 : 0), $_MSI);
		}
		return $_MSI;
	}

	public function add_space($data) {
		$result = array('data' => '', 'error' => '');

		$data['ms_alias'] = strtolower($data['ms_alias']);
		$data['ms_name'] = serialize($data['ms_name']);
		$data['ms_description'] = serialize($data['ms_description']);
		if(MAGIC_QUOTES_GPC) {
			$data['ms_name'] = addslashes($data['ms_name']);
			$data['ms_description'] = addslashes($data['ms_description']);
		}

		$_t_id = $this->insert($data);
		if(false === $_t_id) {
			$result['error'] = L('ADD_FAILED');
			return $result;
		}
		$result['data'] = $data['ms_alias'];

		clear_dir(DATA_PATH.D_S.'_msl');

		return $result;
	}

	public function edit_space($data) {
		$result = array('data' => '', 'error' => '');

		$data['ms_alias'] = strtolower($data['ms_alias']);
		$_MSI = $this->get_spaceInfo($data['ms_alias']);
		if(empty($_MSI)) {
			$result['error'] = L('ITEM_INEXISTENCE');
			return $result;
		}

		if(isset($data['ms_name'])) {
			$data['ms_name'] = serialize($data['ms_name']);
			if(MAGIC_QUOTES_GPC) {
				$data['ms_name'] = addslashes($data['ms_name']);
			}
		}
		if(isset($data['ms_description'])) {
			$data['ms_description'] = serialize($data['ms_description']);
			if(MAGIC_QUOTES_GPC) {
				$data['ms_description'] = addslashes($data['ms_description']);
			}
		}

		if(false === $this->update($data)) {
			$result['error'] = L('EDIT_FAILED');
			return $result;
		}

		clear_dir(DATA_PATH.D_S.'_msl');
		clear_dir(DATA_PATH.D_S.'_msi');

		return $result;
	}

	public function delete_space($msAlias) {
		$result = array('data' => '', 'error' => '');

		$_MSI = $this->get_spaceInfo($msAlias);
		if(empty($_MSI)) {
			$result['error'] = L('ITEM_INEXISTENCE');
			return $result;
		}

		if(false === $this->delete($msAlias)) {
			$result['error'] = L('DELETE_FAILED');
			return $result;
		}

		/* delete Menu */
		$menuId = M('Menu')->field('menu_id')->where(array('ms_alias' => array('EQ', $_MSI['ms_alias'])))->select();
		if(!empty($menuId)) {
			foreach($menuId as $menuId) {
				M('Menu')->delete_menu($menuId['menu_id'], false);
			}
		}

		clear_dir(DATA_PATH.D_S.'_msl');
		clear_dir(DATA_PATH.D_S.'_msi');

		return $result;
	}

}

?>