<!doctype html>
<html dir="{-:*_LD_-}">
<head>
<meta charset="utf-8" />
<title>{-:@MANAGE-}</title>
{-include:meta-}
<script>
var GV = {
	_LD_ : '{-:*_LD_-}',
	LANG_NAME : '{-:*LANG_NAME-}',
	URL : {
		GET_ACTN_LIST : '{-url:admin@common/_get_actn_list-}'+'&'+Math.random()
	}
};
</script>
</head>
<body>

<div class="container margin" data-waterfall="{column:2}">
	{-if:!empty($_SST)-}
	<div class="alert alert-danger">
		<h3>{-:@SITE_SAFE_TIP-}</h3>
		<ol>{-foreach:$_SST,$sst-}
			<li>{-:$sst-}</li>
		{-:/foreach-}</ol>
	</div>
	{-:/if-}
	<div class="panel">
		<div class="panel-heading">{-:@SHORTCUT-}<span class="panel-control pointer" id="manage_shortcut">{-:@MANAGE-}</span></div>
		<div class="panel-body">
			<ul class="list-inline">
				{-foreach:$_SL,$s-}<li>
					<a href="{-:$s['shortcut_url']|get_url-}">{-:$s['shortcut_title']-}</a>
				</li>{-:/foreach-}
			</ul>
		</div>
	</div>
	<div class="panel">
		<div class="panel-heading">{-:@SITE_STAT-}</div>
		<div class="panel-body">
			<ul class="list-inline">
				<li>
					<a href="{-url:admin@article/list_article-}">{-:@ARTICLE-}:</a>
					<span class="text-muted"><b class="text-success">{-:$_CS['article']['all']-}</b></span>
				</li>
				<li>
					<a href="{-url:admin@article_review/list_review-}">{-:@REVIEW-}:</a>
					<span class="text-muted"><b class="text-success">{-:$_CS['article_review']['all']-}</b>
					{-if:0<$_CS['article_review']['not_passed']-}| <b class="text-danger">{-:$_CS['article_review']['not_passed']-} {-:@NOT_PASSED-}</b>{-:/if-}</span>
				</li>
				<li>
					<a href="{-url:admin@single_page/list_single_page-}">{-:@SINGLE_PAGE-}:</a>
					<span class="text-muted"><b class="text-success">{-:$_CS['single_page']['all']-}</b></span>
				</li>
				<li>
					<a href="{-url:admin@flink/list_flink-}">{-:@FLINK-}:</a>
					<span class="text-muted"><b class="text-success">{-:$_CS['flink']['all']-}</b>
					{-if:0<$_CS['flink']['not_passed']-}| <b class="text-danger">{-:$_CS['flink']['not_passed']-} {-:@NOT_PASSED-}</b>{-:/if-}</span>
				</li>
				<li>
					<a href="{-url:admin@guestbook/list_guestbook-}">{-:@GUESTBOOK-}:</a>
					<span class="text-muted"><b class="text-success">{-:$_CS['guestbook']['all']-}</b>
					{-if:0<$_CS['guestbook']['not_passed']-}| <b class="text-danger">{-:$_CS['guestbook']['not_passed']-} {-:@NOT_PASSED-}</b>{-:/if-}</span>
				</li>
			</ul>
		</div>
	</div>
	<div class="panel">
		<div class="panel-heading">{-:@LATEST_ARTICLE-}<span class="panel-control"><a href="{-url:admin@article/list_article-}">{-:@MORE-}</a></span></div>
		<table class="table table-hover margin-remove">
			<tr>
				<th scope="col">{-:@TITLE-}</th>
				<th scope="col">{-:@OPERATION-}</th>
			</tr>
		<loga:a_list row="5" titlelen="48" orderby="a_edit_time" order="desc" as="a" expire="60">
			<tr>
				<td><a href="{-url:admin@article/edit_article?article_id={$a['article_id']}-}">{-:$a['a_title']-}</a></td>
				<td><a target="_blank" class="text-muted" href="{-:$a['a_url']-}">{-:@PREVIEW-}</a></td>
			</tr>
		</loga:a_list>
		</table>
	</div>
	<div class="panel">
		<div class="panel-heading">{-:@LATEST_LOG-}<span class="panel-control"><a href="{-url:admin@log/list_log-}">{-:@MORE-}</a></span></div>
		<table class="table table-hover margin-remove">
			<tr>
				<th scope="col">{-:@OPERATION-}</th>
				<th scope="col">{-:@STATUS-}</th>
				<th scope="col">{-:@TIME-}</th>
			</tr>
			{-foreach:$_LMLL,$al-}
			<tr>
				<td>{-:$al['l_operation']|AString::msubstr~18-}</td>
				<td>
				{-if:1 == $al['l_status']-}
					<span class="text-success">{-:@SUCCESS-}</span>
				{-else:-}
					<span class="text-danger">{-:@FAILED-}</span>
				{-:/if-}
				</td>
				<td>{-:$al['l_time']|date~C('APP.TIME_FORMAT'),@me-}</td>
			</tr>
			{-:/foreach-}
		</table>
	</div>
</div>

<div id="form_manage_shortcut" style="display:none">
<form id="formManage" action="{-url:admin@index/manage_shortcut_do-}" method="post">
	<table class="table table-hover table-condensed">
		<tr>
			<td>
				<table id="shortcut_set" class="table shortcut_set_root">
					<tbody class="shortcut_set">
						<tr>
							<th></th>
							<th>{-:@TITLE-}</th>
							<th>{-:@ALIAS-}</th>
							<th>{-:@URL-}</th>
							<th>{-:@MANAGE-}</th>
						</tr>
						<tr>
							<td></td>
							<td><input type="text" id="shortcut_title" value="" class="control-input input-sm" maxlength="96" size="12"></td>
							<td><input type="text" id="shortcut_alias" value="default" class="control-input input-sm" maxlength="255" size="20"></td>
							<td>
								<select class="get_actn_list control-input input-inline input-sm" id="ctrlr">
									<option selected="selected" value="">{-:@CONTROLLER-}</option>
								{-foreach:$_CL,$c-}
									<option value="{-:$c['ctrlr']-}">{-:$c['name']-}</option>
								{-:/foreach-}
								</select>
								/
								<select class="control-input input-inline input-sm" id="actn"></select>
							</td>
							<td>
								<span class="btn btn-sm create_shortcut">{-:@ADD-}</span>
							</td>
						</tr>
					{-foreach:$_SL,$k,$s-}
						<tr class="shortcut_item" k="{-:$k-}">
							<td class="shortcut_handle tree-sortable-handle"><i class="icon-bars"></i></td>
							<td><input type="text" name="shortcut_set[{-:$k-}][shortcut_title]" value="{-:$s['shortcut_title']-}" validate="/\S+/" class="control-input input-sm" maxlength="96" size="12"></td>
							<td><input type="text" name="shortcut_set[{-:$k-}][shortcut_alias]" value="{-:$s['shortcut_alias']-}" validate="/\S+/" class="control-input input-sm" maxlength="255" size="20"></td>
							<td><input type="text" name="shortcut_set[{-:$k-}][shortcut_url]" value="{-:$s['shortcut_url']-}" validate="/\S+/" class="control-input input-sm" maxlength="255" size="40"></td>
							<td><span class="btn btn-sm delete_shortcut">{-:@DELETE-}</span></td>
						</tr>
					{-:/foreach-}
					</tbody>
				</table>
				<input name="timeKey" type="hidden" value="{-:$_TK['timeKey']-}">
				<input name="token" type="hidden" value="{-:$_TK['token']-}">
			</td>
		</tr>
		<tfoot>
			<tr>
				<td>{-:@MANAGE_SHORTCUT_TIP-}</td>
			</tr>
		</tfoot>
	</table>
</form>
</div>
<script src="{-:*__RES__-}js/loga.js"></script>
<script src="{-:*__RES__-}js/jquery.js"></script>
<script src="{-:*__RES__-}fea/js/fea.min.js"></script>
<script src="{-:*__STYLE__-}js/common.js"></script>
<script src="{-:*__STYLE__-}js/admin.js"></script>
<script src="{-:*__STYLE__-}js/show_dashboard.js"></script>
</body>
</html>