<!doctype html>
<html dir="{-:*_LD_-}">
<head>
<meta charset="utf-8" />
<title>{-:$_V['a_title']-} {-:@REVIEW_LIST-} - {-:$_SITE['name']-}</title>
<meta name="keywords" content="{-:$_SITE['keywords']-}" />
<meta name="description" content="{-:$_V['a_title']-}{-:@REVIEW_LIST-}" />
{-include:clip/meta-}
<script>
var GV = {
	_LD_ : '{-:*_LD_-}',
	LANG_NAME : '{-:*LANG_NAME-}',
	URL : {
		VCODE: '{-url:home@common/_captcha_img?name=vcode-}',
		REVIEW_SUPPORT : '{-url:home@article_review/_get_count?type=do_support-}',
		REVIEW_OPPOSE : '{-url:home@article_review/_get_count?type=do_oppose-}'
	}
};
</script>
</head>
<body>
{-include:clip/header-}

{-include:clip/current_position-}
<ul class="subnav subnav-pill margin">
	<li{-if:'support'==ARequest::get('sort')-} class="active"{-:/if-}><a href="{-url:home@article_review/list_review?article_id={$_V['article_id']}&sort=support-}">{-:@MOST_SUPPORT-}</a></li>
	<li{-if:'oppose'==ARequest::get('sort')-} class="active"{-:/if-}><a href="{-url:home@article_review/list_review?article_id={$_V['article_id']}&sort=oppose-}">{-:@MOST_OPPOSE-}</a></li>
	<li{-if:'time'==ARequest::get('sort')-} class="active"{-:/if-}><a href="{-url:home@article_review/list_review?article_id={$_V['article_id']}&sort=time-}">{-:@LATEST_PUBLISHED-}</a></li>
</ul>
<div class="panel panel-info">
	<div class="panel-heading"><i class="icon-comments"></i> {-:@REVIEW_LIST-} <span class="panel-control"><a href="{-url:home@article/show_article?article_id={$_V['article_id']}-}">{-:@BACKTO-}</a> <i class="icon-reply"></i></a></span></div>
	<div class="panel-body">
	{-if:empty($_L)-}
		<div class="placeholder placeholder-lg text-center">{-:@LIST_EMPTY-}</div>
	{-else:-}
		<ul id="reviewList" class="list-unstyled list-line">
		{-foreach:$_L,$item-}
			<li>
				<div class="article">
					<div class="article-meta">
						<span id="author-{-:$item['article_review_id']-}"><i class="icon-user"></i> {-if:empty($item['ar_author'])-}{-:@GUEST-}{-else:-}{-:$item['ar_author']-}{-:/if-} [{-:$item['ar_add_ip']|hide_ip-}]</span>
						<span><i class="icon-clock"></i> {-:$item['ar_add_time']|date~C('APP.TIME_FORMAT'),@me-}</span>
						<span class="btn-group">
							<span class="review_support btn btn-sm" article_review_id="{-:$item['article_review_id']-}"><i class="icon-thumb-up-o"></i> <span class="badge">{-:$item['ar_support_count']-}</span></span>
							<span class="review_oppose btn btn-sm" article_review_id="{-:$item['article_review_id']-}"><span class="badge">{-:$item['ar_oppose_count']-}</span> <i class="icon-thumb-down-o icon-flip-horizontal"></i></span>
							{-if:empty($_V['error'])-}<span class="review_reply btn btn-sm" article_review_id="{-:$item['article_review_id']-}"><i class="icon-reply"></i> {-:@REPLY-}</span>{-:/if-}
						</span>
					</div>
					<div>
					{-if:$item['ar_qoute']-}
						<blockquote>{-:$item['ar_qoute']-}</blockquote>
					{-:/if-}
					{-:$item['ar_content']-}
					</div>
				</div><!--/.review_main-->
			</li>
		{-:/foreach-}
		</ul>
		<!--next page-->
		{-if:!empty($_PG['nextPage']['url'])-}
			<span id="viewMore" to="#reviewList" nextpage="{-:$_PG['nextPage']['url']-}" class="btn btn-block">{-:@VIEW_MORE-} <i class="icon-angle-double-down"></i></span>
		{-:/if-}
	{-:/if-}
	</div>
</div>
<div class="panel panel-success">
	<div class="panel-heading"><i class="icon-pencil-b"></i> {-:@ADD_REVIEW-}</div>
	<div class="panel-body">
	{-if:!empty($_V['error'])-}
		<div class="alert alert-warning">
			{-if:404==$_V['error']-}
				{-:@REVIEW_IS_OFF-}
			{-:/if-}
		</div>
	{-else:-}
		<form id="fromAddReview" class="form" action="{-url:home@article_review/add_review_do-}" method="post">
			<blockquote id="replyTip" class="margin-top-remove margin-bottom-remove" style="display:none"></blockquote>
			<fieldset>
				<div class="form-group">
					<label class="control-label">{-:@AUTHOR-}</label>
					<input required type="text" class="control-input" name="ar_author" placeholder="{-:@AUTHOR-}" maxlength="32" value="{-:+author-}">
				</div>
				<div class="form-group">
					<label class="control-label">{-:@CONTENT-}</label>
					<textarea id="ar_content" required class="control-input" style="height:70px;" name="ar_content" placeholder="{-:@REVIEW_CONTENT_TIP-}"></textarea>
				</div>
			</fieldset>
			{-if:$_G['interaction']['captcha']-}<div class="margin-bottom">
				<div class="row">
					<div class="width-sm-3-1"><input id="vcodeInput" required="required" type="text" placeholder="{-:@CAPTCHA-}" name="vcode" autocomplete="off" value="" class="control-input" size="5" maxlength="5"></div>
					<div class="width-sm-3-2 text-muted"><span id="vcodeImg"></span> {-:@CAPTCHA_TIP-}</div>
				</div>
			</div>{-:/if-}
			<input name="article_id" type="hidden" value="{-:$_V['article_id']-}">
			<input name="ar_qoute_id" type="hidden" value="0">
			<input name="timeKey" type="hidden" value="{-:$_TK['timeKey']-}">
			<input name="token" type="hidden" value="{-:$_TK['token']-}">
			<input type="submit" class="btn btn-info btn-block" value="{-:@SUBMIT-}">
		</form>
	{-:/if-}
	</div>
</div>
{-include:clip/hrp-}

{-include:clip/footer-}
<script src="{-:*__RES__-}js/loga.js"></script>
<script src="{-:*__RES__-}js/jquery.js"></script>
<script src="{-:*__RES__-}fea/js/fea.min.js"></script>
<script src="{-:*__STYLE__-}mobile/js/common.js"></script>
<script src="{-:*__STYLE__-}js/review.js"></script>
{-:$_SITE['stat_code']-}
</body>
</html>