<?php

/**
 *--------------------------------------
 * controller base
 *--------------------------------------
 * @project		: pfa
 * @author		: cblee
 * @created		: 2012-9-23
 * @copyright	: (c)2012 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class Ctrlr extends Pfa {
	protected $te = null;

	public function __construct() {
		/* get template engine instance */
		$this->te = Te::connect();
	}

	/* template variable assignment */
	public function assign($var, $value) {
		$this->te->assign($var, $value);
	}

	/* fetch content */
	public function fetch($file = '') {
		return $this->te->fetch($file);
	}

	/* display content */
	public function display($file = '', $charset = '', $contentType = '') {
		/* webpage charset */
		if(empty($charset)) {
			$charset = C('APP.CHARSET');
		}
		if(empty($contentType)) {
			$contentType = C('TE.TPL_CONTENT_TYPE');
		}
		header('Content-Type:'.$contentType.'; charset='.$charset);
		header('Cache-control: private'); // support page go back

		$this->te->display($file);
	}

	/* build HTML. $htmlfile: html file naming to build, $htmlpath: html file full directory, $templateFile Template file */
	public function build_html($htmlfile = '', $htmlpath = '', $templateFile = '') {
		return $this->te->build_html($htmlfile, $htmlpath, $templateFile);
	}

	/* operation error jump */
	public function error($message = '', $jumpUrl = '', $ajax = false) {
		$this->_disp_jump($message, $jumpUrl, 0, $ajax);
	}

	/* operation success jump */
	public function success($message = '', $jumpUrl = '', $ajax = false) {
		$this->_disp_jump($message, $jumpUrl, 1, $ajax);
	}

	/* Ajax return. $data: array('data'=>1, 'info'=>'info'), $type:ajax type*/
	public function ajax_return($data, $type = 'JSON') {
		switch(strtoupper($type)) {
			case 'JSON': // return JSON data
				header('Content-Type:text/html; charset=utf-8');
				exit(json_encode($data));
			case 'XML': // return XML data
				header('Content-Type:text/xml; charset=utf-8');
				exit(xml_encode($data));
			case 'EVAL': // return executable js script
				header('Content-Type:text/html; charset=utf-8');
				exit($data);
			default:
				exit();
		}
	}

	public function __call($method, $args) {
		if(method_exists($this, '_empty')) {
			$this->_empty($method, $args);
		}
		elseif(C('DEBUG.SWITCH')) {
			halt(L('_METHOD_INEXISTENCE_', null, array('method' => $method)), true, true);
		}
		else {
			halt('', true, true);
		}
	}

	public static function __callStatic($method, $args) {
	}

	/* disp jump $status 1:success, 0:error */
	private function _disp_jump($message, $jumpUrl = '', $status = 1, $ajax = false) {
		if($ajax or IS_AJAX) {
			$data = array(
				'status' => $status,
				'message' => $message,
				'jump_url' => $jumpUrl
			);
			$this->ajax_return($data);
		}
		if($status) {
			$this->assign('status', 'success');
		}
		else {
			$this->assign('status', 'error');
		}
		$this->assign('message', $message);
		$this->assign('jumpUrl', $jumpUrl);
		$this->display(C('TPL.DISP_JUMP'));
		exit();
	}

}

?>