<?php

/**
 *--------------------------------------
 * COOKIE
 *--------------------------------------
 * @project		: pfa
 * @author		: cblee
 * @created		: 2012-9-23
 * @copyright	: (c)2012 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class ACookie {
	/* don't set an object as $value */
	public static function set($name, $value = '', $key = null, $prefix = null, $expire = null, $path = null, $domain = null) {
		$prefix = is_null($prefix) ? C('COOKIE.PREFIX') : $prefix;
		if(is_null($expire)) {
			$_expire = time() + C('COOKIE.EXPIRE');
		}
		elseif(0 === $expire) {
			$_expire = 0;
		}
		else {
			$_expire = time() + $expire;
		}
		$path = is_null($path) ? C('COOKIE.PATH') : $path;

		if(is_null($domain)) {
			$domain = C('COOKIE.DOMAIN');
			if(empty($domain)) {
				$domain = AServer::get_env('HTTP_HOST');
			}
		}
		$domain = 'localhost' == $domain ? false : $domain;
		$key = is_null($key) ? C('COOKIE.KEY') : $key;
		if(C('COOKIE.CLIENT_CHECK')) {
			/* save pfa cookie client id */
			$cip = md5(AServer::get_ip());
			$cid = AServer::get_clientId();
			$_PCCI = S('_PCCI_'.$cip, '', null, array('temp' => TEMP_PATH.D_S.'_pcci'));
			if(empty($_PCCI)) {
				S('_PCCI_'.$cip, $cid, $expire, array('temp' => TEMP_PATH.D_S.'_pcci'));
			}
			$key .= $cid;
		}

		$value = !is_null($value) ? ACrypt::encrypt(serialize($value), $key) : null;

		setcookie($prefix.$name, $value, $_expire, $path, $domain);
	}

	public static function get($name = null, $key = null, $prefix = null) {
		$key = is_null($key) ? C('COOKIE.KEY') : $key;
		if(C('COOKIE.CLIENT_CHECK')) {
			$key .= AServer::get_clientId();
		}

		$prefix = is_null($prefix) ? C('COOKIE.PREFIX') : $prefix;

		$is_checked = 1;
		if(C('COOKIE.CLIENT_CHECK')) {
			$is_checked = self::_check_clientId();
		}

		if(1 == $is_checked) {
			if(is_null($name)) {
				$_c = array();
				foreach($_COOKIE as $k => $v) {
					$_t_name = substr($k, strlen($prefix));
					if(substr($k, 0, strlen($prefix)) == $prefix) {
						$_c[$_t_name] = deserialize(ACrypt::decrypt($v, $key));
					}
				}
				return $_c;
			}
			return isset($_COOKIE[$prefix.$name]) ? deserialize(ACrypt::decrypt($_COOKIE[$prefix.$name], $key)) : '';
		}
		return '';
	}

	public static function del($name, $key = null, $prefix = null) {
		self::set($name, null, $key, $prefix, -1000);
	}

	/* clear all cookie */
	public static function clear($key = null, $prefix = null) {
		$key = is_null($key) ? C('COOKIE.KEY') : $key;
		$prefix = is_null($prefix) ? C('COOKIE.PREFIX') : $prefix;
		$preLen = strlen($prefix);
		foreach($_COOKIE as $name => $val) {
			if(strpos($name, $prefix) === 0) {
				self::del(substr($name, $preLen), $key, $prefix);
			}
		}
		$cip = md5(AServer::get_ip());
		S('_PCCI_'.$cip, null, null, array('temp' => TEMP_PATH.D_S.'_pcci'));
	}

	/* check client ID */
	private static function _check_clientId() {
		$cip = md5(AServer::get_ip());
		$cid = AServer::get_clientId();
		if($cid == S('_PCCI_'.$cip, '', null, array('temp' => TEMP_PATH.D_S.'_pcci'))) {
			return 1;
		}
		S('_PCCI_'.$cip, null, null, array('temp' => TEMP_PATH.D_S.'_pcci'));
		return 0;
	}

	public function __construct() {
	}
}

?>