<?php
#注册插件
RegisterPlugin("CustomPostCount","ActivePlugin_CustomPostCount");

function ActivePlugin_CustomPostCount() {
	Add_Filter_Plugin('Filter_Plugin_Edit_Response3','CustomPostCount_Edit_Response');
	Add_Filter_Plugin('Filter_Plugin_ViewPost_Template','CustomPostCount_ViewNums');
	Add_Filter_Plugin('Filter_Plugin_PostArticle_Core','CustomPostCount_PostArticle_Core');
}

function CustomPostCount_Edit_Response() {
	global $zbp,$article;
	echo '<div id=\'edtViewNums\' class="editmod"> <label for="edtViewNums" class="editinputname" > 浏览 </label>';
    echo '<input type="text" name="ViewNums" id="edtViewNums"  value="' . $article->ViewNums . '" style="width:171px;"/>';
    echo '</div>';
}

function CustomPostCount_ViewNums(&$template) {
	global $zbp;
	if($zbp->Config('CustomPostCount')->ViewNumsOnOff) {
		$article = $template->GetTags('article');
		$article->ViewNums += mt_rand($zbp->Config('CustomPostCount')->ViewNumsStart,$zbp->Config('CustomPostCount')->ViewNumsEnd);
		$sql = $zbp->db->sql->Update($zbp->table['Post'], array('log_ViewNums' => $article->ViewNums), array(array('=', 'log_ID', $article->ID)));
		$zbp->db->Update($sql);
	}
}

function CustomPostCount_PostArticle_Core(&$article) {
	global $zbp;
	if($zbp->Config('CustomPostCount')->SaveOnOff) {
		if($article->ViewNums == 0 || $article->ViewNums == '') {
			$article->ViewNums = mt_rand($zbp->Config('CustomPostCount')->SaveStart,$zbp->Config('CustomPostCount')->SaveEnd);
		}
	}
}

function InstallPlugin_CustomPostCount() {
	global $zbp;
	if(!$zbp->Config('CustomPostCount')->HasKey('Version')) {
		$zbp->Config('CustomPostCount')->Version = '1.0';
		$zbp->Config('CustomPostCount')->ViewNumsOnOff = true;
		$zbp->Config('CustomPostCount')->ViewNumsStart = '10';
		$zbp->Config('CustomPostCount')->ViewNumsEnd = '99';
		$zbp->Config('CustomPostCount')->SaveOnOff = true;
		$zbp->Config('CustomPostCount')->SaveStart = '1000';
		$zbp->Config('CustomPostCount')->SaveEnd = '9999';
		$zbp->SaveConfig('CustomPostCount');
	}
}

function UninstallPlugin_CustomPostCount() {
	global $zbp;
	$zbp->DelConfig('CustomPostCount');
}