<?php
RegisterPlugin("PingTool", "ActivePlugin_PingTool");

function ActivePlugin_PingTool() {
	Add_Filter_Plugin('Filter_Plugin_Edit_Response3', 'PingTool_edit_response3');
	Add_Filter_Plugin('Filter_Plugin_PostArticle_Succeed', 'PingTool_post_article_succeed');
}

function InstallPlugin_PingTool() {
	global $zbp;
	if (!isset($zbp->Config('PingTool')->strData)) {
		$zbp->Config('PingTool')->strData = '';
		$zbp->SaveConfig('PingTool');
	}
}

function UninstallPlugin_PingTool() {
}

function PingTool_edit_response3() {
	?>
<div id="PingTool" class="editmod">
  <label for="edtPingTool" class="editinputname">Ping:</label>
  <input id="edtPingTool" name="PingTool" type="text" value="1" class="checkbox"/>
</div>
<?php
}

function PingTool_post_single($url, $article_url) {
	global $zbp;

	$s = '<?xml version="1.0"?><methodCall><methodName>weblogUpdates.ping</methodName><params><param><value>' . trim($article_url) . '</value></param></params></methodCall>';

	$ajax = Network::Create();
	if (!$ajax) {
		throw new Exception('主机没有开启网络功能');
	}

	$ajax->open('POST', $url);
	$ajax->setRequestHeader('Content-Type', 'text/xml');
	$ajax->send($s);

	echo $url;

	$ajax = null;
	return;
}

function PingTool_post_article_succeed(&$article) {

	if (GetVars('PingTool', 'POST') != '1') {
		return;
	}

	global $zbp;

	$ping_data = $zbp->Config('PingTool')->strData;
	$ping_array = explode("\n", $ping_data);

	for ($i = 0; $i < count($ping_array); $i++) {
		PingTool_post_single(trim($ping_array[$i]), $article->Url);
		echo $article->Url . "\n";
	}

}