<?php
//注册插件
require dirname(__FILE__) . DIRECTORY_SEPARATOR . 'config.php';
require dirname(__FILE__) . DIRECTORY_SEPARATOR . 'class.php';

RegisterPlugin("SEOTools", "ActivePlugin_SEOTools");

function ActivePlugin_SEOTools() {
	Add_Filter_Plugin('Filter_Plugin_Admin_TopMenu','SEOTools_AddMenu');
    Add_Filter_Plugin('Filter_Plugin_ViewPost_Template', 'SEOTools_Main');
	Add_Filter_Plugin('Filter_Plugin_Template_GetTemplate','SEOTools_Title');
}

function SEOTools_AddMenu(&$m){
	global $zbp;
	$m[]=MakeTopMenu("root",'SEO小工具',$zbp->host . "zb_users/plugin/SEOTools/main.php?act=config","","topmenu_SEOTools");
}

function SEOTools_Main(&$template) {
	global $zbp;
	$article = $template->GetTags('article');

	$systag = $zbp->Config('SEOTools')->dissys_tag;
	$costag = $zbp->Config('SEOTools')->discos_tag;

    if ($systag == '1' && $costag !== '1') {
        $arrkey = SEOTools_GetTags();
    } elseif ($systag !== '1' && $costag == '1') {
        $arrkey = SEOTools_GetKeyWord();
    } elseif ($systag == '1' && $costag == '1') {
        $arrkey = SEOTools_GetKeyWord() + SEOTools_GetTags();
    }

	if ($systag == '1' || $costag == '1') {
	    $str = $article->Content;
	    $key = new KeyReplace($str, $arrkey); //关键词加链接
	    $article->Content = $zbp->Config('SEOTools')->article_top . $key->getResultText() . $zbp->Config('SEOTools')->article_foot;
	    $KeyRunTime = $key->getRuntime();
	}
	else {
		$article->Content = $zbp->Config('SEOTools')->article_top . $article->Content . $zbp->Config('SEOTools')->article_foot;
	}
}

function SEOTools_Title($template,$file){
	global $zbp;
	$GLOBALS['Filter_Plugin_Template_GetTemplate']['SEOTools_Title'] = PLUGIN_EXITSIGNAL_NONE;
	if($file=='header'){
		$GLOBALS['Filter_Plugin_Template_GetTemplate']['SEOTools_Title'] = PLUGIN_EXITSIGNAL_RETURN;
		return $zbp->usersdir . 'plugin/SEOTools/titleseo.php';
	}
}

function SEOTools_GetKeyWord() {
    global $zbp;
    $result = array();
	$where = array(array('=','KeyWord_Type','0'),array('=','KeyWord_IsUsed','1'));
	$order = array('KeyWord_IsUsed'=>'DESC','KeyWord_ID'=>'ASC');

    $sql = $zbp->db->sql->Select($zbp->table['SEOTools'], '*', $where, $order, null, null);
    $array = $zbp->GetListCustom($zbp->table['SEOTools'], $zbp->datainfo['SEOTools'], $sql);
    foreach ($array as $key => $reg) {

        $result[$reg->Title] = $reg->Url;
    }

    return $result;
}

function SEOTools_GetTags() {
    global $zbp;
    $result = array();
	$num = $zbp->Config('SEOTools')->sys_tag;
    $Namestr = $Urlstr = '';
    $array = $zbp->GetTagList('','',array('tag_Count'=>'DESC'),'','');
	shuffle($array); 
    foreach ($array as $key => $tag) {
		if($key>$num-2){
			break;
		}

        $result[$tag->Name] = $tag->Url;
    }

    return $result;
}

function SEOTools_CreateTable() {
    global $zbp;
    if ($zbp->db->ExistTable($GLOBALS['table']['SEOTools']) == false) {
        $s = $zbp->db->sql->CreateTable($GLOBALS['table']['SEOTools'], $GLOBALS['datainfo']['SEOTools']);
        $zbp->db->QueryMulit($s);
    }
}

function SEOTools_DefaultCode() {
    global $zbp;
    $Arr_DF = explode('|', base64_decode($GLOBALS['DefaultKeyWord']));
    $r = new SEOTools;
    $r->Title = $Arr_DF[0];
    $r->Des = $Arr_DF[1];
    $r->Url = $Arr_DF[2];
    $r->Save();
}

function SEOTools_DelTable() {
    global $zbp;
    if ($zbp->db->ExistTable($zbp->table['SEOTools']) == true) {
        $s = $zbp->db->sql->DelTable($zbp->table['SEOTools']);
        $zbp->db->QueryMulit($s);
    }
}

function InstallPlugin_SEOTools() {
    global $zbp;
    //配置初始化
    if (!$zbp->Config('SEOTools')->HasKey('version')) {
        $zbp->Config('SEOTools')->version = '1.0';
        $zbp->Config('SEOTools')->custom_config = '5';
		$zbp->Config('SEOTools')->title_keywords='关键词';
		$zbp->Config('SEOTools')->title_description='描述';
		$zbp->Config('SEOTools')->title_change=true;
		$zbp->Config('SEOTools')->title_ms='100';
		$zbp->Config('SEOTools')->article_top='';
		$zbp->Config('SEOTools')->article_foot='';
		$zbp->Config('SEOTools')->distitle_seo=false;
		$zbp->Config('SEOTools')->sys_tag='1000';
		$zbp->Config('SEOTools')->dissys_tag='1';
		$zbp->Config('SEOTools')->discos_tag='1';
		$zbp->Config('SEOTools')->tags_nums='1';
		$zbp->Config('SEOTools')->links_nums='10';
        $zbp->SaveConfig('SEOTools');
    }
    SEOTools_CreateTable();
    SEOTools_DefaultCode();
}

function UninstallPlugin_SEOTools() {
    global $zbp;
    $zbp->DelConfig('SEOTools');
    SEOTools_DelTable();
}
