<?php
/* Template Name: Radial Gallery */
?>
<?php get_header(); ?>
<?php get_template_part(THEME_INCLUDES.'top'); ?>


				<!-- BEGIN .main-column-wrapper -->
				<div class="main-column-wrapper">


					<!-- BEGIN .full-width -->
					<div class="full-width">

						<div class="post-title">
							<b><?php printf ( __( 'Photo Gallery' , THEME_NAME ));?></b>
							<!-- END .main-title -->
						</div>
						
						<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
							<?php 
								$g = get_the_ID();
								global $query_string;
								$query_vars = explode('&',$query_string);
								
								foreach($query_vars as $key) {
									if(strpos($key,'page=') !== false) {
										$i = substr($key,8,12);
										break;
									}
								}
												
								if($i == 0) $i=0;
																
								$gallery_page = get_option(THEME_NAME."_gallery_page");
								$page = get_post($gallery_page);
								$gallery_slug = $page->post_name;
													
								$args = array( 'post_type' => 'attachment', 'numberposts' => -1, 'post_status' => null, 'post_parent' => $g, 'order'=> 'ASC', 'orderby'=> 'menu_order' ); 
								$attachments = get_posts($args);
								
								if ($attachments) {
									$file = $attachments[$i]->guid;
									$count = count($attachments);
													
							?>
						<div class="post-subtitle">
							<b><?php the_title();?></b>
						</div>
												
						<!-- BEGIN .photo-gallery-open-->
						<div class="photo-gallery-open">
						
									<div class="photo-gallery-list">		
										<?php
											$imgs = explode("/wp-content/", $file); 
											foreach($attachments as $attachment) {
											
												$file = $attachment->guid;
										?>
										<a rel="group" href="<?php echo get_site_url(); ?>/<?php $imgs = explode("/wp-content/", $file); echo "wp-content/".$imgs[1];?>" class="fancy"><img src="<?php echo get_template_directory_uri(); ?>/timthumb.php?src=/<?php $imgs = explode("/wp-content/", $file); echo "wp-content/".$imgs[1];?>&amp;w=125&amp;h=125&amp;zc=1&amp;q=100" alt="<?php the_title();?>"  class="image" /></a>						
										<?php
											}
										?>
									</div>


									<?php if (get_the_content() != "") { ?>
										<!-- BEGIN .description -->
										<div class="description">
											<?php
												add_filter('the_content','remove_images');
												add_filter('the_content','remove_objects');
												the_content();
											?>
										<!-- END .description -->
										</div>
							<?php } ?>
							<?php } else {
								echo ( __( 'This gallery has no pictures!' , THEME_NAME ));
								} ?>

						<?php endwhile; ?>
						<?php endif;?>
						

						<!-- END .photo-gallery-open-single -->
						</div>

					<!-- END .full-width -->
					</div>


					<div class="clear">&nbsp;</div>


				<!-- END .main-column-wrapper -->
				</div>
			
<?php get_footer(); ?>
