<?php
/*
Template Name: Archive Page
*/	
?>
<?php get_header(); ?>
<?php get_template_part(THEME_INCLUDES.'top'); ?>

			<!-- BEGIN .main-column-wrapper -->
			<div class="main-column-wrapper">

				<!-- BEGIN .full-width -->
				<div class="full-width">

					<div class="post-title">
						<b><?php printf ( __( 'Archive' , THEME_NAME ));?></b>
					</div>

					<!-- BEGIN .archive -->
					<div class="archive">
							<?php 
								$args = array(
									'type'                     => 'post',
									'child_of'                 => 0,
									'orderby'                  => 'name',
									'order'                    => 'ASC',
									'hide_empty'               => 1,
									'hierarchical'             => 1,
									'taxonomy'                 => 'category',
									'pad_counts'               => false );
									
								$categories = get_categories( $args );
								$count_total = count( $categories );
								$i = 0;
								foreach ( $categories as $category ) { 
								
									if ( ( ( $i % 3 == 0 ) && $i != 0 ) || $i == 3 ) { 
										echo "<!-- END .row -->
											</div>";
									}
									
									if ( $i == 0 || ( $i % 3 == 0 && $i != 0 ) ) { 
										echo "<!-- BEGIN .row -->
											<div class=\"row\">";
									}
									
									$query='cat='.$category->term_id.'&showposts=6';
									$my_query = new WP_Query($query);
									
							?>
									<div class="category">
										<div class="sidebar-title">
											<b><?php echo $category->name; ?></b>
										</div>
										<ul>
											<?php if ( $my_query->have_posts() ) : while ( $my_query->have_posts() ) : $my_query->the_post(); ?>
												<li><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
											<?php endwhile; else: ?>
											<?php endif; ?>	

										</ul>
										<p><a href="<?php echo get_category_link ( $category->term_id ) ;?>" class="more-link"><span><?php printf ( __( 'More about' , THEME_NAME ));?> <?php echo $category->name; ?></span></a></p>
									</div>
							<?php 
									if ( $count_total == $i + 1 ) { 
										echo "<!-- END .row -->
											</div>";
									}
									
									$i++;
								} 
							?>

					<!-- END .archive -->
					</div>

				<!-- END .full-width -->
				</div>
			<!-- END .main-column-wrapper -->
			</div>

<?php get_footer(); ?>