<?php

/* ==  WARNING! DO NOT EDIT THIS FILE! (PLEASE)  ==============================
*
*	  If you know what you're doing and would like to add your own custom
*     functions to this theme, DO NOT EDIT THIS FILE. Instead, use the
*     custom-functions.php file to define custom functions. Adding your
*     custom functions there will make it much easier to upgrade to a newer
*	  version of this theme without losing any of your customizations.
*
* ============================================================================*/


/* ==  Engine Data  ==============================*/

load_theme_textdomain('engine');


/* ==  Theme Data  ==============================*/


$curr_theme = wp_get_theme();
$theme_name = trim($curr_theme['Name']);
$theme_version = trim($curr_theme['Version']);
define('DT_THEME_NAME', $theme_name); // Theme name, as set in style.css
define('DT_THEME_VERSION', $theme_version); // The theme version, as set in style.css
define('DT_MAINMENU_NAME', 'dt-options'); // The page URL for the main level of the DT admin panel


/* ==  Path Constants  ==============================*/

define('DT_ENGINE', get_template_directory() . '/engine');
define('DT_CSS', DT_ENGINE . '/css');
define('DT_IMAGES', DT_ENGINE . '/image');
define('DT_JS', DT_ENGINE . '/js');
define('DT_OPTIONS', DT_ENGINE . '/options');
define('DT_FUNCTIONS', DT_ENGINE . '/functions');
define('DT_WIDGETS', DT_ENGINE . '/widgets');
define('DT_TUNING', get_template_directory() . '/tuning');


/* ==  File Includes  ==============================*/

require_once(DT_FUNCTIONS . '/image-resize.php');
require_once(DT_FUNCTIONS . '/theme-extensions.php');
require_once(DT_FUNCTIONS . '/theme-shortcodes.php');
require_once(DT_FUNCTIONS . '/theme-pagination.php');
require_once(DT_FUNCTIONS . '/theme-contact.php');
require_once(DT_FUNCTIONS . '/theme-breadcrumbs.php');
require_once(DT_FUNCTIONS . '/theme-widgets.php');
require_once(get_template_directory() . '/custom-functions.php');

require_once(DT_FUNCTIONS . '/admin-editor.php');
require_once(DT_FUNCTIONS . '/admin-posttypes.php');

require_once(DT_OPTIONS . '/admin-custom.php');

if(is_admin()) {

	require_once(DT_FUNCTIONS . '/admin-columns.php');

	require_once(DT_OPTIONS . '/admin-functions.php');
	require_once(DT_OPTIONS . '/admin-main.php');
	require_once(DT_OPTIONS . '/admin-import-export.php');

	require_once(DT_TUNING . '/theme-metaboxes.php');
	require_once(DT_TUNING . '/theme-options.php');

}


/* ==  Add Admin menus  ==============================*/

add_action('admin_head', 'dt_admin_head');
add_action('admin_menu', 'dt_add_admin');
add_action('admin_menu', 'dt_add_import_export');


/* ==  Theme Supports  ==============================*/

add_theme_support('post-thumbnails');
add_theme_support('menus');
add_theme_support('automatic-feed-links');


/* ==  Custom Excerpt Functions  ==============================*/

function dt_excerpt_more($excerpt) {
	return str_replace('[...]', '...', $excerpt);
}
add_filter('wp_trim_excerpt', 'dt_excerpt_more');


/* ==  Script Enqueues  ==============================*/

function dt_script_enqueues() {

	if (!is_admin()) {

		wp_enqueue_script('jquery');
		wp_register_script('easing', get_template_directory_uri() . '/engine/js/jquery.easing.1.3.min.js', 'jquery');
		wp_register_script('superfish', get_template_directory_uri() . '/engine/js/superfish.js', 'jquery');
		wp_register_script('tabs', get_template_directory_uri() . '/engine/js/tabs.js', 'jquery');
		wp_register_script('dt_custom', get_template_directory_uri() . '/js/jquery.custom.js', 'jquery', '1.0', TRUE);

		wp_enqueue_script('jquery');
		wp_enqueue_script('easing');
		wp_enqueue_script('superfish');
		wp_enqueue_script('tabs');
		wp_enqueue_script('dt_custom');

	}

	if(isset($_GET['page']) && ($_GET['page']=='dt-options') || isset($_GET['page']) && ($_GET['page']=='dt-settings-manager')) {
		
		wp_enqueue_script('jquery');
		
		wp_register_script('admin', get_template_directory_uri() . '/engine/js/admin.js', 'jquery');
		wp_register_script('dt-admin', get_template_directory_uri() . '/engine/js/dt-admin.js', 'jquery');
		wp_register_script('ajaxupload', get_template_directory_uri() . '/engine/js/ajaxupload.js', 'jquery');

    	wp_enqueue_script( 'admin', 'jquery' );
    	wp_enqueue_script( 'dt-admin', 'jquery' );
    	wp_enqueue_script( 'ajaxupload', 'jquery' );

    	// Load Thickbox
   	 	wp_enqueue_script('thickbox',null,array('jquery'));
		wp_enqueue_style('thickbox.css', '/'.WPINC.'/js/thickbox/thickbox.css', null, '1.0');

    }

    if(isset($_GET['page']) && ($_GET['page']=='dt-options')) {
		wp_enqueue_style( 'farbtastic' );
		wp_enqueue_script( 'farbtastic' );
	}

}

add_action('init', 'dt_script_enqueues');


/* ==  Hooks  ==============================*/

function dt_head_hooks() {
	echo stripslashes(get_option('dt_header_scripts'));
	if (!dt_options_set()) { include (DT_FUNCTIONS . '/save-message.php'); }
}
add_action('wp_head', 'dt_head_hooks');


/* ==  Page/Post Specific Enqueues  ==============================*/

add_action('wp_head', 'dt_specific_enqueues');
function dt_specific_enqueues() {

	if (is_singular()) {
		wp_enqueue_script( 'comment-reply' );
	}

}

