<?php

/* ==  WARNING! DO NOT EDIT THIS FILE! (PLEASE)  ==============================
*
*	  If you know what you're doing and would like to add your own custom
*     functions to this theme, DO NOT EDIT THIS FILE. Instead, use the
*     custom-functions.php file to define custom functions. Adding your
*     custom functions there will make it much easier to upgrade to a newer
*	  version of this theme without losing any of your customizations.
*
* ============================================================================*/


/* ==  Start Engine ==============================*/

require_once(TEMPLATEPATH . '/engine/engine.php');


/* ==  Thumbnails  ==============================*/

if ( function_exists( 'add_theme_support' ) ) {
	set_post_thumbnail_size( 60, 60, true ); // Normal post thumbnails
}


/* ==  Set Max Content Width  ==============================*/

if ( ! isset( $content_width ) ) $content_width = 580;


/* ==  Register Menus  ==============================*/

function dt_register_menu() {

	register_nav_menu('primary-menu-left', __('Primary Menu Left', 'engine'));
	register_nav_menu('primary-menu-right', __('Primary Menu Right', 'engine'));
	register_nav_menu('secondary-menu', __('Secondary Menu', 'engine'));
	register_nav_menu('footer-menu', __('Footer Menu', 'engine'));
	register_nav_menu('mobile-menu', __('Mobile Menu', 'engine'));

}

add_action('init', 'dt_register_menu');


/* ==  Script Enqueues  ==============================*/

function dt_theme_script_enqueues() {

	if (!is_admin()) {

		if(!is_single()) {
			wp_register_script('isotope', get_template_directory_uri() . '/js/jquery.isotope.min.js', 'jquery');
			wp_enqueue_script('isotope');
		}

		if(!is_page()) {
			wp_register_script('slidesjs', get_template_directory_uri() . '/js/slides.min.jquery.js', 'jquery');
			wp_enqueue_script('slidesjs');
		}

		wp_register_script('colorbox', get_template_directory_uri() . '/js/jquery.colorbox.js', 'jquery');
		wp_enqueue_script('colorbox');
		
		wp_register_script('fitvids', get_template_directory_uri() . '/js/jquery.fitvids.js', 'jquery');
		wp_enqueue_script('fitvids');
		
		wp_register_script('imagesLoaded', get_template_directory_uri() . '/js/jquery.imagesloaded.js', 'jquery');
		wp_enqueue_script('imagesLoaded');
		
		if(has_nav_menu('mobile-menu')) {
			wp_register_script('mobileMenu', get_template_directory_uri() . '/js/jquery.mobileMenu.js', 'jquery');
			wp_enqueue_script('mobileMenu');
		}
		
		if(is_front_page() && get_option('dt_slider') != 'false') {
			wp_enqueue_script('camera', get_template_directory_uri() . '/js/camera.min.js', 'jquery');
		}

	}

}

add_action('wp_print_scripts', 'dt_theme_script_enqueues');


/* ==  Style Enqueues  ==============================*/

function dt_theme_style_enqueues() {

       wp_register_style('colorbox', get_template_directory_uri() . '/js/colorbox/colorbox.css');
       wp_enqueue_style( 'colorbox');
       
       wp_enqueue_style( 'dt-mobile', get_template_directory_uri() . '/mobile.css');
       
       if(is_front_page() || is_home()) {
			wp_enqueue_style('camera', get_template_directory_uri() . '/camera.css');
		}
	
}

add_action('wp_print_styles', 'dt_theme_style_enqueues');


/* ==  Sidebars  ==============================*/

if ( function_exists('register_sidebar') ) {

	register_sidebar(array(
		'name' => __('Homepage Intro', 'engine'),
		'id' => 'home_intro',
		'description' => __('Widget area displayed on the homepage below the slider.', 'engine'),
		'before_widget' => '<div id="%1$s" class="widget %2$s widget-%2$s"><div class="widget-inside cf">',
		'after_widget' => '</div></div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	));
	
	register_sidebar(array(
		'name' => __('Homepage Sidebar', 'engine'),
		'id' => 'home_sidebar',
		'description' => __('Sidebar widget area only displayed on the homepage.', 'engine'),
		'before_widget' => '<div id="%1$s" class="widget %2$s widget-%2$s"><div class="widget-inside cf">',
		'after_widget' => '</div></div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	));
	
	register_sidebar(array(
		'name' => __('Blog Sidebar', 'engine'),
		'id' => 'blog_sidebar',
		'description' => __('Sidebar widget area only displayed on archives and single posts.', 'engine'),
		'before_widget' => '<div id="%1$s" class="widget %2$s widget-%2$s"><div class="widget-inside cf">',
		'after_widget' => '</div></div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	));

	register_sidebar(array(
		'name' => __('Page Sidebar', 'engine'),
		'id' => 'page_sidebar',
		'description' => __('Sidebar widget area only displayed on pages.', 'engine'),
		'before_widget' => '<div id="%1$s" class="widget %2$s widget-%2$s"><div class="widget-inside cf">',
		'after_widget' => '</div></div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	));
	
	register_sidebar(array(
		'name' => __('Global Sidebar', 'engine'),
		'id' => 'global_sidebar',
		'description' => __('Default sidebar widget area. Displayed on all posts, pages, archives, etc. excluding the homepage.', 'engine'),
		'before_widget' => '<div id="%1$s" class="widget %2$s widget-%2$s"><div class="widget-inside cf">',
		'after_widget' => '</div></div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	));

}


/* ==  Custom Post Types  ==============================
*
*	   dt_register_post_type($name, $slug, $supports, $exclude_from_search)
*
*	   STRING 		required 	$name
*	   STRING 		required 	$slug
*	   ARRAY  		optional 	$supports
*	   BOOLEAN 		optional	$exclude_from_search
*
*	   If you decide to change the slug, remember to re-save your permalinks
*	   in Settings > Permalinks
*
* ============================================================================*/

$supports = array('title', 'editor', 'thumbnail', 'custom-fields', 'excerpt', 'comments', 'groups', 'post-formats');

dt_register_post_type(__('Showcase', 'engine'), 'showcase', $supports);


/* ==  Custom Taxonomies  ==============================
*
*	   dt_register_taxonomy($name, $slug, $posttype, $hierarchical)
*
*	   STRING 		required 	$name
*	   STRING 		required 	$slug
*	   STRING 		required 	$posttype
*	   ARRAY  		optional 	$hierarchical
*
*	   If you decide to change the slug, remember to re-save your permalinks
*	   in Settings > Permalinks
*
* ============================================================================*/

dt_register_taxonomy(__('Groups', 'engine'), 'group', 'showcase', true);


/* ==  Post Formats  ==============================*/

add_theme_support( 'post-formats', array( 'image', 'gallery', 'video' ) );
add_post_type_support( 'showcase', 'post-formats' );


/* ==  Widgets  ==============================*/

$widgets = array(
	'better-search',
	'twitter-tweets',
	'flickr-photos'
);

dt_include_widgets($widgets);


/* ==  Colour Scheme  ==============================*/

function dt_colour_css() {

	$colour = get_option('dt_color');

	if($colour == '') {
		$colour = '#99cc00';
	}

	?>

	<style type="text/css">
		
		a,
		a:hover,
		#site-title a:hover,
		#secondary-menu ul li.current-menu-item ul a:hover,
		#secondary-menu ul ul a:hover,
		.commentlist .comment-meta a:hover,
		#comments label span,
		.item .post-title a:hover,
		#sidebar a:hover,
		#sidebar .DT_Twitter a:hover,
		#secondary-menu ul li.current-menu-item a,
		#secondary-menu ul li.current-menu-item a:hover { color: <?php echo $colour; ?>; }


		#filter li.active,
		#comments #submit,
		.featured .featured-details a.read-more,
		.featured .camera_prev:hover,
		.featured .camera_next:hover,
		.featured .camera_commands:hover,
		#slide-controls a:hover,
		#load-more:hover,
		.widget .tagcloud a:hover,
		.DT_Flickr .flickr_badge_image img:hover { background-color: <?php echo $colour; ?>; }

	</style>

	<?php

}

add_action('wp_head', 'dt_colour_css');


/* ==  AJAX  ==============================*/

function dt_init() {
 	global $wp_query;

 	// Add code to index pages.
 	if( !is_singular() ) {

 		// What page are we on? And what is the pages limit?
 		$max = $wp_query->max_num_pages;
 		$paged = ( get_query_var('paged') > 1 ) ? get_query_var('paged') : 1;

 		// Add some parameters for the JS.
 		wp_localize_script(
 			'dt_custom',
 			'dt',
 			array(
 				'startPage' => $paged,
 				'maxPages' => $max,
 				'nextLink' => next_posts($max, false)
 			)
 		);
 	}
 }
 add_action('template_redirect', 'dt_init');


/* ==  Overlay Icon  ==============================*/

function dt_overlay_icon() {

	$format = get_post_format();

	$has_format = false;
	$link = '#';
	$thumbnail_id = get_post_thumbnail_id(get_the_ID());
	$thumb_src = wp_get_attachment_image_src( $thumbnail_id, array( '9999','9999' ), false, '' );
	$thumb_src = $thumb_src[0];

	if($format == 'image') {

		$link = wp_get_attachment_image_src( $thumbnail_id, array( '9999','9999' ), false, '' );
		$link = $link[0];

		$has_format = true;

	} elseif($format == 'gallery') {

		$link = $thumb_src;
	    $has_format = true;

	} elseif($format == 'video') {

		global $wp_embed;
		$video_url = htmlspecialchars(get_post_meta(get_the_ID(), 'dt_video', true));
		$video_embed = $wp_embed->run_shortcode('[embed]'.$video_url.'[/embed]');

		$link = '#video-'.get_the_ID();

		$has_format = true;
	}

	if($has_format) : ?>
		
		<a data-gallery="group-<?php the_ID(); ?>" class="colorbox-<?php echo $format; ?>" href="<?php echo $link; ?>"><?php _e('View', 'engine'); ?> <?php echo ucfirst($format); ?></a>&nbsp;&nbsp;/&nbsp;&nbsp;
		
		<?php
		if($format == 'video'):
		?>

		<span class="dt-video-embed">
			<span id="video-<?php the_ID(); ?>"><?php echo $video_embed; ?></span>
		</span>
		
		<?php
		endif;

		if($format == 'gallery') {

			$args = array(
				'orderby'		 => 'menu_order',
				'post_type'      => 'attachment',
				'post_parent'    => get_the_ID(),
				'post_mime_type' => 'image',
				'post_status'    => null,
				'posts_per_page'    => -1,
			);

			$attachments = get_posts($args);

		    if ($attachments) :

		    	foreach ($attachments as $attachment) :

					$link = wp_get_attachment_image_src( $attachment->ID, array( '9999','9999' ), false, '' );
					$link = $link[0];

					if($thumb_src != $link) :
					?>

						<a class="colorbox-<?php echo $format; ?> hidden" data-gallery="group-<?php the_ID(); echo $featured; ?>" href="<?php echo $link; ?>"></a>

		    		<?php
		    		endif;

		    	endforeach;

		    endif;

		}

	endif;
	
	?>
	<a href="<?php the_permalink(); ?>"><?php _e('Read Post', 'engine'); ?></a>
	<?php

}


/* ==  Add rel to gallery links  ==============================*/

add_filter('wp_get_attachment_link', 'add_gallery_id_rel');
function add_gallery_id_rel($link) {
	global $post;
	return str_replace('<a href', '<a rel="gallery-'. $post->ID .'" href', $link);
}


/* ==  Footer Code  ==============================*/

function dt_analytics(){
	$output = get_option('dt_google_analytics');
	if ( $output <> "" )
		echo stripslashes($output) . "\n";
}

add_action('wp_footer','dt_analytics');


/* ==  Comment Styling  ==============================*/

function dt_comment($comment, $args, $depth) {

    $isByAuthor = false;

    if($comment->comment_author_email == get_the_author_meta('email')) {
        $isByAuthor = true;
    }

    $GLOBALS['comment'] = $comment; ?>

    <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">

     	<!--BEGIN #comment-id-->
		<div id="comment-<?php comment_ID(); ?>" class="clearfix">

			<?php echo get_avatar($comment,$size='46'); ?>

			<!--BEGIN .comment-meta-->
			<div class="comment-meta">
				<a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>"><?php printf(__('%1$s', 'engine'), get_comment_date()) ?></a>
				&middot;
				<?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
			<!--END .comment-meta-->
			</div>

			<!--BEGIN .comment-author-->
			<div class="comment-author">
				<?php echo get_comment_author_link(); ?> <?php _e('said…', 'engine'); ?>
			<!--END .comment-author-->
			</div>

			<?php if ($comment->comment_approved == '0') : ?>
			<em class="moderation"><?php _e('Your comment is awaiting moderation.', 'engine'); ?></em>
			<?php endif; ?>

			<!--BEGIN .comment-body-->
			<div class="comment-body">
				<?php comment_text() ?>
			<!--END .comment-body-->
			</div>

		<!--END #comment-id-->
		</div>

<?php
}


/* ==  Relative Time  ==============================*/

add_filter( 'get_the_date', 'dt_human_get_the_date' );
// For comments
add_filter( 'get_comment_date', 'dt_human_get_the_date' );
function dt_human_get_the_date ($date) {
    return human_time_diff( strtotime( $date ) ) . __(' ago', 'engine');
}


/* ==  List categories for the groups  ==============================*/

class Group_Walker extends Walker_Category {
   function start_el(&$output, $category, $depth, $args) {
      extract($args);
      $cat_name = esc_attr( $category->name);
      $cat_name = apply_filters( 'list_cats', $cat_name, $category );
	  $link = '<a href="#" data-filter=".term-'.$category->term_id.'" ';
      if ( $use_desc_for_title == 0 || empty($category->description) )
         $link .= 'title="' . sprintf(__( 'View all items filed under %s', 'engine' ), $cat_name) . '"';
      else
         $link .= 'title="' . esc_attr( strip_tags( apply_filters( 'category_description', $category->description, $category ) ) ) . '"';
      $link .= '>';
      // $link .= $cat_name . '</a>';
      $link .= $cat_name;
      if(!empty($category->description)) {
        // $link .= ' <span>'.$category->description.'</span>';
      }
      $link .= '</a>';
      if ( (! empty($feed_image)) || (! empty($feed)) ) {
         $link .= ' ';
         if ( empty($feed_image) )
            $link .= '(';
         $link .= '<a href="' . get_category_feed_link($category->term_id, $feed_type) . '"';
         if ( empty($feed) )
            $alt = ' alt="' . sprintf(__( 'Feed for all posts filed under %s', 'engine' ), $cat_name ) . '"';
         else {
            $title = ' title="' . $feed . '"';
            $alt = ' alt="' . $feed . '"';
            $name = $feed;
            $link .= $title;
         }
         $link .= '>';
         if ( empty($feed_image) )
            $link .= $name;
         else
            $link .= "<img src='$feed_image'$alt$title" . ' />';
         $link .= '</a>';
         if ( empty($feed_image) )
            $link .= ')';
      }
      if ( isset($show_count) && $show_count )
         $link .= ' (' . intval($category->count) . ')';
      if ( isset($show_date) && $show_date ) {
         $link .= ' ' . gmdate('Y-m-d', $category->last_update_timestamp);
      }
      if ( isset($current_category) && $current_category )
         $_current_category = get_category( $current_category );
      if ( 'list' == $args['style'] ) {
          $output .= '<li class="segment-'.rand(2, 99).'"';
          $class = 'cat-item cat-item-'.$category->term_id;
          if ( isset($current_category) && $current_category && ($category->term_id == $current_category) )
             $class .=  ' current-cat';
          elseif ( isset($_current_category) && $_current_category && ($category->term_id == $_current_category->parent) )
             $class .=  ' current-cat-parent';
          $output .=  '';
          $output .= ">$link\n";
       } else {
          $output .= "\t$link<br />\n";
       }
   }
}


/* ==  Get related posts by taxonomy  ==============================*/

function dt_get_posts_related_by_taxonomy($post_id, $taxonomy, $notin, $args=array()) {
  $query = new WP_Query();
  $terms = wp_get_object_terms($post_id, $taxonomy);
  if (count($terms)) {
    // Assumes only one term for per post in this taxonomy
    $post_ids = get_objects_in_term($terms[0]->term_id,$taxonomy);
    $post = get_post($post_id);
    $args = wp_parse_args($args,array(
      'post_type' => $post->post_type, // The assumes the post types match
      //'post__in' => $post_ids,
	  'post__not_in' => array($notin),
      'taxonomy' => $taxonomy,
      'term' => $terms[0]->slug,
	  'posts_per_page' => get_option('dt_related_number')
    ));
    $query = new WP_Query($args);
  }
  return $query;
}

function add_nofollow_cat( $text ) {

    $valid_tag = 'rel="tag"';
    $text = str_replace('rel="category tag"', $valid_tag, $text); 
    return $text;
}
add_filter( 'the_category', 'add_nofollow_cat' );


/* ==  Sidebar Class  ==============================*/

add_filter('body_class','dt_sidebar_classes');

function dt_sidebar_classes($classes) {

	if(is_home() && dt_is_sidebar_active('home_sidebar')) {
		$classes[] = 'sidebar-on';

	} elseif(!is_home() && (dt_is_sidebar_active('blog_sidebar') || dt_is_sidebar_active('global_sidebar')) ) {
		$classes[] = 'sidebar-on';

	}

	return $classes;

}

