/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.controller.MindMapNodesSelection;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.main.XMLParseException;
import freemind.modes.EdgeAdapter;
import freemind.modes.MindMap;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.StylePattern;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class MapAdapter
implements MindMap {
    private MindMapNode root;
    private EventListenerList treeModelListeners = new EventListenerList();
    protected int changesPerformedSinceLastSave = 1;
    protected boolean readOnly = true;
    private Color backgroundColor;
    private File file;
    private FreeMindMain frame;
    private String findWhat;
    private MindMapNode findFromNode;
    private boolean findCaseSensitive;
    private LinkedList findNodeQueue;
    private ArrayList findNodesUnfoldedByLastFind;
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;

    public MapAdapter(FreeMindMain frame) {
        this.frame = frame;
    }

    public abstract boolean save(File var1);

    public abstract void load(File var1) throws FileNotFoundException, IOException, XMLParseException;

    public String tryToLock(File file) throws Exception {
        return null;
    }

    public void destroy() {
    }

    public FreeMindMain getFrame() {
        return this.frame;
    }

    public boolean isSaved() {
        return this.changesPerformedSinceLastSave == 0;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void setSaved(boolean saved) {
        this.changesPerformedSinceLastSave = saved ? 0 : ++this.changesPerformedSinceLastSave;
    }

    protected int getNumberOfChangesSinceLastSave() {
        return this.changesPerformedSinceLastSave;
    }

    public String getFindWhat() {
        return this.findWhat;
    }

    public String getFindFromText() {
        return ((Object)this.findFromNode).toString();
    }

    public Color getBackgroundColor() {
        if (this.backgroundColor == null) {
            return Tools.xmlToColor(this.getFrame().getProperty("standardbackgroundcolor"));
        }
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.nodeChanged((MindMapNode)this.getRoot());
    }

    public Object getRoot() {
        return this.root;
    }

    protected void setRoot(MindMapNode root) {
        this.root = root;
    }

    public File getFile() {
        return this.file;
    }

    public URL getURL() throws MalformedURLException {
        return this.getFile() != null ? this.getFile().toURL() : null;
    }

    protected void setFile(File file) {
        this.file = file;
    }

    protected String getText(String textId) {
        String result;
        try {
            result = this.getFrame().getResources().getString(textId);
        }
        catch (Exception e) {
            return textId;
        }
        return result;
    }

    public void setFolded(MindMapNode node, boolean folded) {
        if (node.isFolded() != folded) {
            node.setFolded(folded);
            this.getFrame().getView().selectAsTheOnlyOneSelected(node.getViewer());
            this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
        }
    }

    public void setLink(NodeAdapter node, String link) {
        node.setLink(link);
        this.nodeChanged(node);
    }

    public String getLink(NodeAdapter node) {
        return node.getLink();
    }

    public Object[] getPathToRoot(TreeNode node) {
        return ((MindMapNode)node).getPath().getPath();
    }

    public void splitNode(MindMapNode node, int caretPosition, String newText) {
    }

    public final Transferable cut(MindMapNode node) {
        Transferable t = this.copy(node);
        this.removeNodeFromParent(node);
        return t;
    }

    public final Transferable cut() {
        Transferable t = this.copy();
        this.getLinkRegistry().clearCuttedNodeBuffer();
        LinkedList sortedNodes = this.getFrame().getView().getSelectedsByDepth();
        Iterator i = sortedNodes.iterator();
        while (i.hasNext()) {
            MindMapNode selectedNode = ((NodeView)i.next()).getModel();
            this.getLinkRegistry().cutNode(selectedNode);
            try {
                this.removeNodeFromParent(selectedNode);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Error occured during cut. The application was not able to cut the node " + selectedNode + ".");
            }
        }
        return t;
    }

    public Transferable copy(MindMapNode node) {
        return null;
    }

    public Transferable copy() {
        return this.copy(this.getFrame().getView().getSelectedNodesSortedByY(), null);
    }

    public Transferable copySingle() {
        MindMapNode selectedNode = this.getFrame().getView().getSelected().getModel();
        ArrayList<MindMapNode> selectedNodes = new ArrayList<MindMapNode>();
        selectedNodes.add(selectedNode.shallowCopy());
        return this.copy(selectedNodes, ((Object)selectedNode).toString());
    }

    private Transferable copy(ArrayList selectedNodes, String inPlainText) {
        try {
            String forNodesFlavor = "";
            boolean firstLoop = true;
            Iterator it = selectedNodes.iterator();
            while (it.hasNext()) {
                MindMapNode tmpNode = (MindMapNode)it.next();
                if (firstLoop) {
                    firstLoop = false;
                } else {
                    forNodesFlavor = forNodesFlavor + "<nodeseparator>";
                }
                forNodesFlavor = forNodesFlavor + this.copy(tmpNode).getTransferData(DataFlavor.stringFlavor);
            }
            String plainText = inPlainText != null ? inPlainText : this.getAsPlainText(selectedNodes);
            return new MindMapNodesSelection(forNodesFlavor, plainText, this.getAsRTF(selectedNodes), "");
        }
        catch (UnsupportedFlavorException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public String getAsPlainText(List mindMapNodes) {
        return "";
    }

    public String getAsRTF(List mindMapNodes) {
        return "";
    }

    public void paste(Transferable t, MindMapNode parent) {
        boolean isLeft = false;
        if (parent.isLeft() != null) {
            isLeft = parent.isLeft().getValue();
        }
        this.paste(t, parent, false, isLeft);
    }

    public void paste(Transferable t, MindMapNode target, boolean asSibling, boolean isLeft) {
        if (t != null) {
            this.nodeStructureChanged(asSibling ? target.getParent() : target);
        }
    }

    public void paste(MindMapNode node, MindMapNode parent) {
        if (node != null) {
            this.insertNodeInto(node, parent);
            this.nodeStructureChanged(parent);
        }
    }

    public String getRestoreable() {
        return null;
    }

    public MindMapLinkRegistry getLinkRegistry() {
        return null;
    }

    public void insertNodeIntoNoEvent(MindMapNode newChild, MindMapNode parent) {
        this.insertNodeIntoNoEvent(newChild, parent, false);
    }

    public void insertNodeIntoNoEvent(MindMapNode newChild, MindMapNode parent, boolean asSibling) {
        if (asSibling) {
            MindMapNode oldpa = parent.getParentNode();
            oldpa.insert(newChild, oldpa.getChildPosition(parent));
        } else {
            parent.insert(newChild, parent.getChildCount());
        }
    }

    public void insertNodeInto(MindMapNode newChild, MindMapNode parent) {
        this.insertNodeInto(newChild, parent, parent.getChildCount());
    }

    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        parent.insert(newChild, index);
        this.nodesWereInserted(parent, new int[]{index});
    }

    public int moveNodeTo(MindMapNode newChild, MindMapNode parent, int index, int direction) {
        int newIndex = index;
        if (newChild.isLeft() != null) {
            boolean iAmLeft = newChild.isLeft().getValue();
            int maxIndex = parent.getChildCount();
            Vector<MindMapNode> sortedNodes = new Vector<MindMapNode>();
            Vector<Tools.IntHolder> sortedNodesIndices = new Vector<Tools.IntHolder>();
            int leftRightBoundary = 0;
            Tools.IntHolder myPositionInVector = null;
            for (int i = 0; i < maxIndex; ++i) {
                TreeNode nextItem = parent.getChildAt(i);
                if (!(nextItem instanceof MindMapNode)) {
                    System.err.println("Strange error I in method insertNodeInto of MapAdapter.");
                    return newIndex;
                }
                MindMapNode nextNode = (MindMapNode)nextItem;
                if (nextNode.isLeft() != null && nextNode.isLeft().getValue()) {
                    sortedNodes.add(leftRightBoundary, nextNode);
                    sortedNodesIndices.add(leftRightBoundary, new Tools.IntHolder(i));
                    ++leftRightBoundary;
                    if (i != index) continue;
                    myPositionInVector = (Tools.IntHolder)sortedNodesIndices.get(leftRightBoundary - 1);
                    continue;
                }
                sortedNodes.add(nextNode);
                sortedNodesIndices.add(new Tools.IntHolder(i));
                if (i != index) continue;
                myPositionInVector = (Tools.IntHolder)sortedNodesIndices.get(sortedNodesIndices.size() - 1);
            }
            if (myPositionInVector == null) {
                System.err.println("Strange error II in method insertNodeInto of MapAdapter.");
                return newIndex;
            }
            int oldPositionInVector = sortedNodesIndices.indexOf(myPositionInVector);
            int newPositionInVector = oldPositionInVector + direction;
            boolean passedFrontiers = false;
            if (newPositionInVector < 0) {
                newPositionInVector = sortedNodesIndices.size() - 1;
                passedFrontiers = true;
            }
            if (newPositionInVector >= sortedNodesIndices.size()) {
                newPositionInVector = 0;
                passedFrontiers = true;
            }
            newIndex = ((Tools.IntHolder)sortedNodesIndices.get(newPositionInVector)).getValue();
            if (newPositionInVector >= leftRightBoundary && oldPositionInVector < leftRightBoundary || newPositionInVector < leftRightBoundary && oldPositionInVector >= leftRightBoundary) {
                newPositionInVector = oldPositionInVector;
                passedFrontiers = true;
            }
            if (passedFrontiers) {
                newChild.setLeft(!iAmLeft);
            }
        }
        return newIndex;
    }

    public void removeNodeFromParent(MutableTreeNode node) {
        this.removeNodeFromParent(node, true);
    }

    public void removeNodeFromParent(MutableTreeNode node, boolean notify) {
        MutableTreeNode parent = (MutableTreeNode)node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }
        int[] childIndex = new int[1];
        Object[] removedArray = new Object[1];
        childIndex[0] = parent.getIndex(node);
        parent.remove(node);
        if (notify) {
            removedArray[0] = node;
            this.nodesWereRemoved(parent, childIndex, removedArray);
        }
    }

    public void changeNode(MindMapNode node, String newText) {
        node.setUserObject(newText);
        this.nodeChanged(node);
    }

    public Object getChild(Object parent, int index) {
        return ((TreeNode)parent).getChildAt(index);
    }

    public int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildCount();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = MapAdapter.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = MapAdapter.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        ((MutableTreeNode)path.getLastPathComponent()).setUserObject(newValue);
    }

    public void applyPattern(NodeAdapter node, StylePattern pattern) {
        this.applyPattern(node, pattern, true);
    }

    protected void applyPattern(NodeAdapter node, StylePattern pattern, boolean visible) {
        if (pattern.getAppliesToNode()) {
            if (pattern.getText() != null) {
                node.setUserObject(pattern.getText());
            }
            node.setColor(pattern.getNodeColor());
            node.setStyle(pattern.getNodeStyle());
            if (pattern.getAppliesToNodeIcon()) {
                if (pattern.getNodeIcon() == null) {
                    while (node.removeLastIcon() > 0) {
                    }
                } else {
                    node.addIcon(pattern.getNodeIcon());
                }
            }
            if (pattern.getAppliesToNodeFont()) {
                node.setFont(pattern.getNodeFont());
                node.estabilishOwnFont();
            }
        }
        if (pattern.getAppliesToEdge()) {
            EdgeAdapter edge = (EdgeAdapter)node.getEdge();
            edge.setColor(pattern.getEdgeColor());
            edge.setStyle(pattern.getEdgeStyle());
            edge.setWidth(pattern.getEdgeWidth());
        }
        if (pattern.getAppliesToChildren()) {
            ListIterator i = node.childrenUnfolded();
            while (i.hasNext()) {
                NodeAdapter child = (NodeAdapter)i.next();
                this.applyPattern(child, pattern.getChildrenStylePattern(), visible ? !node.isFolded() : false);
            }
        }
        if (visible) {
            this.nodeChanged(node);
        }
    }

    public boolean find(MindMapNode node, String what, boolean caseSensitive) {
        this.findNodesUnfoldedByLastFind = new ArrayList();
        LinkedList<MindMapNode> nodes = new LinkedList<MindMapNode>();
        nodes.addFirst(node);
        this.findFromNode = node;
        if (!caseSensitive) {
            what = what.toLowerCase();
        }
        return this.find(nodes, what, caseSensitive);
    }

    public boolean findNext() {
        if (this.findWhat != null) {
            return this.find(this.findNodeQueue, this.findWhat, this.findCaseSensitive);
        }
        return false;
    }

    private boolean find(LinkedList nodes, String what, boolean caseSensitive) {
        boolean thereWereNodesToBeFolded;
        boolean bl = thereWereNodesToBeFolded = !this.findNodesUnfoldedByLastFind.isEmpty();
        if (!this.findNodesUnfoldedByLastFind.isEmpty()) {
            ListIterator i = this.findNodesUnfoldedByLastFind.listIterator(this.findNodesUnfoldedByLastFind.size());
            while (i.hasPrevious()) {
                MindMapNode node = (MindMapNode)i.previous();
                try {
                    this.setFolded(node, true);
                }
                catch (Exception e) {}
            }
            this.findNodesUnfoldedByLastFind = new ArrayList();
        }
        while (!nodes.isEmpty()) {
            MindMapNode node = (MindMapNode)nodes.removeFirst();
            ListIterator i = node.childrenUnfolded();
            while (i.hasNext()) {
                nodes.addLast(i.next());
            }
            String nodeText = caseSensitive ? ((Object)node).toString() : ((Object)node).toString().toLowerCase();
            if (nodeText.indexOf(what) < 0) continue;
            this.displayNode(node, this.findNodesUnfoldedByLastFind);
            this.findWhat = what;
            this.findCaseSensitive = caseSensitive;
            this.findNodeQueue = nodes;
            return true;
        }
        if (thereWereNodesToBeFolded) {
            this.getFrame().getView().centerNode(this.findFromNode.getViewer());
        } else {
            this.getFrame().getView().scrollNodeToVisible(this.findFromNode.getViewer());
        }
        this.getFrame().getView().selectAsTheOnlyOneSelected(this.findFromNode.getViewer());
        this.frame.getController().obtainFocusForSelected();
        return false;
    }

    public void displayNode(MindMapNode node, ArrayList NodesUnfoldedByDisplay) {
        Object[] path = this.getPathToRoot(node);
        for (int i = 0; i < path.length - 1; ++i) {
            MindMapNode nodeOnPath = (MindMapNode)path[i];
            if (!nodeOnPath.isFolded()) continue;
            if (this.findNodesUnfoldedByLastFind != null) {
                this.findNodesUnfoldedByLastFind.add(nodeOnPath);
            }
            this.setFolded(nodeOnPath, false);
        }
        this.getFrame().getView().centerNode(node.getViewer());
        this.getFrame().getView().selectAsTheOnlyOneSelected(node.getViewer());
        this.frame.getController().obtainFocusForSelected();
    }

    protected void nodesWereRemoved(TreeNode parent, int[] childIndices, Object[] removedChildren) {
        this.setSaved(false);
        if (parent != null && childIndices != null) {
            this.fireTreeNodesRemoved(this, this.getPathToRoot((MindMapNode)parent), childIndices, removedChildren);
        }
    }

    protected void nodesWereInserted(TreeNode node, int[] childIndices) {
        if (this.treeModelListeners != null && node != null && childIndices != null && childIndices.length > 0) {
            this.setSaved(false);
            Object[] newChildren = new Object[childIndices.length];
            for (int counter = 0; counter < childIndices.length; ++counter) {
                newChildren[counter] = node.getChildAt(childIndices[counter]);
            }
            this.fireTreeNodesInserted(this, this.getPathToRoot((MindMapNode)node), childIndices, newChildren);
        }
    }

    protected void nodeChanged(TreeNode node) {
        this.frame.getController().getMode().getModeController().nodeChanged((MindMapNode)node);
        if (this.treeModelListeners != null && node != null) {
            TreeNode parent = node.getParent();
            if (parent != null) {
                int anIndex = parent.getIndex(node);
                if (anIndex != -1) {
                    int[] cIndexs = new int[]{anIndex};
                    this.nodesChanged(parent, cIndexs);
                }
            } else if (((MindMapNode)node).isRoot()) {
                this.nodesChanged(node, null);
            }
        }
    }

    protected void nodesChanged(TreeNode node, int[] childIndices) {
        this.setSaved(false);
        if (node != null) {
            if (childIndices != null) {
                int cCount = childIndices.length;
                if (cCount > 0) {
                    Object[] cChildren = new Object[cCount];
                    for (int counter = 0; counter < cCount; ++counter) {
                        cChildren[counter] = node.getChildAt(childIndices[counter]);
                    }
                    this.fireTreeNodesChanged(this, this.getPathToRoot(node), childIndices, cChildren);
                }
            } else if (((MindMapNode)node).isRoot()) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(node), null, null);
            }
        }
    }

    protected void nodeStructureChanged(TreeNode node) {
        this.setSaved(false);
        if (node != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
        }
    }

    protected void reload(TreeNode node) {
        if (node != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
        }
    }

    private void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.treeModelListeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? MapAdapter.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    private void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.treeModelListeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? MapAdapter.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    private void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.treeModelListeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? MapAdapter.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    private void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.treeModelListeners.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? MapAdapter.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

