<?php
//删除目录
function delete_dir($dir)
{
    if ($dh = opendir($dir))
    {
        while (($file = readdir($dh)) != false)
        {
            // 当遇到当前目录.与父目录..的时候不执行删除操作,继续循环。
            if (($file == '.') || ($file == '..'))
            {
                continue;
            }
            // 当前文件或目录的绝对路径。如果不是路径的话，会把当前目录的对应的文件或目录删掉。
            $dir_temp = $dir . '/' . $file;
            if (is_dir($dir_temp))
            {
                // 如果是目录，继续递归调用，进入此目录里面把目录里面的文件或目录删掉。
                delete_dir($dir_temp);
            }
            else
            {
                // 如果是文件则把文件删掉。
                unlink($dir_temp);
            }
        }
        // 关闭目录。
        closedir($dh);
        // 此时传入的目录的文件和子目录都已经被清空，这里可以把目录删掉。
        rmdir($dir);
    }
}
//创建订单
function createOrderId(){
    $time=date('YmdHis',time());
    $radnum=mt_rand(100,999);
    return $time.$radnum;
}
function IP($ip = '', $file = 'UTFWry.dat') {
	$_ip = array ();
	if (isset ( $_ip [$ip] )) {
		return $_ip [$ip];
	} else {
		import ( "ORG.Net.IpLocation" );
		$iplocation = new IpLocation ( $file );
		$location = $iplocation->getlocation ( $ip );
		$_ip [$ip] = $location ['country'] . $location ['area'];
	}
	return $_ip [$ip];
}
//将数组转化为树形数组   
 function arrToTree($data,$pid){  
        foreach($data as $k => $v){  
            if($v['pid'] == $pid){  
                $id.=arrToTree($data,$v['id']);  
                $id.=$v['id'].',';                
            }  
        }  
        return $id;
 } 
//根据ID获得分类名
function getCategoryName($id){
	if (empty ( $id )) {
		return '顶级分类';
	}
	$Category = D ( "Category" );
	$list = $Category->getField ( 'id,catname' );
	$name = $list [$id];
	return $name;
}
//根据ID获得模型名
function getModuleById($id){
	$Category = D ( "Category" );
	$list = $Category->getField ( 'id,modelname' );
	$module = $list [$id];
	return $module;
}
//公共函数
function toDate($time, $format = 'Y-m-d H:i:s') {
	if (empty ( $time )) {
		return '';
	}
	$format = str_replace ( '#', ':', $format );
	return date ($format, $time );
}
//MD5
function pwdHash($password, $type = 'md5') {
	return hash ( $type, $password );
}
function getOrderStatus($status, $imageShow = false) {
	switch ($status) {
                case - 1 :
			$showText = '删除';
			$showImg = '<img src="__PUBLIC__/Images/del.gif" width="20" height="20" border="0" alt="删除">';
			break;
		case 0 :
			$showText = '退货';
			$showImg = '<img src="__PUBLIC__/Images/locked.gif" width="20" height="20" border="0" alt="退货">';
			break;
		case 1 :
                        $showText = '<span style="color:#0066CC;">已发货</span>';
			$showImg = '<img src="__PUBLIC__/Images/ok.gif" width="20" height="20" border="0" alt="已发货">';
                        break;
                case 2 :
			$showText = '<strong style="color:#0066CC;">未发货</strong>';
			$showImg = '<img src="__PUBLIC__/Images/prected.gif" width="20" height="20" border="0" alt="未发货">';
			break;
                case 3 :
			$showText = '<strong style="color:#487C09;">交易完成</strong>';
			$showImg = '<img src="__PUBLIC__/Images/prected.gif" width="20" height="20" border="0" alt="交易完成">';
			break;
		default :
			$showText = '<span style="color:#0066CC;">已发货</span>';
			$showImg = '<img src="__PUBLIC__/Images/ok.gif" width="20" height="20" border="0" alt="已发货">';

	}
	return ($imageShow === true) ?  $showImg  : $showText;

}

//获取会员名称
function getMemberName($id){
    if($id==0){
        $name = '游客';
    }else{
        $Member = D ( "Member" );
        $list = $Member->getField ( 'id,name' );
        $name = $list [$id];
    }
    return $name;
}
